/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.UUID;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ChartLayout;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.ChartGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.dialog.NameObject;
import com.fr.report.FloatElement;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.CellUtils;
import com.fr.report.core.PaintUtils;
import com.fr.report.js.JavaScript;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.report.js.ReportletHyperlink;
import com.fr.report.js.WebHyperlink;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.web.Repository;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.service.ChartHtmlService;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ChartPainter
extends ChartLayout {
    private static final long serialVersionUID = 7601506246912210545L;
    public static final String XML_TAG = "CP";
    private List nameObjectList = new ArrayList();

    public void addGlyph(ChartGlyph chartGlyph) {
        this.addNamedGlyph("Default", chartGlyph);
    }

    public void addNamedGlyph(String string, ChartGlyph chartGlyph) {
        this.nameObjectList.add(new NameObject(string, chartGlyph));
    }

    public int getGlyphSize() {
        return this.nameObjectList.size();
    }

    public String getGlyphName(int n) {
        return ((NameObject)this.nameObjectList.get(n)).getName();
    }

    public ChartGlyph getGlyph(int n) {
        return (ChartGlyph)((NameObject)this.nameObjectList.get(n)).getObject();
    }

    public void removeAllGlyphs() {
        this.nameObjectList.clear();
    }

    public void paint(Graphics graphics, int n, int n2, Style style) {
        this.paintIndexGlyph(graphics, n, n2, style, this.getSelectedIndex());
    }

    private void paintIndexGlyph(Graphics graphics, int n, int n2, Style style, int n3) {
        if (n == 0 || n2 == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getGlyphSize() > 0) {
            int n4 = Math.min(Math.max(0, n3), this.getGlyphSize() - 1);
            ChartGlyph chartGlyph = this.getGlyph(n4);
            if (chartGlyph.isRoundBorder()) {
                chartGlyph.setBounds(new RoundRectangle2D.Double(0.0, 0.0, n, n2, 10.0, 10.0));
            } else {
                chartGlyph.setBounds(new Rectangle2D.Double(0.0, 0.0, n, n2));
            }
            chartGlyph.draw(graphics);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public Image paint4Float(FloatElement floatElement, ChartGlyph chartGlyph, int n, int n2) {
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        PaintUtils.paintBackground(graphics2D, floatElement.getStyle(), n - 1, n2 - 1);
        if (chartGlyph != null) {
            if (chartGlyph.isRoundBorder()) {
                chartGlyph.setBounds(new RoundRectangle2D.Double(0.0, 0.0, n - 1, n2 - 1, 10.0, 10.0));
            } else {
                chartGlyph.setBounds(new Rectangle2D.Double(0.0, 0.0, n - 1, n2 - 1));
            }
            chartGlyph.draw(graphics2D);
        }
        PaintUtils.paintBorder(graphics2D, floatElement.getStyle(), n - 1, n2 - 1);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public void paintTag(Repository repository, int n, int n2, Style style, Tag tag) {
        this.paintTag(repository, n, n2, style, tag, null);
    }

    public void paintTag(Repository repository, int n, int n2, Style style, Tag tag, FloatElement floatElement) {
        if (this.getGlyphSize() == 1 || !VT4FR.ADVANCED_CHART.support()) {
            ChartGlyph chartGlyph = this.getGlyph(0);
            PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
            if (plotGlyph.supportJSDrawing() && chartGlyph.isJSDraw() && VT4FR.DYNAMIC_CHART.support()) {
                tag.sub(this.getChartGlyphTag(repository, chartGlyph, n, n2));
                return;
            }
            Image image = null;
            image = floatElement == null ? CellUtils.value2Image((Object)this, style, n, n2) : this.paint4Float(floatElement, chartGlyph, n, n2);
            Tag tag2 = repository.checkoutImageTag(image, n, n2);
            tag.sub(tag2);
            if (plotGlyph != null && VT4FR.ADVANCED_CHART.support() && (plotGlyph.getHotHyperLink() != null || StringUtils.isNotEmpty(plotGlyph.getHotTooltip()))) {
                String string = "chart_hotmap_" + chartGlyph.getPlotGlyph().hashCode();
                tag2.attr("usemap", "#" + string);
                tag.sub(this.dealChartHot(chartGlyph, string, repository));
            }
        } else if (this.getGlyphSize() > 1) {
            JSONObject jSONObject = new JSONObject();
            try {
                JSONArray jSONArray = new JSONArray();
                int n3 = this.getGlyphSize();
                for (int i = 0; i < n3; ++i) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("name", this.getGlyphName(i));
                    ChartGlyph chartGlyph = this.getGlyph(i);
                    if (chartGlyph.isJSDraw() && chartGlyph.getPlotGlyph().supportJSDrawing()) {
                        jSONObject2.put("url", this.makeChartGlyphURL(repository, chartGlyph, n, n2));
                        jSONObject2.put("isJS", true);
                    } else {
                        Image image = null;
                        image = floatElement == null ? chartGlyph.toImage(n, n2) : this.paint4Float(floatElement, chartGlyph, n, n2);
                        jSONObject2.put("url", repository.checkoutImage(image));
                        PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
                        if (plotGlyph != null && VT4FR.ADVANCED_CHART.support() && (plotGlyph.getHotHyperLink() != null || StringUtils.isNotEmpty(plotGlyph.getHotTooltip()))) {
                            String string = "chart_hotmap_" + chartGlyph.getPlotGlyph().hashCode();
                            jSONObject2.put("usemap", "#" + string);
                            jSONObject2.put("mapHtml", this.dealChartHot(chartGlyph, string, repository).toHtml());
                        }
                    }
                    jSONArray.put(jSONObject2);
                }
                if (floatElement != null) {
                    jSONObject.put("isfloat", true);
                }
                jSONObject.put("items", jSONArray);
                jSONObject.put("type", "simplechart");
                jSONObject.put("chartWidth", n);
                jSONObject.put("chartHeight", n2);
                jSONObject.put("selectedIndex", this.getSelectedIndex());
                String string = UUID.randomUUID().toString();
                jSONObject.put("chartPaintID", string);
                HashMap<String, ChartPainter> hashMap = new HashMap<String, ChartPainter>();
                hashMap.put("chartPaint", this);
                ChartHtmlService.addMap2List(hashMap, string);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
            tag.attr("widget", jSONObject.toString());
        }
    }

    private Tag getChartGlyphTag(Repository repository, ChartGlyph chartGlyph, int n, int n2) {
        Tag tag = new Tag("iframe").attr("SRC", this.makeChartGlyphURL(repository, chartGlyph, n, n2)).css("width", n + "px").css("height", n2 + "px").attr("scrolling", "no").attr("marginheight", "0").attr("marginwidth", "0").attr("allowTransparency", "true").attr("frameborder", "0");
        return tag;
    }

    private String makeChartGlyphURL(Repository repository, ChartGlyph chartGlyph, double d, double d2) {
        Cloneable cloneable;
        String string = UUID.randomUUID().toString();
        JSONObject jSONObject = null;
        try {
            jSONObject = chartGlyph.toJSONObject();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        String string2 = "";
        PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
        if (plotGlyph != null && (plotGlyph.getHotHyperLink() != null || StringUtils.isNotEmpty(plotGlyph.getHotTooltip()))) {
            chartGlyph.toImage((int)d, (int)d2);
            cloneable = repository.checkoutImageTag(GraphHelper.createBufferedImage((int)d, (int)d2, 6), (int)d, (int)d2);
            String string3 = "chart_hotmap_" + chartGlyph.getPlotGlyph().hashCode();
            ((Tag)cloneable).attr("usemap", "#" + string3);
            string2 = ((Tag)cloneable).toString() + this.dealChartHot(chartGlyph, string3, repository).toString();
        }
        cloneable = new HashMap<String, String>();
        cloneable.put("chartAttr", jSONObject.toString());
        cloneable.put("width", String.valueOf(d));
        cloneable.put("height", String.valueOf(d2));
        cloneable.put("id", string);
        cloneable.put("img", string2);
        ChartHtmlService.addMap2List((Map)((Object)cloneable), string);
        return repository.getServletURL() + "?op=charthtml&chartID=" + string;
    }

    private Tag dealChartHot(ChartGlyph chartGlyph, String string, Repository repository) {
        PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
        Tag tag = new Tag("map");
        tag.attr("name", string);
        tag.attr("id", string);
        int n = 0;
        int n2 = plotGlyph.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = plotGlyph.getSeries(i);
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                Tag tag2 = dataPoint.getImageMapAreaTag(chartGlyph);
                if (tag2 == null) continue;
                tag.sub(tag2);
                tag2.attr("id", n + "");
                if (plotGlyph.getHotHyperLink() != null) {
                    this.dealChartHotHyperLink(plotGlyph.getHotHyperLink(), dataPoint, repository, tag2);
                }
                if (plotGlyph.getHotTooltip() != null) {
                    this.dealChartHotTooltip(plotGlyph.getHotTooltip(), dataPoint, repository, tag2);
                }
                ++n;
            }
        }
        return tag;
    }

    private void dealChartHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup, DataPoint dataPoint, Repository repository, Tag tag) {
        if (nameJavaScriptGroup != null) {
            NameJavaScriptGroup nameJavaScriptGroup2 = null;
            try {
                nameJavaScriptGroup2 = (NameJavaScriptGroup)nameJavaScriptGroup.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            int n = nameJavaScriptGroup2.size();
            for (int i = 0; i < n; ++i) {
                Parameter[] parameterArray;
                JavaScript javaScript = nameJavaScriptGroup2.getNameHyperlink(i).getJavaScript();
                if (javaScript instanceof ReportletHyperlink) {
                    parameterArray = ((ReportletHyperlink)javaScript).getParameters();
                    this.dealParameter4Hyperlink(parameterArray, dataPoint, repository);
                }
                if (!(javaScript instanceof WebHyperlink)) continue;
                parameterArray = ((WebHyperlink)javaScript).getParameters();
                this.dealParameter4Hyperlink(parameterArray, dataPoint, repository);
            }
            try {
                repository.getBrowser().setHrefOnArea(tag);
                tag.attr("onclick", "FR.doHyperlink(event||window.event, " + HTMLWriterUtils.writeJSLinkContent(nameJavaScriptGroup2, repository) + ", true)");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    private void dealParameter4Hyperlink(Parameter[] parameterArray, DataPoint dataPoint, Repository repository) {
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                Object object;
                Parameter parameter = parameterArray[i];
                Object object2 = parameter.getValue();
                if (!(object2 instanceof Formula)) continue;
                try {
                    String string = ((Formula)object2).getContent();
                    if (string.startsWith("=")) {
                        string = string.substring(1);
                    }
                    object = dataPoint.getCalculator();
                    if (repository.getSessionIDInfor() != null) {
                        ((Calculator)object).setCurrentReport(repository.getSessionIDInfor().getWorkBook2Show().getReport(0));
                        ((Calculator)object).setCurrentTableDataSource(repository.getSessionIDInfor().getContextBook());
                    }
                    parameter.setValue(((Calculator)object).eval(string).toString());
                    continue;
                }
                catch (Exception exception) {
                    object = "error happens at calculating formula";
                    throw new RuntimeException((String)object, exception);
                }
            }
        }
    }

    private void dealChartHotTooltip(String string, DataPoint dataPoint, Repository repository, Tag tag) {
        String string2 = "";
        try {
            string2 = dataPoint.getCalculator().renderTpl(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        tag.attr("title", CodeUtils.htmlEncode(string2));
    }

    public Object clone() throws CloneNotSupportedException {
        ChartPainter chartPainter = (ChartPainter)super.clone();
        if (this.nameObjectList != null) {
            chartPainter.nameObjectList = new ArrayList();
            int n = this.getGlyphSize();
            for (int i = 0; i < n; ++i) {
                chartPainter.nameObjectList.add(new NameObject(this.getGlyphName(i), (ChartGlyph)this.getGlyph(i).clone()));
            }
        }
        return chartPainter;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.nameObjectList != null && this.getGlyphSize() > 0) {
            for (int i = 0; i < this.nameObjectList.size(); ++i) {
                xMLPrintWriter.startTAG("NameGlyph");
                xMLPrintWriter.startTAG("Name").attr("value", this.getGlyphName(i)).end();
                this.getGlyph(i).writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("NameGlyph")) {
            xMLableReader.readXMLObject(new XMLReadable(){
                String glyphName = null;
                ChartGlyph glyph = null;

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        String string;
                        String string2 = xMLableReader.getTagName();
                        if (string2.equals("Name") && (string = xMLableReader.getAttr("value")) != null) {
                            this.glyphName = string;
                        }
                        if (string2.equals("ChartGlyph")) {
                            this.glyph = (ChartGlyph)xMLableReader.readXMLObject(new ChartGlyph());
                        }
                        if (this.glyphName != null && this.glyph != null) {
                            ChartPainter.this.addNamedGlyph(this.glyphName, this.glyph);
                        }
                    }
                }
            });
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChartPainter)) {
            return false;
        }
        ChartPainter chartPainter = (ChartPainter)object;
        if (!super.equals(chartPainter)) {
            return false;
        }
        if (chartPainter.getGlyphSize() != this.getGlyphSize()) {
            return false;
        }
        for (int i = 0; i < chartPainter.getGlyphSize(); ++i) {
            if (Equals.equals(this.getGlyph(i), chartPainter.getGlyph(i))) continue;
            return false;
        }
        return true;
    }
}

