/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.XMLable;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.GlyphCondition;
import com.fr.chart.axis.SeriesAttrAlpha;
import com.fr.chart.axis.SeriesAttrBorder;
import com.fr.chart.axis.SeriesAttrColor;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.plot.SeriesCollection;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;

public class ColorInfo
implements XMLable,
GlyphCondition {
    private static final long serialVersionUID = -2219673427793792660L;
    public static final String XML_TAG = "ColorInfo";
    private SeriesAttrAlpha seriesAttrAlpha = new SeriesAttrAlpha();
    private SeriesAttrBorder seriesAttrBorder = new SeriesAttrBorder();
    private SeriesAttrColor seriesAttrColor = new SeriesAttrColor();

    public void setSeriesColor(Color color) {
        this.getSeriesAttrColor().setSeriesColor(color);
    }

    public Color getSeriesColor() {
        return this.getSeriesAttrColor().getSeriesColor();
    }

    public void setSeriesAttrColor(SeriesAttrColor seriesAttrColor) {
        this.seriesAttrColor = seriesAttrColor;
    }

    public SeriesAttrColor getSeriesAttrColor() {
        return this.seriesAttrColor;
    }

    public void setBorderLineStyle(int n) {
        this.getSeriesAttrBorder().setBorderStyle(n);
    }

    public int getBorderLineStyle() {
        return this.getSeriesAttrBorder().getBorderStyle();
    }

    public void setBorderLineColor(Color color) {
        this.getSeriesAttrBorder().setBorderColor(color);
    }

    public Color getBorderLineColor() {
        return this.getSeriesAttrBorder().getBorderColor();
    }

    public void setSeriesAttrBorder(SeriesAttrBorder seriesAttrBorder) {
        this.seriesAttrBorder = seriesAttrBorder;
    }

    public SeriesAttrBorder getSeriesAttrBorder() {
        return this.seriesAttrBorder;
    }

    public void setDefaultAlpha(float f) {
        this.getSeriesAttrAlpha().setAlpha(f);
    }

    public float getDefaultAlpha() {
        return this.getSeriesAttrAlpha().getAlpha();
    }

    public void setSeriesAttrAlpha(SeriesAttrAlpha seriesAttrAlpha) {
        this.seriesAttrAlpha = seriesAttrAlpha;
    }

    public SeriesAttrAlpha getSeriesAttrAlpha() {
        return this.seriesAttrAlpha;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getDefaultAlpha()));
        if (this.getSeriesColor() != null) {
            graphics2D.setPaint(this.getSeriesColor());
            graphics2D.fill(shape);
        }
        if (this.getBorderLineStyle() != 0 && this.getBorderLineColor() != null) {
            graphics2D.setPaint(this.getBorderLineColor());
            GraphHelper.draw(graphics2D, shape, this.getBorderLineStyle());
        }
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            String string2 = xMLableReader.getAttr("borderStyle");
            if (string2 != null) {
                this.setBorderLineStyle(Integer.parseInt(string2));
            }
            if ((string2 = xMLableReader.getAttr("borderColor")) != null) {
                this.setBorderLineColor(new Color(Integer.parseInt(string2), true));
            }
            if ((string2 = xMLableReader.getAttr("seriesColor")) != null) {
                this.setSeriesColor(new Color(Integer.parseInt(string2), true));
            }
            if ((string2 = xMLableReader.getAttr("defaultAlpha")) != null) {
                this.setDefaultAlpha(Float.parseFloat(string2));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("borderStyle", this.getBorderLineStyle());
        if (this.getBorderLineColor() != null) {
            xMLPrintWriter.attr("borderColor", this.getBorderLineColor().getRGB());
        }
        if (this.getSeriesColor() != null) {
            xMLPrintWriter.attr("seriesColor", this.getSeriesColor().getRGB());
        }
        xMLPrintWriter.attr("defaultAlpha", this.getDefaultAlpha());
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ColorInfo colorInfo = (ColorInfo)super.clone();
        return colorInfo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorInfo)) {
            return false;
        }
        ColorInfo colorInfo = (ColorInfo)object;
        if (colorInfo.getBorderLineStyle() != this.getBorderLineStyle()) {
            return false;
        }
        if (!Equals.equals(colorInfo.getBorderLineColor(), this.getBorderLineColor())) {
            return false;
        }
        if (!Equals.equals(colorInfo.getSeriesColor(), this.getSeriesColor())) {
            return false;
        }
        return colorInfo.getDefaultAlpha() == this.getDefaultAlpha();
    }

    public void dealCondition(SeriesCollection seriesCollection, int n) {
        SeriesAttrColor seriesAttrColor = (SeriesAttrColor)seriesCollection.getSeriesCondition(new SeriesAttrColor(), n);
        this.setSeriesColor(seriesAttrColor.getSeriesColor());
        SeriesAttrBorder seriesAttrBorder = (SeriesAttrBorder)seriesCollection.getSeriesCondition(new SeriesAttrBorder(), n);
        this.setBorderLineColor(seriesAttrBorder.getBorderColor());
        this.setBorderLineStyle(seriesAttrBorder.getBorderStyle());
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)seriesCollection.getSeriesCondition(new SeriesAttrAlpha(), n);
        this.setDefaultAlpha(seriesAttrAlpha.getAlpha());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.seriesAttrAlpha != null) {
            jSONObject.put("seriesAttrAlpha", this.seriesAttrAlpha.toJSONObject());
        }
        if (this.seriesAttrBorder != null) {
            jSONObject.put("seriesAttrBorder", this.seriesAttrBorder.toJSONObject());
        }
        if (this.seriesAttrColor != null) {
            jSONObject.put("seriesAttrColor", this.seriesAttrColor.toJSONObject());
        }
        return jSONObject;
    }
}

