/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.XMLable;
import com.fr.base.background.Background;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.GlyphCondition;
import com.fr.chart.axis.SeriesAttrAlpha;
import com.fr.chart.axis.SeriesAttrBackground;
import com.fr.chart.axis.SeriesAttrBorder;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.Shadow;
import com.fr.chart.plot.SeriesCollection;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;

public class GeneralInfo
implements XMLable,
GlyphCondition {
    private static final long serialVersionUID = 8432362457441903617L;
    public static final String XML_TAG = "GI";
    private SeriesAttrAlpha seriesAttrAlpha = new SeriesAttrAlpha();
    private SeriesAttrBorder seriesAttrBorder = new SeriesAttrBorder();
    private SeriesAttrBackground seriesAttrBackground = new SeriesAttrBackground();
    Shadow shadow = null;

    public GeneralInfo() {
    }

    public GeneralInfo(Background background, Color color, int n, float f) {
        this.getSeriesAttrBackground().setSeriesBackground(background);
        this.getSeriesAttrBorder().setBorderColor(color);
        this.getSeriesAttrBorder().setBorderStyle(n);
        this.getSeriesAttrAlpha().setAlpha(f);
    }

    public Background getBackground() {
        return this.getSeriesAttrBackground().getSeriesBackground();
    }

    public void setBackground(Background background) {
        this.getSeriesAttrBackground().setSeriesBackground(background);
    }

    public void setSeriesAttrAlpha(SeriesAttrAlpha seriesAttrAlpha) {
        this.seriesAttrAlpha = seriesAttrAlpha;
    }

    public SeriesAttrAlpha getSeriesAttrAlpha() {
        return this.seriesAttrAlpha;
    }

    public void setSeriesAttrBorder(SeriesAttrBorder seriesAttrBorder) {
        this.seriesAttrBorder = seriesAttrBorder;
    }

    public SeriesAttrBorder getSeriesAttrBorder() {
        return this.seriesAttrBorder;
    }

    public void setSeriesAttrBackground(SeriesAttrBackground seriesAttrBackground) {
        this.seriesAttrBackground = seriesAttrBackground;
    }

    public SeriesAttrBackground getSeriesAttrBackground() {
        return this.seriesAttrBackground;
    }

    public Shadow getShadow() {
        return this.shadow;
    }

    public void setShadow(Shadow shadow) {
        this.shadow = shadow;
    }

    public int getBorderStyle() {
        return this.getSeriesAttrBorder().getBorderStyle();
    }

    public void setBorderStyle(int n) {
        this.getSeriesAttrBorder().setBorderStyle(n);
    }

    public boolean isRoundBorder() {
        return this.getSeriesAttrBorder().isRoundBorder();
    }

    public void setRoundBorder(boolean bl) {
        this.getSeriesAttrBorder().setRoundBorder(bl);
    }

    public Color getBorderColor() {
        return this.getSeriesAttrBorder().getBorderColor();
    }

    public void setBorderColor(Color color) {
        this.getSeriesAttrBorder().setBorderColor(color);
    }

    public float getAlpha() {
        return this.getSeriesAttrAlpha().getAlpha();
    }

    public void setAlpha(float f) {
        this.getSeriesAttrAlpha().setAlpha(f);
    }

    public void paint(Graphics graphics, Shape shape) {
        Shadow shadow;
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        int n = this.getBorderStyle();
        if (this.getBackground() != null) {
            this.getBackground().paint(graphics2D, shape);
        }
        if ((shadow = this.getShadow()) != null) {
            shadow.setShape(shape);
            if (n != 0) {
                shadow.setOffset(GraphHelper.getLineStyleSize(n));
            }
            shadow.paint(graphics2D);
        }
        if (n != 0) {
            graphics2D.setPaint(this.getBorderColor());
            GraphHelper.draw(graphics2D, shape, n);
        }
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public void dealCondition(SeriesCollection seriesCollection, int n) {
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)seriesCollection.getSeriesCondition(new SeriesAttrAlpha(), n);
        this.setSeriesAttrAlpha(seriesAttrAlpha);
        SeriesAttrBackground seriesAttrBackground = (SeriesAttrBackground)seriesCollection.getSeriesCondition(new SeriesAttrBackground(), n);
        this.setSeriesAttrBackground(seriesAttrBackground);
        SeriesAttrBorder seriesAttrBorder = (SeriesAttrBorder)seriesCollection.getSeriesCondition(new SeriesAttrBorder(), n);
        this.setSeriesAttrBorder(seriesAttrBorder);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneralInfo)) {
            return false;
        }
        GeneralInfo generalInfo = (GeneralInfo)object;
        if (!Equals.equals(generalInfo.seriesAttrBackground, this.seriesAttrBackground)) {
            return false;
        }
        if (!Equals.equals(generalInfo.seriesAttrAlpha, this.seriesAttrAlpha)) {
            return false;
        }
        return Equals.equals(generalInfo.seriesAttrBorder, this.seriesAttrBorder);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("SeriesAttrAlpha")) {
                this.seriesAttrAlpha = (SeriesAttrAlpha)xMLableReader.readXMLObject(new SeriesAttrAlpha());
            }
            if (string2.equals("SeriesAttrBackground")) {
                this.seriesAttrBackground = (SeriesAttrBackground)xMLableReader.readXMLObject(new SeriesAttrBackground());
            }
            if (string2.equals("SeriesAttrBorder")) {
                this.seriesAttrBorder = (SeriesAttrBorder)xMLableReader.readXMLObject(new SeriesAttrBorder());
            }
            if (string2.equals("Background")) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            } else if (string2.equals("Border")) {
                String string3 = xMLableReader.getAttr("style");
                if (string3 != null) {
                    this.setBorderStyle(Integer.parseInt(string3));
                }
                if ((string3 = xMLableReader.getAttr("color")) != null) {
                    this.setBorderColor(new Color(Integer.parseInt(string3), true));
                }
            } else if (string2.equals("Alpha") && (string = xMLableReader.getAttr("value")) != null) {
                this.setAlpha(Float.parseFloat(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.seriesAttrBackground != null) {
            this.seriesAttrBackground.writeXML(xMLPrintWriter);
        }
        if (this.seriesAttrBorder != null) {
            this.seriesAttrBorder.writeXML(xMLPrintWriter);
        }
        if (this.seriesAttrAlpha != null) {
            this.seriesAttrAlpha.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralInfo generalInfo = (GeneralInfo)super.clone();
        if (this.seriesAttrBackground != null) {
            generalInfo.setSeriesAttrBackground((SeriesAttrBackground)this.seriesAttrBackground.clone());
        }
        if (this.seriesAttrAlpha != null) {
            generalInfo.setSeriesAttrAlpha((SeriesAttrAlpha)this.seriesAttrAlpha.clone());
        }
        if (this.seriesAttrBorder != null) {
            generalInfo.setSeriesAttrBorder((SeriesAttrBorder)this.seriesAttrBorder.clone());
        }
        return generalInfo;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.seriesAttrAlpha != null) {
            jSONObject.put("seriesAttrAlpha", this.seriesAttrAlpha.toJSONObject());
        }
        if (this.seriesAttrBorder != null) {
            jSONObject.put("seriesAttrBorder", this.seriesAttrBorder.toJSONObject());
        }
        if (this.seriesAttrBackground != null) {
            jSONObject.put("seriesAttrBackground", this.seriesAttrBackground.toJSONObject());
        }
        return jSONObject;
    }
}

