/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.XMLable;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.GlyphCondition;
import com.fr.chart.axis.SeriesAttrAlpha;
import com.fr.chart.axis.SeriesAttrLine;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartCoreConstants;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.plot.SeriesCollection;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;

public class LineStyleInfo
implements XMLable,
GlyphCondition {
    private static final long serialVersionUID = -5616374725367075547L;
    public static final String XML_TAG = "LineStyleInfo";
    private SeriesAttrLine seriesAttrLine = new SeriesAttrLine();
    private SeriesAttrAlpha seriesAttrAlpha = new SeriesAttrAlpha();

    public LineStyleInfo() {
    }

    public LineStyleInfo(int n) {
        this.seriesAttrLine.setSeriesLineColor((Color)ChartUtils.getObject(n, ChartCoreConstants.CHART_COLOR_ARRAY));
    }

    public void setDefaultAlpha(float f) {
        this.getSeriesAttrAlpha().setAlpha(f);
    }

    public float getDefaultAlpha() {
        return this.getSeriesAttrAlpha().getAlpha();
    }

    public void setSeriesAttrAlpha(SeriesAttrAlpha seriesAttrAlpha) {
        this.seriesAttrAlpha = seriesAttrAlpha;
    }

    public SeriesAttrAlpha getSeriesAttrAlpha() {
        return this.seriesAttrAlpha;
    }

    public void setSeriesLineColor(Color color) {
        this.seriesAttrLine.setSeriesLineColor(color);
    }

    public Color getSeriesLineColor() {
        return this.seriesAttrLine.getSeriesLineColor();
    }

    public void setSeriesLineStyle(int n) {
        this.seriesAttrLine.setSeriesLineStyle(n);
    }

    public int getSeriesLineStyle() {
        return this.seriesAttrLine.getSeriesLineStyle();
    }

    public void setSeriesAttrLine(SeriesAttrLine seriesAttrLine) {
        this.seriesAttrLine = seriesAttrLine;
    }

    public SeriesAttrLine getSeriesAttrLine() {
        return this.seriesAttrLine;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (shape == null || this.getSeriesLineColor() == null || this.getSeriesLineStyle() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setPaint(this.getSeriesLineColor());
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getDefaultAlpha()));
        GraphHelper.draw(graphics2D, shape, this.getSeriesLineStyle());
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            String string2 = xMLableReader.getAttr("alpha");
            if (string2 != null) {
                this.setDefaultAlpha(Float.parseFloat(string2));
            }
            if ((string2 = xMLableReader.getAttr("lineStyle")) != null) {
                this.setSeriesLineStyle(Integer.parseInt(string2));
            }
            if ((string2 = xMLableReader.getAttr("lineColor")) != null) {
                this.setSeriesLineColor(new Color(Integer.parseInt(string2), true));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("alpha", this.getDefaultAlpha()).attr("lineStyle", this.getSeriesLineStyle());
        if (this.getSeriesLineColor() != null) {
            xMLPrintWriter.attr("lineColor", this.getSeriesLineColor().getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        LineStyleInfo lineStyleInfo = (LineStyleInfo)super.clone();
        return lineStyleInfo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineStyleInfo)) {
            return false;
        }
        LineStyleInfo lineStyleInfo = (LineStyleInfo)object;
        if (lineStyleInfo.getDefaultAlpha() != this.getDefaultAlpha()) {
            return false;
        }
        if (lineStyleInfo.getSeriesLineStyle() != this.getSeriesLineStyle()) {
            return false;
        }
        return Equals.equals(lineStyleInfo.getSeriesLineColor(), this.getSeriesLineColor());
    }

    public void dealCondition(SeriesCollection seriesCollection, int n) {
        SeriesAttrLine seriesAttrLine = (SeriesAttrLine)seriesCollection.getSeriesCondition(new SeriesAttrLine(), n);
        this.setSeriesAttrLine(seriesAttrLine);
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)seriesCollection.getSeriesCondition(new SeriesAttrAlpha(), n);
        this.setSeriesAttrAlpha(seriesAttrAlpha);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.seriesAttrAlpha != null) {
            jSONObject.put("seriesAttrAlpha", this.seriesAttrAlpha.toJSONObject());
        }
        if (this.seriesAttrLine != null) {
            jSONObject.put("seriesAttrLine", this.seriesAttrLine.toJSONObject());
        }
        return jSONObject;
    }
}

