/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.FRFont;
import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ChartModule;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.util.Utils;

public class Title
extends ChartModule
implements XMLable {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "Title";
    private Object text = "";
    private TextAttr textAttr = new TextAttr();
    private boolean titleVisble = true;

    public Title() {
        FRFont fRFont = FRFont.getInstance();
        fRFont = fRFont.applyStyle(3);
        this.textAttr.setFRFont(fRFont);
    }

    public Title(Object object) {
        this.setTextObject(object);
    }

    public TextGlyph createGlyph() {
        if (!this.getTitleVisble()) {
            return null;
        }
        String string = Utils.objectToString(this.text);
        TextGlyph textGlyph = new TextGlyph(string, this.textAttr);
        textGlyph.setInfo(this.getInfo());
        return textGlyph;
    }

    public Object getTextObject() {
        return this.text;
    }

    public void setTextObject(Object object) {
        this.text = object;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setTitleVisble(boolean bl) {
        this.titleVisble = bl;
    }

    public boolean getTitleVisble() {
        return this.titleVisble;
    }

    public Object clone() throws CloneNotSupportedException {
        Title title = (Title)super.clone();
        if (this.getTextAttr() != null) {
            title.setTextAttr((TextAttr)this.getTextAttr().clone());
        }
        return title;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("O".equals(string2)) {
                this.text = ReportXMLUtils.readObject(xMLableReader);
            } else if ("TextAttr".equals(string2)) {
                this.textAttr = new TextAttr();
                xMLableReader.readXMLObject(this.textAttr);
            } else if ("TitleVisible".equals(string2) && (string = xMLableReader.getAttr("value")) != null) {
                this.setTitleVisble(Boolean.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.text != null) {
            ReportXMLUtils.writeObject(xMLPrintWriter, this.text);
        }
        if (this.textAttr != null) {
            this.textAttr.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("TitleVisible").attr("value", this.titleVisble).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Title)) {
            return false;
        }
        Title title = (Title)object;
        if (!super.equals(title)) {
            return false;
        }
        if (!Equals.equals(title.getTextObject(), this.getTextObject())) {
            return false;
        }
        if (!Equals.equals(title.getTextAttr(), this.getTextAttr())) {
            return false;
        }
        return title.getTitleVisble() == this.getTitleVisble();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.textAttr != null) {
            jSONObject.put("textAttr", this.textAttr.toJSONObject());
        }
        jSONObject.put("text", this.text);
        jSONObject.put("titleVisble", this.titleVisble);
        return jSONObject;
    }
}

