/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.axis;

import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.Title;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Color;
import java.text.Format;

public abstract class Axis
implements XMLable {
    private static final long serialVersionUID = 3591400366172688862L;
    public static final String XML_TAG = "Axis";
    public static final int TICK_MARK_NONE = 0;
    public static final int TICK_MARK_INSIDE = 1;
    public static final int TICK_MARK_OUTSIDE = 2;
    public static final int TICK_MARK_CROSS = 3;
    protected int tickMarkType = 2;
    private int tickLength = 8;
    private int secTickMarkType = 1;
    private int secTickLength = 0;
    private float mainStroke = 1.0f;
    private float secStroke = 1.0f;
    public static final int LINE_LABEL_GAP = 4;
    public static final int LABEL_TITLE_GAP = 1;
    protected int position = 3;
    private Title title;
    private int mainGridStyle = 0;
    private Color mainGridColor = null;
    private int secondGridStyle = 0;
    private Color secondGridColor = null;
    protected Color lineColor = new Color(176, 176, 176);
    protected int lineStyle = 1;
    private TextAttr textAttr = new TextAttr();
    private Format format;
    private boolean isStagger = false;
    private int labelNumber = -1;
    private int axisLabelPosition = 3;
    private boolean isArrowShow = false;
    private boolean isAxisShow = true;
    private boolean isCustomMinValue = false;
    private double minValue = 0.0;
    private boolean isCustomMaxValue = false;
    private double maxValue = 0.0;

    public void setCustomMinValue(boolean bl) {
        this.isCustomMinValue = bl;
    }

    public boolean isCustomMinValue() {
        return this.isCustomMinValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setCustomMaxValue(boolean bl) {
        this.isCustomMaxValue = bl;
    }

    public boolean isCustomMaxValue() {
        return this.isCustomMaxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setAxisShow(boolean bl) {
        this.isAxisShow = bl;
    }

    public boolean isAxisShow() {
        return this.isAxisShow;
    }

    public void setArrowShow(boolean bl) {
        this.isArrowShow = bl;
    }

    public boolean isArrowShow() {
        return this.isArrowShow;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public void setAxisLabelPosition(int n) {
        this.axisLabelPosition = n;
    }

    public int getAxisLabelPosition() {
        return this.axisLabelPosition;
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public void setMainGridStyle(int n) {
        this.mainGridStyle = n;
    }

    public int getMainGridStyle() {
        return this.mainGridStyle;
    }

    public void setMainGridColor(Color color) {
        this.mainGridColor = color;
    }

    public Color getMainGridColor() {
        return this.mainGridColor;
    }

    public void setSecondGridStyle(int n) {
        this.secondGridStyle = n;
    }

    public int getSecondGridStyle() {
        return this.secondGridStyle;
    }

    public void setSecondGridColor(Color color) {
        this.secondGridColor = color;
    }

    public Color getSecondGridColor() {
        return this.secondGridColor;
    }

    public void setLabelNumber(int n) {
        this.labelNumber = n;
    }

    public int getLabelNumber() {
        return this.labelNumber;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getTickMarkType() {
        return this.tickMarkType;
    }

    public void setTickMarkType(int n) {
        this.tickMarkType = n;
    }

    public void setTickLength(int n) {
        this.tickLength = n;
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public void setSecTickMarkType(int n) {
        this.secTickMarkType = n;
    }

    public void setMainStroke(float f) {
        this.mainStroke = f;
    }

    public float getMainStroke() {
        return this.mainStroke;
    }

    public void setSecStroke(float f) {
        this.secStroke = f;
    }

    public float getSecStroke() {
        return this.secStroke;
    }

    public int getSecTickMarkType() {
        return this.secTickMarkType;
    }

    public void setSecTickLength(int n) {
        this.secTickLength = n;
    }

    public int getSecTickLength() {
        return this.secTickLength;
    }

    public void setIsStagger(boolean bl) {
        this.isStagger = bl;
    }

    public boolean isStagger() {
        return this.isStagger;
    }

    public static double calculateIncrement(double d, double d2) {
        double d3 = 1.0;
        double d4 = 0.0;
        d3 = (d2 - d) / 3.0;
        double d5 = 1.0;
        if (d3 % 1.0 == 0.0) {
            return d3;
        }
        if (d3 <= 1.0) {
            d4 = Math.pow(10.0, Math.ceil(Math.log(1.0 / d3) / Math.log(10.0)));
            d5 = 1.0 / d4;
            d3 *= d4;
        }
        if (d3 > 10.0) {
            d5 = d4 = Math.pow(10.0, Math.ceil(Math.log(d3) / Math.log(10.0)) - 1.0);
            d3 /= d4;
        }
        if (d3 <= 2.0) {
            d3 = 1.0;
        } else if (d3 <= 4.0) {
            d3 = 2.0;
        } else if (d3 <= 10.0) {
            d3 = 4.0;
        }
        return d3 *= d5;
    }

    public Object clone() throws CloneNotSupportedException {
        Axis axis = (Axis)super.clone();
        if (this.getTitle() != null) {
            axis.setTitle((Title)this.getTitle().clone());
        }
        if (this.getTextAttr() != null) {
            axis.setTextAttr((TextAttr)this.getTextAttr().clone());
        }
        if (this.getFormat() != null) {
            axis.setFormat((Format)this.getFormat().clone());
        }
        return axis;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Title")) {
                Title title = new Title();
                xMLableReader.readXMLObject(title);
                this.setTitle(title);
            } else if ("TickLine".equals(string)) {
                String string2 = xMLableReader.getAttr("type");
                if (string2 != null) {
                    this.setTickMarkType(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("len")) != null) {
                    this.setTickLength(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("mainStroke")) != null) {
                    this.setMainStroke(Float.valueOf(string2).floatValue());
                }
                if ((string2 = xMLableReader.getAttr("secType")) != null) {
                    this.setSecTickMarkType(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("secLen")) != null) {
                    this.setSecTickLength(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("secStroke")) != null) {
                    this.setSecStroke(Float.valueOf(string2).floatValue());
                }
            } else if (string.equals("AxisLabelCount")) {
                String string3 = xMLableReader.getAttr("value");
                if (string3 != null) {
                    this.setLabelNumber(Integer.parseInt(string3));
                }
            } else if ("AxisLine".equals(string)) {
                String string4 = xMLableReader.getAttr("style");
                if (string4 != null) {
                    this.setLineStyle(Integer.parseInt(string4));
                }
                if ((string4 = xMLableReader.getAttr("color")) != null) {
                    this.setLineColor(new Color(Integer.parseInt(string4), true));
                } else {
                    this.setLineColor(null);
                }
            } else if ("MainGridLine".equals(string)) {
                String string5 = xMLableReader.getAttr("style");
                if (string5 != null) {
                    this.setMainGridStyle(Integer.parseInt(string5));
                }
                if ((string5 = xMLableReader.getAttr("color")) != null) {
                    this.setMainGridColor(new Color(Integer.parseInt(string5), true));
                } else {
                    this.setMainGridColor(null);
                }
            } else if ("SecGridLine".equals(string)) {
                String string6 = xMLableReader.getAttr("style");
                if (string6 != null) {
                    this.setSecondGridStyle(Integer.parseInt(string6));
                }
                if ((string6 = xMLableReader.getAttr("color")) != null) {
                    this.setSecondGridColor(new Color(Integer.parseInt(string6), true));
                } else {
                    this.setSecondGridColor(null);
                }
            } else if ("TextAttr".equals(string)) {
                this.setTextAttr((TextAttr)xMLableReader.readXMLObject(new TextAttr()));
            } else if (string.equals("Format")) {
                this.setFormat(ReportXMLUtils.readFormat(xMLableReader));
            } else if (string.equals("ArrowShow")) {
                String string7 = xMLableReader.getAttr("arrowShow");
                if (string7 != null) {
                    this.setArrowShow(Boolean.valueOf(string7));
                }
            } else if (string.equals("AxisShow")) {
                String string8 = xMLableReader.getAttr("axisShow");
                if (string8 != null) {
                    this.setAxisShow(Boolean.valueOf(string8));
                }
            } else if (string.equals("Stagger")) {
                String string9 = xMLableReader.getAttr("value");
                if (string9 != null) {
                    this.setIsStagger(Boolean.valueOf(string9));
                }
            } else if (string.equals("AxisPosition")) {
                String string10 = xMLableReader.getAttr("value");
                if (string10 != null) {
                    this.setPosition(Integer.valueOf(string10));
                }
            } else if (string.equals("AxisLabelPosition")) {
                String string11 = xMLableReader.getAttr("value");
                if (string11 != null) {
                    this.setAxisLabelPosition(Integer.valueOf(string11));
                }
            } else if (string.equals("AxisRange")) {
                String string12 = xMLableReader.getAttr("minValue");
                if (string12 != null) {
                    this.setCustomMinValue(true);
                    this.setMinValue(Double.parseDouble(string12));
                }
                if ((string12 = xMLableReader.getAttr("maxValue")) != null) {
                    this.setCustomMaxValue(true);
                    this.setMaxValue(Double.parseDouble(string12));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.getTitle() != null) {
            this.getTitle().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("AxisLine").attr("style", this.getLineStyle());
        if (this.getLineColor() != null) {
            xMLPrintWriter.attr("color", this.getLineColor().getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("AxisPosition").attr("value", this.getPosition()).end();
        xMLPrintWriter.startTAG("AxisLabelPosition").attr("value", this.getAxisLabelPosition()).end();
        xMLPrintWriter.startTAG("MainGridLine").attr("style", this.getMainGridStyle());
        if (this.getMainGridColor() != null) {
            xMLPrintWriter.attr("color", this.getMainGridColor().getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("SecGridLine").attr("style", this.getSecondGridStyle());
        if (this.getSecondGridColor() != null) {
            xMLPrintWriter.attr("color", this.getSecondGridColor().getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("AxisLabelCount").attr("value", this.getLabelNumber()).end();
        xMLPrintWriter.startTAG("TickLine").attr("type", this.getTickMarkType()).attr("mainStroke", this.getMainStroke()).attr("len", this.getTickLength()).attr("secType", this.getSecTickMarkType()).attr("secStroke", this.getSecStroke()).attr("secLen", this.getSecTickLength()).end();
        xMLPrintWriter.startTAG("ArrowShow").attr("arrowShow", this.isArrowShow()).end();
        xMLPrintWriter.startTAG("AxisShow").attr("axisShow", this.isAxisShow()).end();
        xMLPrintWriter.startTAG("Stagger").attr("value", this.isStagger()).end();
        if (this.getTextAttr() != null) {
            this.getTextAttr().writeXML(xMLPrintWriter);
        }
        if (this.getFormat() != null) {
            ReportXMLUtils.writeFormat(xMLPrintWriter, this.getFormat());
        }
        xMLPrintWriter.startTAG("AxisRange");
        if (this.isCustomMinValue()) {
            xMLPrintWriter.attr("minValue", this.getMinValue());
        }
        if (this.isCustomMaxValue()) {
            xMLPrintWriter.attr("maxValue", this.getMaxValue());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Axis)) {
            return false;
        }
        Axis axis = (Axis)object;
        if (axis.getTickMarkType() != this.getTickMarkType()) {
            return false;
        }
        if (axis.getTickLength() != this.getTickLength()) {
            return false;
        }
        if (axis.getMainStroke() != this.getMainStroke()) {
            return false;
        }
        if (axis.getSecTickMarkType() != this.getSecTickMarkType()) {
            return false;
        }
        if (axis.getSecTickLength() != this.getSecTickLength()) {
            return false;
        }
        if (axis.getSecStroke() != this.getSecStroke()) {
            return false;
        }
        if (axis.getPosition() != this.getPosition()) {
            return false;
        }
        if (axis.getMainGridStyle() != this.getMainGridStyle()) {
            return false;
        }
        if (axis.getSecondGridStyle() != this.getSecondGridStyle()) {
            return false;
        }
        if (!Equals.equals(axis.getMainGridColor(), this.getMainGridColor())) {
            return false;
        }
        if (!Equals.equals(axis.getSecondGridColor(), this.getSecondGridColor())) {
            return false;
        }
        if (axis.getLineStyle() != this.getLineStyle()) {
            return false;
        }
        if (!Equals.equals(axis.getLineColor(), this.getLineColor())) {
            return false;
        }
        if (!Equals.equals(axis.getTextAttr(), this.getTextAttr())) {
            return false;
        }
        if (!Equals.equals(axis.getFormat(), this.getFormat())) {
            return false;
        }
        if (axis.isStagger() != this.isStagger()) {
            return false;
        }
        if (axis.getLabelNumber() != this.getLabelNumber()) {
            return false;
        }
        if (axis.getAxisLabelPosition() != this.getAxisLabelPosition()) {
            return false;
        }
        if (!Equals.equals(axis.getTitle(), this.getTitle())) {
            return false;
        }
        if (axis.isArrowShow() != this.isArrowShow()) {
            return false;
        }
        if (axis.isAxisShow() != this.isAxisShow()) {
            return false;
        }
        if (axis.getMaxValue() != this.getMaxValue()) {
            return false;
        }
        if (axis.getMinValue() != this.getMinValue()) {
            return false;
        }
        if (axis.isCustomMaxValue() != this.isCustomMaxValue()) {
            return false;
        }
        return axis.isCustomMinValue() == this.isCustomMinValue();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("axisLabelPosition", this.axisLabelPosition);
        jSONObject.put("isStagger", this.isStagger);
        jSONObject.put("labelNumber", this.labelNumber);
        jSONObject.put("lineStyle", this.lineStyle);
        jSONObject.put("mainGridStyle", this.mainGridStyle);
        jSONObject.put("position", this.position);
        jSONObject.put("secondGridStyle", this.secondGridStyle);
        jSONObject.put("secTickLength", this.secTickLength);
        jSONObject.put("secTickMarkType", this.secTickMarkType);
        jSONObject.put("tickLength", this.tickLength);
        jSONObject.put("tickMarkType", this.tickMarkType);
        if (this.format != null) {
            jSONObject.put("format", ChartUtils.format2JS(this.format));
        }
        if (this.lineColor != null) {
            jSONObject.put("lineColor", ChartUtils.color2JS(this.lineColor));
        }
        if (this.mainGridColor != null) {
            jSONObject.put("mainGridColor", ChartUtils.color2JS(this.mainGridColor));
        }
        jSONObject.put("mainStroke", this.mainStroke);
        if (this.secondGridColor != null) {
            jSONObject.put("secondGridColor", ChartUtils.color2JS(this.secondGridColor));
        }
        jSONObject.put("secStroke", this.secStroke);
        if (this.textAttr != null) {
            jSONObject.put("textAttr", this.textAttr.toJSONObject());
        }
        if (this.title != null) {
            jSONObject.put("title", this.title.toJSONObject());
        }
        jSONObject.put("isArrowShow", this.isArrowShow);
        jSONObject.put("isAxisShow", this.isAxisShow);
        jSONObject.put("isCustomMinValue", this.isCustomMinValue());
        jSONObject.put("minValue", this.getMinValue());
        jSONObject.put("isCustomMaxValue", this.isCustomMaxValue());
        jSONObject.put("maxValue", this.getMaxValue());
        return jSONObject;
    }
}

