/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.axis;

import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.GlyphCondition;
import com.fr.chart.axis.SeriesAttrContents;
import com.fr.chart.axis.SeriesAttrPosition;
import com.fr.chart.axis.SeriesAttrStyle;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.Glyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.SeriesAttr;
import com.fr.chart.plot.SeriesCollection;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.util.Utils;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.Format;

public class DataLabelInfo
implements XMLable,
GlyphCondition {
    private static final long serialVersionUID = 1945411573328281811L;
    public static final String XML_TAG = "DataLabel";
    public static final String valuePara = "${VALUE}";
    public static final String categoryPara = "${CATEGORY}";
    public static final String seriesPara = "${SERIES}";
    public static final String percentPara = "${PERCENT}";
    private SeriesAttrContents seriesLabelContents = new SeriesAttrContents();
    private SeriesAttrPosition seriesLabelPosition = new SeriesAttrPosition();
    private SeriesAttrStyle seriesLabelStyle = new SeriesAttrStyle();
    private boolean showLegendItem = false;

    public void setSeriesLabelContents(SeriesAttrContents seriesAttrContents) {
        this.seriesLabelContents = seriesAttrContents;
    }

    public SeriesAttrContents getSeriesLabelContents() {
        return this.seriesLabelContents;
    }

    public void setSeriesLabel(String string) {
        this.seriesLabelContents.setSeriesLabel(string);
    }

    public String getSeriesLabel() {
        return this.seriesLabelContents.getSeriesLabel();
    }

    public void setSeriesLabelPosition(SeriesAttrPosition seriesAttrPosition) {
        this.seriesLabelPosition = seriesAttrPosition;
    }

    public SeriesAttrPosition getSeriesLabelPosition() {
        return this.seriesLabelPosition;
    }

    public void setPosition(int n) {
        this.seriesLabelPosition.setPosition(n);
    }

    public int getPosition() {
        return this.seriesLabelPosition.getPosition();
    }

    public void setSeriesLabelStyle(SeriesAttrStyle seriesAttrStyle) {
        this.seriesLabelStyle = seriesAttrStyle;
    }

    public SeriesAttrStyle getSeriesLabelStyle() {
        return this.seriesLabelStyle;
    }

    public void setSeparation(String string) {
        this.seriesLabelStyle.setSeparation(string);
    }

    public String getSeparation() {
        return this.seriesLabelStyle.getSeparation();
    }

    public void setTextAttr(TextAttr textAttr) {
        this.seriesLabelStyle.setTextAttr(textAttr);
    }

    public TextAttr getTextAttr() {
        return this.seriesLabelStyle.getTextAttr();
    }

    public void setFormat(Format format) {
        this.seriesLabelStyle.setFormat(format);
    }

    public Format getFormat() {
        return this.seriesLabelStyle.getFormat();
    }

    public void setShowLegendItem(boolean bl) {
        this.showLegendItem = bl;
    }

    public boolean isShowLegendItem() {
        return this.showLegendItem;
    }

    public void setShowGuidLine(boolean bl) {
        this.seriesLabelContents.setShowGuidLine(bl);
    }

    public boolean isShowGuidLine() {
        return this.seriesLabelContents.isShowGuidLine();
    }

    public void add2SeriesAttr(SeriesAttr seriesAttr) {
        seriesAttr.addCondition(this.getSeriesLabelContents());
        seriesAttr.addCondition(this.getSeriesLabelPosition());
        seriesAttr.addCondition(this.getSeriesLabelStyle());
    }

    public Glyph createDataLabel(DataPoint dataPoint) {
        String string = this.createLabelText(dataPoint);
        TextGlyph textGlyph = new TextGlyph(string, this.getSeriesLabelStyle().getTextAttr());
        Rectangle2D rectangle2D = DataLabelInfo.preferredLabelBounds(textGlyph, dataPoint, this.getSeriesLabelPosition().getPosition());
        textGlyph.setBounds(rectangle2D);
        return textGlyph;
    }

    public String createLabelText(DataPoint dataPoint) {
        String string = "";
        if (this.getSeriesLabelContents().getSeriesLabel() != null) {
            try {
                Calculator calculator = Calculator.createCalculator();
                Format format = this.getSeriesLabelStyle().getPercentFormat() != null ? this.getSeriesLabelStyle().getPercentFormat() : new DecimalFormat("00%");
                String string2 = format.format(Double.valueOf(Utils.doubleToString(dataPoint.getPercentValue())));
                Object object = this.getSeriesLabelStyle().getFormat() != null ? this.getSeriesLabelStyle().getFormat().format(new Double(dataPoint.getValue())) : new Double(dataPoint.getValue());
                Parameter[] parameterArray = new Parameter[]{new Parameter("Category", this.getSeriesLabelStyle().getSeparation() + dataPoint.getCategoryName()), new Parameter("Series", this.getSeriesLabelStyle().getSeparation() + dataPoint.getSeriesName()), new Parameter("Value", this.getSeriesLabelStyle().getSeparation() + Utils.objectToString(object)), new Parameter("Percent", this.getSeriesLabelStyle().getSeparation() + string2)};
                calculator.pushNameSpace(ParameterMapNameSpace.create(parameterArray));
                string = calculator.renderTpl(this.getSeriesLabelContents().getSeriesLabel());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.startsWith(this.getSeriesLabelStyle().getSeparation())) {
                string = string.substring(1);
            }
        }
        return string;
    }

    public static Rectangle2D preferredLabelBounds(TextGlyph textGlyph, DataPoint dataPoint, int n) {
        Rectangle2D.Double double_ = null;
        Dimension2D dimension2D = textGlyph.preferredDimension();
        Rectangle2D rectangle2D = dataPoint.getShape().getBounds2D();
        double_ = n == 4 ? new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth() + 4.0, dimension2D.getHeight()) : (n == 1 ? new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY() - dimension2D.getHeight(), dimension2D.getWidth() + 4.0, dimension2D.getHeight()) : (n == 2 ? new Rectangle2D.Double(rectangle2D.getX() - dimension2D.getWidth(), rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth() + 4.0, dimension2D.getHeight()) : (n == 3 ? new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY() + rectangle2D.getHeight(), dimension2D.getWidth() + 4.0, dimension2D.getHeight()) : (n == 0 ? new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth() + 4.0, dimension2D.getHeight()) : (n == 7 ? new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY() + rectangle2D.getHeight() - dimension2D.getHeight(), dimension2D.getWidth() + 4.0, dimension2D.getHeight()) : (n == 5 ? new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY(), dimension2D.getWidth() + 4.0, dimension2D.getHeight()) : (n == 6 ? new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY() - dimension2D.getHeight(), dimension2D.getWidth() + 4.0, dimension2D.getHeight()) : new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY() - dimension2D.getHeight(), dimension2D.getWidth() + 4.0, dimension2D.getHeight()))))))));
        return double_;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = this.getSeriesLabel();
                String string3 = xMLableReader.getAttr("cateName");
                if (string3 != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = categoryPara;
                }
                if ((string3 = xMLableReader.getAttr("seriesName")) != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = string2 != null ? string2 + seriesPara : seriesPara;
                }
                if ((string3 = xMLableReader.getAttr("showValue")) != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = string2 != null ? string2 + valuePara : valuePara;
                }
                if ((string3 = xMLableReader.getAttr("piePercent")) != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = string2 != null ? string2 + percentPara : percentPara;
                }
                if ((string3 = xMLableReader.getAttr("showItem")) != null) {
                    this.showLegendItem = Boolean.valueOf(string3);
                }
                if ((string3 = xMLableReader.getAttr("position")) != null) {
                    this.getSeriesLabelPosition().setPosition(Byte.parseByte(string3));
                }
                if ((string3 = xMLableReader.getAttr("seriesLabel")) != null) {
                    this.getSeriesLabelContents().setSeriesLabel(string3);
                }
                if ((string3 = xMLableReader.getAttr("guidLine")) != null) {
                    this.getSeriesLabelContents().setShowGuidLine(Boolean.valueOf(string3));
                }
            } else if ("Separation".equals(string)) {
                this.seriesLabelStyle.setSeparation(xMLableReader.getElementValue());
            } else if ("TextAttr".equals(string)) {
                this.seriesLabelStyle.setTextAttr((TextAttr)xMLableReader.readXMLObject(new TextAttr()));
            } else if ("Format".equals(string)) {
                this.seriesLabelStyle.setFormat(ReportXMLUtils.readFormat(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("position", this.getPosition()).attr("showItem", this.showLegendItem);
        if (this.getSeriesLabel() != null) {
            xMLPrintWriter.attr("seriesLabel", this.getSeriesLabel());
        }
        xMLPrintWriter.end();
        if (StringUtils.isNotEmpty(this.getSeparation())) {
            xMLPrintWriter.startTAG("Separation").textNode(this.getSeparation()).end();
        }
        if (this.getTextAttr() != null) {
            this.getTextAttr().writeXML(xMLPrintWriter);
        }
        if (this.getFormat() != null) {
            ReportXMLUtils.writeFormat(xMLPrintWriter, this.getFormat());
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        DataLabelInfo dataLabelInfo = (DataLabelInfo)super.clone();
        if (this.getTextAttr() != null) {
            dataLabelInfo.setTextAttr((TextAttr)this.getTextAttr().clone());
        }
        if (this.getFormat() != null) {
            dataLabelInfo.setFormat((Format)this.getFormat().clone());
        }
        return dataLabelInfo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataLabelInfo)) {
            return false;
        }
        DataLabelInfo dataLabelInfo = (DataLabelInfo)object;
        if (!Equals.equals(dataLabelInfo.getSeriesLabel(), this.getSeriesLabel())) {
            return false;
        }
        if (dataLabelInfo.getPosition() != this.getPosition()) {
            return false;
        }
        if (!Equals.equals(dataLabelInfo.getFormat(), this.getFormat())) {
            return false;
        }
        if (!Equals.equals(dataLabelInfo.getSeparation(), this.getSeparation())) {
            return false;
        }
        return Equals.equals(dataLabelInfo.getTextAttr(), this.getTextAttr());
    }

    public void dealCondition(SeriesCollection seriesCollection, int n) {
        SeriesAttrContents seriesAttrContents = (SeriesAttrContents)seriesCollection.getSeriesCondition(new SeriesAttrContents(), n);
        this.setSeriesLabelContents(seriesAttrContents);
        SeriesAttrPosition seriesAttrPosition = (SeriesAttrPosition)seriesCollection.getSeriesCondition(new SeriesAttrPosition(), n);
        this.setSeriesLabelPosition(seriesAttrPosition);
        SeriesAttrStyle seriesAttrStyle = (SeriesAttrStyle)seriesCollection.getSeriesCondition(new SeriesAttrStyle(), n);
        this.setSeriesLabelStyle(seriesAttrStyle);
    }
}

