/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.axis;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.DataSeriesCondition;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.util.Utils;
import java.awt.Color;

public class SeriesAttrBorder
implements DataSeriesCondition {
    private static final long serialVersionUID = -3059717142253632161L;
    public static final String XML_TAG = "SeriesAttrBorder";
    private Color borderColor = Color.black;
    private int borderStyle = 0;
    private boolean isRoundBorder = false;

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderStyle(int n) {
        this.borderStyle = n;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setRoundBorder(boolean bl) {
        this.isRoundBorder = bl;
    }

    public boolean isRoundBorder() {
        return this.isRoundBorder;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            String string2 = xMLableReader.getAttr("lineStyle");
            if (string2 != null) {
                this.setBorderStyle(Utils.string2Number(string2).intValue());
            }
            if ((string2 = xMLableReader.getAttr("lineColor")) != null) {
                this.setBorderColor(new Color(Utils.string2Number(string2).intValue(), true));
            }
            if ((string2 = xMLableReader.getAttr("isRoundBorder")) != null) {
                this.setRoundBorder(Boolean.valueOf(string2));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("lineStyle", this.borderStyle);
        if (this.borderColor != null) {
            xMLPrintWriter.attr("lineColor", this.borderColor.getRGB());
        }
        xMLPrintWriter.attr("isRoundBorder", this.isRoundBorder);
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SeriesAttrBorder)) {
            return false;
        }
        SeriesAttrBorder seriesAttrBorder = (SeriesAttrBorder)object;
        if (seriesAttrBorder.borderStyle != this.borderStyle || seriesAttrBorder.isRoundBorder != this.isRoundBorder) {
            return false;
        }
        return Equals.equals(seriesAttrBorder.borderColor, this.borderColor);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("borderStyle", this.borderStyle);
        jSONObject.put("isRoundBorder", this.isRoundBorder);
        if (this.borderColor != null) {
            jSONObject.put("borderColor", ChartUtils.color2JS(this.borderColor));
        }
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

