/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.axis;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.DataSeriesCondition;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.util.Utils;
import java.awt.Color;

public class SeriesAttrLine
implements DataSeriesCondition {
    private static final long serialVersionUID = 8393504378490600313L;
    public static final String XML_TAG = "SeriesAttrLine";
    private int seriesLineStyle = 1;
    private Color seriesLineColor = null;

    public SeriesAttrLine() {
    }

    public SeriesAttrLine(Color color, int n) {
        this.seriesLineColor = color;
        this.seriesLineStyle = n;
    }

    public void setSeriesLineStyle(int n) {
        this.seriesLineStyle = n;
    }

    public int getSeriesLineStyle() {
        return this.seriesLineStyle;
    }

    public void setSeriesLineColor(Color color) {
        this.seriesLineColor = color;
    }

    public Color getSeriesLineColor() {
        return this.seriesLineColor;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            String string2 = xMLableReader.getAttr("lineStyle");
            if (string2 != null) {
                this.setSeriesLineStyle(Utils.string2Number(string2).intValue());
            }
            if ((string2 = xMLableReader.getAttr("lineColor")) != null) {
                this.setSeriesLineColor(new Color(Utils.string2Number(string2).intValue(), true));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("lineStyle", this.seriesLineStyle);
        if (this.seriesLineColor != null) {
            xMLPrintWriter.attr("lineColor", this.seriesLineColor.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SeriesAttrLine)) {
            return false;
        }
        SeriesAttrLine seriesAttrLine = (SeriesAttrLine)object;
        if (seriesAttrLine.seriesLineStyle != this.seriesLineStyle) {
            return false;
        }
        return Equals.equals(seriesAttrLine.seriesLineColor, this.seriesLineColor);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("seriesLineStyle", this.seriesLineStyle);
        jSONObject.put("seriesLineColor", ChartUtils.color2JS(this.seriesLineColor));
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

