/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.axis;

import com.fr.base.StringUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.DataSeriesCondition;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import java.text.DecimalFormat;
import java.text.Format;

public class SeriesAttrStyle
implements DataSeriesCondition {
    private static final long serialVersionUID = 5328560572564949184L;
    public static final String XML_TAG = "SeriesAttrStyle";
    private String separation = ",";
    private TextAttr textAttr = null;
    private Format format = null;
    private Format percentFormat = null;

    public void setSeparation(String string) {
        this.separation = string;
    }

    public String getSeparation() {
        return this.separation;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setPercentFormat(Format format) {
        if (format instanceof DecimalFormat) {
            this.percentFormat = format;
        }
    }

    public Format getPercentFormat() {
        return this.percentFormat;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Separation".equals(string)) {
                this.setSeparation(xMLableReader.getElementValue());
            } else if ("TextAttr".equals(string)) {
                this.setTextAttr((TextAttr)xMLableReader.readXMLObject(new TextAttr()));
            } else if ("Format".equals(string)) {
                this.setFormat(ReportXMLUtils.readFormat(xMLableReader));
            } else if ("PercentFormat".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Format".equals(xMLableReader.getTagName())) {
                            SeriesAttrStyle.this.setPercentFormat(ReportXMLUtils.readFormat(xMLableReader));
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotEmpty(this.separation)) {
            xMLPrintWriter.startTAG("Separation").textNode(this.separation).end();
        }
        if (this.textAttr != null) {
            this.textAttr.writeXML(xMLPrintWriter);
        }
        if (this.format != null) {
            ReportXMLUtils.writeFormat(xMLPrintWriter, this.format);
        }
        if (this.percentFormat != null) {
            xMLPrintWriter.startTAG("PercentFormat");
            ReportXMLUtils.writeFormat(xMLPrintWriter, this.percentFormat);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        SeriesAttrStyle seriesAttrStyle = (SeriesAttrStyle)super.clone();
        if (this.format != null) {
            seriesAttrStyle.format = (Format)this.format.clone();
        }
        if (this.textAttr != null) {
            seriesAttrStyle.textAttr = (TextAttr)this.textAttr.clone();
        }
        if (this.percentFormat != null) {
            seriesAttrStyle.percentFormat = (Format)this.percentFormat.clone();
        }
        return seriesAttrStyle;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SeriesAttrStyle)) {
            return false;
        }
        SeriesAttrStyle seriesAttrStyle = (SeriesAttrStyle)object;
        if (!Equals.equals(seriesAttrStyle.format, this.format)) {
            return false;
        }
        if (!Equals.equals(seriesAttrStyle.separation, this.separation)) {
            return false;
        }
        if (!Equals.equals(seriesAttrStyle.textAttr, this.textAttr)) {
            return false;
        }
        return Equals.equals(seriesAttrStyle.percentFormat, this.percentFormat);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("separation", this.separation);
        if (this.format != null) {
            jSONObject.put("format", ChartUtils.format2JS(this.format));
        }
        if (this.textAttr != null) {
            jSONObject.put("textAttr", this.textAttr.toJSONObject());
        }
        if (this.percentFormat != null) {
            jSONObject.put("percentFormat", ChartUtils.format2JS(this.percentFormat));
        }
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

