/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.axis;

import com.fr.base.FRFont;
import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;

public class TextAttr
implements XMLable {
    private static final long serialVersionUID = -4216006140409740068L;
    public static final String XML_TAG = "TextAttr";
    private FRFont frFont = null;
    private int direction = 1;
    private int rotation = 0;
    private int horizontalAlignment = 2;
    private int verticalAlignment = 0;
    private int alignText = 0;

    public TextAttr() {
    }

    public TextAttr(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public FRFont getFRFont() {
        return this.frFont;
    }

    public void setFRFont(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n) {
        this.rotation = n;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setAlignText(int n) {
        this.alignText = n;
    }

    public int getAlignText() {
        return this.alignText;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextAttr)) {
            return false;
        }
        TextAttr textAttr = (TextAttr)object;
        if (textAttr.getAlignText() != this.getAlignText()) {
            return false;
        }
        if (textAttr.getDirection() != this.getDirection()) {
            return false;
        }
        if (textAttr.getHorizontalAlignment() != this.getHorizontalAlignment()) {
            return false;
        }
        if (textAttr.getVerticalAlignment() != this.getVerticalAlignment()) {
            return false;
        }
        if (textAttr.getRotation() != this.getRotation()) {
            return false;
        }
        return Equals.equals(textAttr.getFRFont(), this.getFRFont());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            if ("FRFont".equals(xMLableReader.getTagName())) {
                this.frFont = BaseXMLUtils.readFRFont(xMLableReader);
            } else if (xMLableReader.getTagName().equals("Attr")) {
                String string = xMLableReader.getAttr("direction");
                if (string != null) {
                    this.setDirection(Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("rotation")) != null) {
                    this.setRotation(Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("h_align")) != null) {
                    this.setHorizontalAlignment(Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("v_align")) != null) {
                    this.setVerticalAlignment(Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("alignText")) != null) {
                    this.setAlignText(Integer.parseInt(string));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr");
        if (this.getDirection() != 1) {
            xMLPrintWriter.attr("direction", this.getDirection());
        }
        if (this.getRotation() != 0) {
            xMLPrintWriter.attr("rotation", this.getRotation());
        }
        if (this.getHorizontalAlignment() != 2) {
            xMLPrintWriter.attr("h_align", this.getHorizontalAlignment());
        }
        if (this.getVerticalAlignment() != 0) {
            xMLPrintWriter.attr("v_align", this.getVerticalAlignment());
        }
        xMLPrintWriter.attr("alignText", this.getAlignText());
        if (this.getFRFont() != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.getFRFont());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.frFont != null) {
            jSONObject.put("frFont", this.frFont.toJSONObject());
        }
        jSONObject.put("alignText", this.alignText);
        jSONObject.put("direction", this.direction);
        jSONObject.put("horizontalAlignment", this.horizontalAlignment);
        jSONObject.put("rotation", this.rotation);
        jSONObject.put("verticalAlignment", this.verticalAlignment);
        return jSONObject;
    }
}

