/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.axis;

import com.fr.base.Inter;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.Axis;
import com.fr.chart.base.equals.Equals;
import com.fr.report.cellElement.Formula;
import com.fr.util.Utils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class ValueAxis
extends Axis {
    private static final long serialVersionUID = 6083137730386866219L;
    public static final String XML_TAG = "ValueAxis";
    public static final String[] UNIT_STRING = new String[]{Inter.getLocText("DataFunction-None"), Inter.getLocText("Unit_Hundred"), Inter.getLocText("Unit_Thousand"), Inter.getLocText("Unit_Ten_Thousand"), Inter.getLocText("Unit_Ten") + Inter.getLocText("Unit_Ten_Thousand"), Inter.getLocText("Unit_Million"), Inter.getLocText("Unit_Thousand") + Inter.getLocText("Unit_Ten_Thousand"), Inter.getLocText("Unit_Hundred_Million"), Inter.getLocText("Unit_Billion")};
    private static Map unit = null;
    private boolean customIncrement = false;
    private double increment = 0.0;
    private boolean customCrossValue = false;
    private double crossValue = 0.0;
    private String showUnit = null;
    private boolean isLog = false;
    private boolean isPercentage = false;
    private boolean hasAlertValue = false;
    private Object alertValue;

    public static double getDivideUnit(String string) {
        if (unit == null) {
            unit = new HashMap();
            unit.put(UNIT_STRING[0], new Double(1.0));
            double d = 100.0;
            for (int i = 1; i < UNIT_STRING.length; ++i) {
                unit.put(UNIT_STRING[i], new Double(d));
                d *= 10.0;
            }
            unit.put("10000", new Double(10000.0));
            unit.put("100000", new Double(100000.0));
            unit.put("10000000", new Double(1.0E7));
            unit.put("100000000", new Double(1.0E8));
        }
        return (Double)unit.get(string);
    }

    public ValueAxis() {
        this(2);
    }

    public ValueAxis(int n) {
        this.position = n;
        this.setMainGridStyle(1);
        this.setMainGridColor(new Color(237, 237, 237));
    }

    public void setCustomIncrement(boolean bl) {
        this.customIncrement = bl;
    }

    public boolean isCustomIncrement() {
        return this.customIncrement;
    }

    public void setIncrement(double d) {
        this.increment = d;
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setCustomCrossValue(boolean bl) {
        this.customCrossValue = bl;
    }

    public boolean isCustomCrossValue() {
        return this.customCrossValue;
    }

    public void setCrossValue(double d) {
        this.crossValue = d;
    }

    public double getCrossValue() {
        return this.crossValue;
    }

    public void setHasAlertValue(boolean bl) {
        this.hasAlertValue = bl;
    }

    public boolean hasAlertValue() {
        return this.hasAlertValue;
    }

    public void setAlertValue(Object object) {
        this.alertValue = object;
    }

    public Object getAlertValue() {
        return this.alertValue;
    }

    public void setShowUnit(String string) {
        this.showUnit = string;
    }

    public String getShowUnit() {
        return this.showUnit;
    }

    public void setIsLog(boolean bl) {
        this.isLog = bl;
    }

    public boolean isLog() {
        return this.isLog;
    }

    public void setPercentage(boolean bl) {
        this.isPercentage = bl;
    }

    public boolean isPercentage() {
        return this.isPercentage;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueAxis)) {
            return false;
        }
        ValueAxis valueAxis = (ValueAxis)object;
        if (!super.equals(valueAxis)) {
            return false;
        }
        if (valueAxis.isCustomIncrement() != this.isCustomIncrement()) {
            return false;
        }
        if (valueAxis.getIncrement() != this.getIncrement()) {
            return false;
        }
        if (valueAxis.isCustomCrossValue() != this.isCustomCrossValue()) {
            return false;
        }
        if (valueAxis.getCrossValue() != this.getCrossValue()) {
            return false;
        }
        if (!Equals.equals(valueAxis.getShowUnit(), this.getShowUnit())) {
            return false;
        }
        if (valueAxis.isLog() != this.isLog()) {
            return false;
        }
        if (valueAxis.hasAlertValue() != this.hasAlertValue()) {
            return false;
        }
        return !valueAxis.hasAlertValue || Equals.equals(valueAxis.getAlertValue(), this.getAlertValue());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("AxisRange")) {
                String string3 = xMLableReader.getAttr("minValue");
                if (string3 != null) {
                    this.setCustomMinValue(true);
                    this.setMinValue(Double.parseDouble(string3));
                }
                if ((string3 = xMLableReader.getAttr("maxValue")) != null) {
                    this.setCustomMaxValue(true);
                    this.setMaxValue(Double.parseDouble(string3));
                }
            } else if (string2.equals("AxisRangeIncr")) {
                String string4 = xMLableReader.getAttr("value");
                if (string4 != null) {
                    this.setIncrement(Double.parseDouble(string4));
                }
                if (this.getIncrement() > 0.0) {
                    this.setCustomIncrement(true);
                }
            } else if ("Cross".equals(string2)) {
                String string5 = xMLableReader.getAttr("value");
                if (string5 != null) {
                    this.setCrossValue(Double.parseDouble(string5));
                    this.setCustomCrossValue(true);
                }
            } else if ("Log".equals(string2)) {
                String string6 = xMLableReader.getAttr("value");
                if (string6 != null) {
                    this.setIsLog(Boolean.valueOf(string6));
                }
            } else if (string2.equals("AxisAlert")) {
                String string7;
                String string8 = xMLableReader.getAttr("startValue");
                if (string8 != null) {
                    if (string8.startsWith("=")) {
                        string8 = string8.substring(1);
                    }
                    if (this.alertValue == null) {
                        this.alertValue = new Formula("=[" + string8 + "]");
                    } else if (this.alertValue instanceof Formula) {
                        string7 = this.alertValue.toString();
                        ((Formula)this.alertValue).setContent("=[" + string7.substring(2, string7.length() - 1) + "," + string8 + "]");
                    }
                }
                if ((string8 = xMLableReader.getAttr("endValue")) != null) {
                    if (string8.startsWith("=")) {
                        string8 = string8.substring(1);
                    }
                    if (this.alertValue == null) {
                        this.alertValue = new Formula("=[" + string8 + "]");
                    } else if (this.alertValue instanceof Formula) {
                        string7 = this.alertValue.toString();
                        ((Formula)this.alertValue).setContent("=[" + string7.substring(2, string7.length() - 1) + "," + string8 + "]");
                    }
                }
                if ((string8 = xMLableReader.getAttr("alertValue")) != null) {
                    this.alertValue = new Formula(string8);
                }
                this.setHasAlertValue(true);
            } else if (string2.equals("ShowUnit")) {
                String string9 = xMLableReader.getAttr("value");
                if (string9 != null) {
                    Number number = Utils.string2Number(string9);
                    if (number != null) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("10000", "\u4e07");
                        hashMap.put("100000", "\u5341\u4e07");
                        hashMap.put("10000000", "\u5343\u4e07");
                        hashMap.put("100000000", "\u4ebf");
                        string9 = hashMap.get(string9).toString();
                    }
                    this.setShowUnit(string9);
                }
            } else if (string2.equals("Percentage") && (string = xMLableReader.getAttr("value")) != null) {
                this.setPercentage(Boolean.valueOf(string));
            }
        }
        super.readXML(xMLableReader);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter, XML_TAG);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter, String string) {
        xMLPrintWriter.startTAG(string).attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        if (this.isPercentage) {
            xMLPrintWriter.startTAG("Percentage").attr("value", this.isPercentage).end();
        }
        if (this.isCustomIncrement() && this.getIncrement() > 0.0) {
            xMLPrintWriter.startTAG("AxisRangeIncr").attr("value", this.getIncrement()).end();
        }
        if (this.isCustomCrossValue()) {
            xMLPrintWriter.startTAG("Cross").attr("value", this.getCrossValue()).end();
        }
        if (this.getShowUnit() != null) {
            xMLPrintWriter.startTAG("ShowUnit").attr("value", this.getShowUnit()).end();
        }
        if (this.isLog()) {
            xMLPrintWriter.startTAG("Log").attr("value", this.isLog).end();
        }
        if (this.hasAlertValue()) {
            xMLPrintWriter.startTAG("AxisAlert").attr("alertValue", this.getAlertValue().toString()).end();
        }
        xMLPrintWriter.end();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("crossValue", this.crossValue);
        jSONObject.put("customCrossValue", this.customCrossValue);
        jSONObject.put("customIncrement", this.customIncrement);
        jSONObject.put("alertValue", this.alertValue);
        jSONObject.put("hasAlertValue", this.hasAlertValue);
        jSONObject.put("increment", this.increment);
        jSONObject.put("isLog", this.isLog);
        jSONObject.put("isPercentage", this.isPercentage);
        jSONObject.put("showUnit", this.showUnit);
        return jSONObject;
    }
}

