/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core;

import com.fr.base.BaseUtils;
import com.fr.base.ColumnRow;
import com.fr.base.core.DateUtils;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.chart.core.ChartCoreConstants;
import com.fr.report.cellElement.TextFormat;
import com.fr.util.Base64;
import com.fr.util.Utils;
import com.fr.web.core.service.AttachmentService;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ChartUtils {
    private ChartUtils() {
    }

    public static double fixDoubleValue(double d) {
        long l = Double.doubleToRawLongBits(d);
        int n = l >> 63 == 0L ? 1 : -1;
        int n2 = (int)(l >> 52 & 0x7FFL);
        long l2 = n2 == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        return (double)((long)n * l2) * Math.pow(2.0, (double)n2 - 1075.0);
    }

    public static Object getObject(int n, Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 0) {
            return null;
        }
        int n2 = n % objectArray.length;
        return objectArray[n2];
    }

    public static void draw3DRectangle(Graphics2D graphics2D, double d, double d2, double d3, double d4, Color color, boolean bl, boolean bl2) {
        if (color == null) {
            color = ChartCoreConstants.CHART_COLOR_ARRAY[0];
        }
        Color color2 = color.brighter();
        if (bl2) {
            if (bl) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                graphics2D.setPaint(new GradientPaint((float)d, (float)d2, color, (float)d, (float)(d2 + d4 / 3.0), color2));
                GraphHelper.fillRect(graphics2D, d, d2, d3, d4 / 3.0);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                graphics2D.setPaint(new GradientPaint((float)d, (float)(d2 + d4 / 3.0), color2, (float)d, (float)(d2 + d4), color));
                GraphHelper.fillRect(graphics2D, d, d2 + d4 / 3.0, d3, 2.0 * d4 / 3.0);
            } else {
                graphics2D.setPaint(new GradientPaint((float)d, (float)d2, color, (float)d, (float)(d2 + d4 / 3.0 + 1.0), color2));
                GraphHelper.fillRect(graphics2D, d, d2, d3, d4 / 3.0 + 1.0);
                graphics2D.setComposite(AlphaComposite.getInstance(3));
                graphics2D.setPaint(new GradientPaint((float)d, (float)(d2 + d4 / 3.0), color2, (float)d, (float)(d2 + d4), color));
                GraphHelper.fillRect(graphics2D, d, d2 + d4 / 3.0, d3, 2.0 * d4 / 3.0);
            }
        } else if (bl) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
            graphics2D.setPaint(new GradientPaint((float)d, (float)d2, color, (float)(d + d3 / 3.0), (float)d2, color2));
            GraphHelper.fillRect(graphics2D, d, d2, d3 / 3.0, d4);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
            graphics2D.setPaint(new GradientPaint((float)(d + d3 / 3.0), (float)d2, color2, (float)(d + d3), (float)d2, color));
            GraphHelper.fillRect(graphics2D, d + d3 / 3.0, d2, 2.0 * d3 / 3.0, d4);
        } else {
            graphics2D.setPaint(new GradientPaint((float)d, (float)d2, color, (float)(d + d3 / 3.0 + 1.0), (float)d2, color2));
            GraphHelper.fillRect(graphics2D, d, d2, d3 / 3.0 + 1.0, d4);
            graphics2D.setComposite(AlphaComposite.getInstance(3));
            graphics2D.setPaint(new GradientPaint((float)(d + d3 / 3.0), (float)d2, color2, (float)(d + d3), (float)d2, color));
            GraphHelper.fillRect(graphics2D, d + d3 / 3.0, d2, 2.0 * d3 / 3.0, d4);
        }
    }

    public static void draw3DEllipse(Graphics2D graphics2D, double d, double d2, double d3, double d4, Color color, boolean bl, boolean bl2) {
        if (color == null) {
            color = ChartCoreConstants.CHART_COLOR_ARRAY[0];
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2 + d4 / 2.0, d3, d4 / 2.0);
        Area area = new Area(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(d, d2, d3, d4);
        Area area2 = new Area(double_2);
        area2.intersect(area);
        if (!bl2) {
            if (bl) {
                graphics2D.setPaint(color);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                graphics2D.fill(new Ellipse2D.Double(d, d2, d3, d4));
            } else {
                graphics2D.setPaint(color);
                graphics2D.fill(new Ellipse2D.Double(d, d2, d3, d4));
            }
        }
    }

    public static void draw3DCylinder(Graphics2D graphics2D, double d, double d2, double d3, double d4, Color color, boolean bl, boolean bl2) {
        if (color == null) {
            color = ChartCoreConstants.CHART_COLOR_ARRAY[0];
        }
        ChartUtils.draw3DEllipse(graphics2D, d, d2 + d4 - d3 / 8.0, d3, d3 / 4.0, color, false, bl2);
        graphics2D.setComposite(AlphaComposite.getInstance(3));
        ChartUtils.draw3DRectangle(graphics2D, d, d2, d3, d4, color, false, bl2);
        graphics2D.setPaint(color);
        graphics2D.setComposite(AlphaComposite.getInstance(3));
        graphics2D.fill(new Ellipse2D.Double(d, d2 - d3 / 8.0, d3, d3 / 4.0));
    }

    public static ColumnRow[] convertStringToColumnRow(String string) {
        if (string == null || string.trim().length() == 0) {
            return new ColumnRow[0];
        }
        ArrayList arrayList = new ArrayList();
        String[] stringArray = Utils.splitString(string.trim(), ',');
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                ChartUtils.dealStringWithOutComma(arrayList, stringArray[i]);
            }
        }
        return arrayList.toArray(new ColumnRow[arrayList.size()]);
    }

    private static void dealStringWithOutComma(List list, String string) {
        String[] stringArray = string.trim().split(":");
        if (stringArray != null && stringArray.length > 1) {
            ColumnRow columnRow;
            int n;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            for (n = 0; n < stringArray.length; ++n) {
                columnRow = BaseUtils.convertCellStringToColumnRow(stringArray[n].trim());
                if (columnRow.getColumn() == -1 || columnRow.getRow() == -1) continue;
                if (n2 == -1) {
                    n2 = columnRow.getColumn();
                    n3 = columnRow.getColumn();
                    n4 = columnRow.getRow();
                    n5 = columnRow.getRow();
                    continue;
                }
                n2 = Math.min(n2, columnRow.getColumn());
                n3 = Math.max(n3, columnRow.getColumn());
                n4 = Math.min(n4, columnRow.getRow());
                n5 = Math.max(n5, columnRow.getRow());
            }
            for (n = n4; n <= n5; ++n) {
                for (int i = n2; i <= n3; ++i) {
                    columnRow = ColumnRow.valueOf(i, n);
                    if (list.contains(columnRow)) continue;
                    list.add(list.size(), columnRow);
                }
            }
        } else {
            ColumnRow columnRow = BaseUtils.convertCellStringToColumnRow(string.trim());
            if (!list.contains(columnRow)) {
                list.add(list.size(), columnRow);
            }
        }
    }

    public static Point2D intersectsPoint(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d = (point2D4.getY() - point2D3.getY()) * (point2D2.getX() - point2D.getX()) - (point2D2.getY() - point2D.getY()) * (point2D4.getX() - point2D3.getX());
        if (Math.abs(d) < 0.01) {
            return null;
        }
        double d2 = (point2D4.getY() - point2D3.getY()) * point2D3.getX() - (point2D4.getX() - point2D3.getX()) * point2D3.getY();
        double d3 = (point2D2.getY() - point2D.getY()) * point2D.getX() - (point2D2.getX() - point2D.getX()) * point2D.getY();
        double d4 = ((point2D2.getX() - point2D.getX()) * d2 - (point2D4.getX() - point2D3.getX()) * d3) / d;
        double d5 = ((point2D2.getY() - point2D.getY()) * d2 - (point2D4.getY() - point2D3.getY()) * d3) / d;
        return new Point2D.Double(d4, d5);
    }

    public static Point2D intersectsPoint(Line2D line2D, Line2D line2D2) {
        Point2D point2D = line2D.getP1();
        Point2D point2D2 = line2D.getP2();
        Point2D point2D3 = line2D2.getP1();
        Point2D point2D4 = line2D2.getP2();
        return ChartUtils.intersectsPoint(point2D, point2D2, point2D3, point2D4);
    }

    public static String color2JS(Color color) {
        if (color == null) {
            return null;
        }
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public static String format2JS(Format format) {
        if (format == null) {
            return null;
        }
        String string = "";
        if (format instanceof SimpleDateFormat) {
            string = "D" + ((SimpleDateFormat)format).toPattern().trim();
        } else if (format instanceof DecimalFormat) {
            string = ((DecimalFormat)format).toPattern().trim();
        } else if (format instanceof TextFormat) {
            string = "T";
        }
        return string;
    }

    public static String fontStyle2JS(int n) {
        String string = "";
        if (n == 0) {
            string = "";
        } else if (n == 1) {
            string = "bold";
        } else if (n == 2) {
            string = "italic";
        } else if (n == 3) {
            string = "bold italic";
        }
        return string;
    }

    public static void image2JS(JSONObject jSONObject, Image image) throws JSONException {
        if (image == null) {
            return;
        }
        jSONObject.put("iesrc", AttachmentService.addAttachment(image).getID());
        jSONObject.put("src", "data:image/png;base64," + Base64.encode(image, "png"));
    }

    public static double date2Int(Date date) {
        if (date == null) {
            date = new Date();
        }
        Date date2 = new Date("1900/01/01");
        return ChartUtils.getTwoDay(date, date2);
    }

    public static Object object2DateDouble(Object object) {
        String string = object.toString();
        Number number = Utils.string2Number(string);
        if (number != null) {
            return number;
        }
        Date date = DateUtils.string2Date(object.toString(), true);
        if (date != null) {
            object = new Double(ChartUtils.date2Int(date));
        }
        return object;
    }

    public static Date int2Date(int n) {
        Date date = new Date("1900/01/01");
        long l = (long)n * 86400000L + date.getTime();
        return new Date(l);
    }

    public static double getTwoDay(Date date, Date date2) {
        long l = (date.getTime() - date2.getTime()) / 86400000L;
        return l;
    }
}

