/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core;

import com.fr.base.background.ColorBackground;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.Chart;
import com.fr.chart.ChartCollection;
import com.fr.chart.Title;
import com.fr.chart.axis.DataLabelInfo;
import com.fr.chart.axis.SeriesAttrAlpha;
import com.fr.chart.axis.SeriesAttrBackground;
import com.fr.chart.axis.SeriesAttrBorder;
import com.fr.chart.axis.SeriesAttrColor;
import com.fr.chart.axis.SeriesAttrLine;
import com.fr.chart.core.ChartXMLCompatibleUtils;
import com.fr.chart.legend.Legend;
import com.fr.chart.plot.AreaPlot;
import com.fr.chart.plot.Bar2DPlot;
import com.fr.chart.plot.Bar3DPlot;
import com.fr.chart.plot.BarPlot;
import com.fr.chart.plot.CategoryPlot;
import com.fr.chart.plot.Line3DPlot;
import com.fr.chart.plot.LinePlot;
import com.fr.chart.plot.Pie3DPlot;
import com.fr.chart.plot.PiePlot;
import com.fr.chart.plot.Plot;
import com.fr.chart.plot.RadarPlot;
import com.fr.chart.plot.SeriesAttr;
import com.fr.chart.plot.SeriesCollection;
import com.fr.chart.plot.StockPlot;
import com.fr.chart.plot.XYScatterPlot;
import com.fr.data.TableData;
import com.fr.data.core.DataUtils;
import com.fr.data.core.define.ChartDataDefinition;
import com.fr.data.core.define.ChartSummaryColumn;
import com.fr.data.core.define.FilterDefinition;
import com.fr.data.core.define.MoreNameCDDefinition;
import com.fr.data.core.define.OneValueCDDefinition;
import com.fr.data.core.define.ReportDataDefinition;
import com.fr.data.core.define.SortColumn;
import com.fr.data.core.define.TopDefinition;
import com.fr.data.util.function.NoneFunction;
import com.fr.report.cellElement.Formula;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.util.Utils;
import java.awt.Color;

public abstract class ChartXMLCompatibleUtils {
    public static final String CHART_DESCRIPTOR_XML_TAG = "ChartDescriptor";

    public static ChartCollection read62ChartCollection(XMLableReader xMLableReader) {
        final ChartCollection chartCollection = new ChartCollection();
        final Chart chart = new Chart();
        chartCollection.addChart(chart);
        xMLableReader.readXMLObject(new XMLObject(null){

            public void readXML(XMLableReader xMLableReader) {
                if (!xMLableReader.isAttr() && xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.endsWith("DataDefinition")) {
                        if (string.equals("ChartDataDefinition")) {
                            chartCollection.setFilterDefinition(ChartXMLCompatibleUtils.read62ChartDataDefinition(xMLableReader));
                        } else if (string.equals("ReportDataDefinition")) {
                            chartCollection.setFilterDefinition(ChartXMLCompatibleUtils.read62ReportDataDefinition(xMLableReader));
                        }
                    } else if (string.equals("Top")) {
                        FilterDefinition filterDefinition;
                        String string2 = xMLableReader.getAttr("top");
                        if (string2 != null && (filterDefinition = chartCollection.getFilterDefinition()) instanceof TopDefinition) {
                            ((TopDefinition)((Object)filterDefinition)).setTopCate(Integer.valueOf(string2));
                            ((TopDefinition)((Object)filterDefinition)).setTopValue(Integer.valueOf(string2));
                        }
                    } else if (string.equals("Background")) {
                        chart.setBackground(BaseXMLUtils.readBackground(xMLableReader));
                    } else if (string.equals("Title")) {
                        Title title = ChartXMLCompatibleUtils.read62Title(xMLableReader);
                        chart.setTitle(title);
                    } else if (string.equals("Legend")) {
                        Legend legend = ChartXMLCompatibleUtils.read62Legend(xMLableReader);
                        if (chart.getPlot() != null) {
                            chart.getPlot().setLegend(legend);
                        }
                    } else if (string.equals(ChartXMLCompatibleUtils.CHART_DESCRIPTOR_XML_TAG)) {
                        ChartXMLCompatibleUtils.read62ChartDescriptor(chart, xMLableReader);
                    } else if (string.equals("Border")) {
                        String string3 = xMLableReader.getAttr("style");
                        if (string3 != null) {
                            chart.setBorderStyle(Integer.parseInt(string3));
                        }
                        if ((string3 = xMLableReader.getAttr("color")) != null) {
                            chart.setBorderColor(new Color(Integer.parseInt(string3), true));
                        }
                    }
                }
            }
        });
        return chartCollection;
    }

    protected static FilterDefinition read62ChartDataDefinition(XMLableReader xMLableReader) {
        ChartDataDefinition chartDataDefinition = (ChartDataDefinition)xMLableReader.readXMLObject(new ChartDataDefinition());
        TableData tableData = chartDataDefinition.getTableData();
        SortColumn[] sortColumnArray = chartDataDefinition.getOnChangeColumnArray();
        ChartSummaryColumn[] chartSummaryColumnArray = chartDataDefinition.getChartSummaryColumnArray();
        if (sortColumnArray.length == 1) {
            MoreNameCDDefinition moreNameCDDefinition = new MoreNameCDDefinition();
            if (tableData != null) {
                moreNameCDDefinition.setTableData(tableData);
            }
            if (sortColumnArray != null && sortColumnArray[0] != null) {
                moreNameCDDefinition.setCategoryName(sortColumnArray[0].getName());
            }
            if (chartSummaryColumnArray != null) {
                ChartSummaryColumn[] chartSummaryColumnArray2 = chartSummaryColumnArray;
                for (int i = 0; i < chartSummaryColumnArray2.length; ++i) {
                    ChartSummaryColumn chartSummaryColumn = chartSummaryColumnArray2[i];
                    if (chartSummaryColumn.getFunction() instanceof NoneFunction) {
                        chartSummaryColumn.setCustomName(chartSummaryColumn.getName());
                        continue;
                    }
                    String string = DataUtils.getFunctionDisplayName(chartSummaryColumn.getFunction());
                    chartSummaryColumn.setCustomName(string + "[" + chartSummaryColumn.getName() + "]");
                }
                moreNameCDDefinition.setChartSummaryColumn(chartSummaryColumnArray2);
            }
            return moreNameCDDefinition;
        }
        if (sortColumnArray.length == 2) {
            OneValueCDDefinition oneValueCDDefinition = new OneValueCDDefinition();
            if (tableData != null) {
                oneValueCDDefinition.setTableData(tableData);
            }
            if (sortColumnArray != null) {
                if (sortColumnArray[0] != null) {
                    oneValueCDDefinition.setCategoryName(sortColumnArray[0].getName());
                }
                if (sortColumnArray[1] != null) {
                    oneValueCDDefinition.setSeriesColumnName(sortColumnArray[1].getName());
                }
            }
            if (chartSummaryColumnArray != null && chartSummaryColumnArray[0] != null) {
                oneValueCDDefinition.setValueColumnName(chartSummaryColumnArray[0].getName());
                oneValueCDDefinition.setDataFunction(chartSummaryColumnArray[0].getFunction());
            }
            return oneValueCDDefinition;
        }
        return new OneValueCDDefinition();
    }

    protected static ReportDataDefinition read62ReportDataDefinition(XMLableReader xMLableReader) {
        ReportDataDefinition reportDataDefinition = new ReportDataDefinition();
        xMLableReader.readXMLObject(reportDataDefinition);
        reportDataDefinition.setBaseOnDataValueArea(true);
        return reportDataDefinition;
    }

    protected static Title read62Title(XMLableReader xMLableReader) {
        final Title title = new Title();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (!xMLableReader.isAttr() && xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("Text")) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 2 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode()) {
                                    String string = xMLableReader.getTagName();
                                    if (string.equals("Formula")) {
                                        Formula formula = new Formula();
                                        xMLableReader.readXMLObject(formula);
                                        2.access$000(this.this$0).setTextObject(formula);
                                    } else if ("Object".equals(string) || "O".equals(string)) {
                                        2.access$000(this.this$0).setTextObject(ReportXMLUtils.readObject(xMLableReader));
                                    }
                                }
                            }
                        });
                    } else if (string.equals("TextAttributes")) {
                        if (xMLableReader.isAttr()) {
                            String string2 = xMLableReader.getAttr("isVerticalText");
                            if (string2 != null) {
                                title.getTextAttr().setAlignText(Byte.parseByte(string2));
                            }
                            if ((string2 = xMLableReader.getAttr("textDirection")) != null) {
                                title.getTextAttr().setDirection(Integer.parseInt(string2));
                            }
                            if ((string2 = xMLableReader.getAttr("rotation")) != null) {
                                title.getTextAttr().setRotation(Integer.parseInt(string2));
                            }
                        } else if (xMLableReader.isChildNode()) {
                            String string3 = xMLableReader.getTagName();
                            if ("Border".equals(string3)) {
                                String string4 = xMLableReader.getAttr("style");
                                if (string4 != null) {
                                    title.setBorderStyle(Integer.parseInt(string4));
                                }
                                if ((string4 = xMLableReader.getAttr("color")) != null) {
                                    title.setBorderColor(new Color(Integer.parseInt(string4), true));
                                }
                            } else if ("Background".equals(string3)) {
                                title.setBackground(BaseXMLUtils.readBackground(xMLableReader));
                            } else if (BaseXMLUtils.isFRFontTagName(string3)) {
                                title.getTextAttr().setFRFont(BaseXMLUtils.readFRFont(xMLableReader));
                            }
                        }
                    }
                }
            }

            static /* synthetic */ Title access$000(2 var0) {
                return var0.title;
            }
        });
        return title;
    }

    protected static Legend read62Legend(XMLableReader xMLableReader) {
        final Legend legend = new Legend();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (!xMLableReader.isAttr() && xMLableReader.isChildNode()) {
                    String string = xMLableReader.getAttr("isVisible");
                    if (string != null) {
                        // empty if block
                    }
                    if ((string = xMLableReader.getAttr("position")) != null) {
                        legend.setPosition(Integer.parseInt(string));
                    }
                    if ((string = xMLableReader.getAttr("legendNum")) != null) {
                        int n = -1;
                        try {
                            int n2 = Integer.parseInt(string);
                            n = n2 >= 0 ? n2 : -1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        legend.setMaxShowLegendNumber(n);
                    }
                    if ((string = xMLableReader.getAttr("iconBorderColor")) != null) {
                        legend.setBorderColor(new Color(Integer.parseInt(string), true));
                    }
                }
            }
        });
        return legend;
    }

    protected static void read62ChartDescriptor(final Chart chart, XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("HotHyperlink")) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 5 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode() && ("Hyperlink".equals(xMLableReader.getTagName()) || "JavaScript".equals(xMLableReader.getTagName())) && 5.access$100(this.this$0).getPlot() != null) {
                                    5.access$100(this.this$0).getPlot().setHotHyperLink(new NameJavaScriptGroup(ReportXMLUtils.readJavaScript(xMLableReader)));
                                }
                            }
                        });
                    } else if ("Style".equals(string)) {
                        Plot plot = ChartXMLCompatibleUtils.read62ChartStyle(xMLableReader);
                        chart.setPlot(plot);
                    } else if ("Color".equals(string) && chart.getPlot() != null) {
                        Color color = null;
                        String string2 = xMLableReader.getAttr("color");
                        if (string2 != null) {
                            color = new Color(Integer.parseInt(string2), true);
                        }
                        int n = -1;
                        string2 = xMLableReader.getAttr("index");
                        if (string2 != null) {
                            n = Integer.parseInt(string2);
                        }
                        if (color != null && n != -1) {
                            SeriesAttr seriesAttr = chart.getPlot().getSeriesCollection().getSeriesAttr(n);
                            SeriesAttrColor seriesAttrColor = (SeriesAttrColor)seriesAttr.isContains(new SeriesAttrColor());
                            if (seriesAttrColor == null) {
                                seriesAttrColor = new SeriesAttrColor();
                                seriesAttr.addCondition(seriesAttrColor);
                            }
                            seriesAttrColor.setSeriesColor(color);
                            SeriesAttrBackground seriesAttrBackground = (SeriesAttrBackground)seriesAttr.isContains(new SeriesAttrBackground());
                            if (seriesAttrBackground == null) {
                                seriesAttrBackground = new SeriesAttrBackground();
                                seriesAttr.addCondition(seriesAttrBackground);
                            }
                            seriesAttrBackground.setSeriesBackground(ColorBackground.getInstance(color));
                        }
                    }
                }
            }

            static /* synthetic */ Chart access$100(5 var0) {
                return var0.chart;
            }
        });
    }

    protected static Plot read62ChartStyle(XMLableReader xMLableReader) {
        Plot plot = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.equals("com.fr.chart.style.BarStyle") || string.equals("com.fr.chart.style.BarChartStyle")) {
                plot = ChartXMLCompatibleUtils.read62BarChartStyle(xMLableReader);
            } else if (string.equals("com.fr.chart.style.HBarStyle") || string.equals("com.fr.chart.style.HBarChartStyle")) {
                BarPlot barPlot = ChartXMLCompatibleUtils.read62BarChartStyle(xMLableReader);
                barPlot.setIsHorizontal(false);
                plot = barPlot;
            } else if (string.equals("com.fr.chart.style.LineStyle") || string.equals("com.fr.chart.style.LineChartStyle")) {
                plot = ChartXMLCompatibleUtils.read62LineChartStyle(xMLableReader);
            } else if (string.equals("com.fr.chart.style.AreaStyle") || string.equals("com.fr.chart.style.AreaChartStyle")) {
                plot = ChartXMLCompatibleUtils.read62AreaChartStyle(xMLableReader);
            } else if (string.equals("com.fr.chart.style.PieStyle") || string.equals("com.fr.chart.style.PieChartStyle")) {
                plot = ChartXMLCompatibleUtils.read62PieChartStyle(xMLableReader);
            } else if (string.equals("com.fr.chart.style.XYScatterStyle") || string.equals("com.fr.chart.style.XYScatterChartStyle")) {
                plot = ChartXMLCompatibleUtils.read62XYScatterChartStyle(xMLableReader);
            } else if (string.equals("com.fr.chart.style.RadarStyle") || string.equals("com.fr.chart.style.RadarChartStyle")) {
                plot = new RadarPlot();
            } else if (string.equals("com.fr.chart.style.StockStyle") || string.equals("com.fr.chart.style.StockChartStyle")) {
                plot = new StockPlot();
            }
        }
        if (plot == null) {
            plot = new Bar2DPlot();
        }
        return plot;
    }

    protected static BarPlot read62BarChartStyle(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(null){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isAttr()) {
                    this.obj = new Bar2DPlot();
                    ((BarPlot)this.obj).setIsHorizontal(true);
                } else if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("BarStyle".equals(string)) {
                        String string2 = xMLableReader.getAttr("is3D");
                        if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
                            this.obj = new Bar3DPlot();
                            ((BarPlot)this.obj).setIsHorizontal(true);
                        }
                        if ((string2 = xMLableReader.getAttr("isDrawBorder")) != null) {
                            ((BarPlot)this.obj).setBorderStyle(1);
                        }
                        if ((string2 = xMLableReader.getAttr("borderLineColor")) != null) {
                            ((BarPlot)this.obj).setBorderColor(new Color(Integer.parseInt(string2), true));
                        }
                        if ((string2 = xMLableReader.getAttr("isCubic3D")) != null && this.obj instanceof Bar3DPlot) {
                            ((Bar3DPlot)this.obj).setIsCubic3D(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("isTransparency")) != null) {
                            ((BarPlot)this.obj).setAlpha(0.5f);
                        }
                        if ((string2 = xMLableReader.getAttr("isCascade")) != null && this.obj instanceof Bar3DPlot) {
                            ((Bar3DPlot)this.obj).setIsCascade(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("barSpacePecent")) != null) {
                            ((BarPlot)this.obj).setCategoryIntervalPercent(Double.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("offSetPecent")) != null) {
                            // empty if block
                        }
                    } else {
                        ChartXMLCompatibleUtils.read62CategoryChartStyle((CategoryPlot)this.obj, xMLableReader);
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (BarPlot)xMLObject.getObject();
    }

    protected static Plot read62LineChartStyle(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(null){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isAttr()) {
                    this.obj = new LinePlot();
                } else if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("LineStyle".equals(string)) {
                        String string2 = xMLableReader.getAttr("is3D");
                        if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
                            this.obj = new Line3DPlot();
                        }
                        if ((string2 = xMLableReader.getAttr("isShowLine")) != null && this.obj instanceof LinePlot) {
                            ((LinePlot)this.obj).setIsShowLine(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("isShowHotMap")) != null) {
                            // empty if block
                        }
                        if ((string2 = xMLableReader.getAttr("lineStroke")) != null) {
                            // empty if block
                        }
                        if ((string2 = xMLableReader.getAttr("isShowMarker")) != null && this.obj instanceof LinePlot) {
                            ((LinePlot)this.obj).setIsShowMarker(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("markerSize")) != null) {
                            // empty if block
                        }
                        if ((string2 = xMLableReader.getAttr("startFromZero")) != null) {
                            // empty if block
                        }
                    } else {
                        ChartXMLCompatibleUtils.read62CategoryChartStyle((CategoryPlot)this.obj, xMLableReader);
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (Plot)xMLObject.getObject();
    }

    protected static Plot read62AreaChartStyle(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(null){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isAttr()) {
                    this.obj = new AreaPlot();
                } else if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("AreaStyle".equals(string)) {
                        String string2 = xMLableReader.getAttr("alpha");
                        if (string2 != null) {
                            ((AreaPlot)this.obj).setAlpha(Float.parseFloat(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("isDrawBorder")) != null && Boolean.valueOf(string2).booleanValue()) {
                            ((AreaPlot)this.obj).setBorderStyle(1);
                        }
                        if ((string2 = xMLableReader.getAttr("borderLineColor")) != null) {
                            ((AreaPlot)this.obj).setBorderColor(new Color(Integer.parseInt(string2), true));
                        }
                    } else {
                        ChartXMLCompatibleUtils.read62CategoryChartStyle((CategoryPlot)this.obj, xMLableReader);
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (Plot)xMLObject.getObject();
    }

    protected static Plot read62XYScatterChartStyle(XMLableReader xMLableReader) {
        final XYScatterPlot xYScatterPlot = new XYScatterPlot();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("Values".equals(string)) {
                        ChartXMLCompatibleUtils.read62AbstractChartStyle(xYScatterPlot, xMLableReader);
                    } else if ("Plot".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 10 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode()) {
                                    String string = xMLableReader.getTagName();
                                    if (string.equals("Border")) {
                                        String string2 = xMLableReader.getAttr("style");
                                        if (string2 != null) {
                                            10.access$200(this.this$0).setBorderStyle(Integer.parseInt(string2));
                                        }
                                        if ((string2 = xMLableReader.getAttr("color")) != null) {
                                            10.access$200(this.this$0).setBorderColor(new Color(Integer.parseInt(string2), true));
                                        }
                                    } else if (string.equals("Background")) {
                                        10.access$200(this.this$0).setBackground(BaseXMLUtils.readBackground(xMLableReader));
                                    } else if (string.equals("GridLine")) {
                                        String string3 = xMLableReader.getAttr("style");
                                        if (string3 != null) {
                                            10.access$200(this.this$0).getXAxis().setMainGridStyle(Integer.parseInt(string3));
                                            10.access$200(this.this$0).getYAxis().setMainGridStyle(Integer.parseInt(string3));
                                        }
                                        if ((string3 = xMLableReader.getAttr("color")) != null) {
                                            10.access$200(this.this$0).getXAxis().setMainGridColor(new Color(Integer.parseInt(string3), true));
                                            10.access$200(this.this$0).getYAxis().setMainGridColor(new Color(Integer.parseInt(string3), true));
                                        }
                                    }
                                }
                            }
                        });
                    } else if ("XYScatterStyle".equals(string)) {
                        String string2 = xMLableReader.getAttr("isShowLine");
                        if (string2 != null) {
                            xYScatterPlot.setShowLine(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("isShowMarker")) != null) {
                            xYScatterPlot.setShowMarker(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("markerSize")) != null) {
                            // empty if block
                        }
                    }
                }
            }

            static /* synthetic */ XYScatterPlot access$200(10 var0) {
                return var0.xYScatterPlot;
            }
        });
        return xYScatterPlot;
    }

    protected static Plot read62RadarChartStyle(XMLableReader xMLableReader) {
        final RadarPlot radarPlot = new RadarPlot();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("Values".equals(string)) {
                        ChartXMLCompatibleUtils.read62AbstractChartStyle(radarPlot, xMLableReader);
                    } else if ("Plot".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 12 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode()) {
                                    String string = xMLableReader.getTagName();
                                    if (string.equals("Border")) {
                                        String string2 = xMLableReader.getAttr("style");
                                        if (string2 != null) {
                                            12.access$300(this.this$0).setBorderStyle(Integer.parseInt(string2));
                                        }
                                        if ((string2 = xMLableReader.getAttr("color")) != null) {
                                            12.access$300(this.this$0).setBorderColor(new Color(Integer.parseInt(string2), true));
                                        }
                                    } else if (string.equals("Background")) {
                                        12.access$300(this.this$0).setBackground(BaseXMLUtils.readBackground(xMLableReader));
                                    } else if (string.equals("GridLine")) {
                                        String string3 = xMLableReader.getAttr("style");
                                        if (string3 != null) {
                                            12.access$300(this.this$0).getRadarAxis().setMainGridStyle(Integer.parseInt(string3));
                                        }
                                        if ((string3 = xMLableReader.getAttr("color")) != null) {
                                            12.access$300(this.this$0).getRadarAxis().setMainGridColor(new Color(Integer.parseInt(string3), true));
                                        }
                                    }
                                }
                            }
                        });
                    } else if ("RadarStyle".equals(string)) {
                        String string2 = xMLableReader.getAttr("isFilled");
                        if (string2 != null) {
                            radarPlot.setIsFilled(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("alpha")) != null) {
                            radarPlot.setAlpha(Float.parseFloat(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("isShowLine")) != null) {
                            radarPlot.setShowLine(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("isShowMarker")) != null) {
                            radarPlot.setShowMarker(Boolean.valueOf(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("markerSize")) != null) {
                            // empty if block
                        }
                    }
                }
            }

            static /* synthetic */ RadarPlot access$300(12 var0) {
                return var0.radarPlot;
            }
        });
        return radarPlot;
    }

    protected static Plot read62PieChartStyle(XMLableReader xMLableReader) {
        final DataLabelInfo dataLabelInfo = new DataLabelInfo();
        XMLObject xMLObject = new XMLObject(null){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isAttr()) {
                    this.obj = new PiePlot();
                } else if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("PieStyle".equals(string)) {
                        String string2 = xMLableReader.getAttr("is3D");
                        if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
                            this.obj = new Pie3DPlot();
                        }
                        if ((string2 = xMLableReader.getAttr("isShowPercentages")) != null && Boolean.valueOf(string2).booleanValue()) {
                            String string3 = dataLabelInfo.getSeriesLabel();
                            string3 = string3 != null ? string3 + "${PERCENT}" : "${PERCENT}";
                        }
                        if ((string2 = xMLableReader.getAttr("isDrawBorder")) != null && Boolean.valueOf(string2).booleanValue()) {
                            ((PiePlot)this.obj).setBorderStyle(1);
                        }
                        if ((string2 = xMLableReader.getAttr("borderLineColor")) != null) {
                            ((BarPlot)this.obj).setBorderColor(new Color(Integer.parseInt(string2), true));
                        }
                    } else if ("Plot".equals(string)) {
                        PiePlot piePlot = (PiePlot)this.obj;
                        xMLableReader.readXMLObject(new XMLReadable(this, piePlot){
                            private final /* synthetic */ PiePlot val$piePlot;
                            private final /* synthetic */ 14 this$0;
                            {
                                this.this$0 = var1_1;
                                this.val$piePlot = piePlot;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode()) {
                                    String string = xMLableReader.getTagName();
                                    if (string.equals("Border")) {
                                        String string2 = xMLableReader.getAttr("style");
                                        if (string2 != null) {
                                            this.val$piePlot.setBorderStyle(Integer.parseInt(string2));
                                        }
                                        if ((string2 = xMLableReader.getAttr("color")) != null) {
                                            this.val$piePlot.setBorderColor(new Color(Integer.parseInt(string2), true));
                                        }
                                    } else if (string.equals("Background")) {
                                        this.val$piePlot.setBackground(BaseXMLUtils.readBackground(xMLableReader));
                                    }
                                }
                            }
                        });
                    } else {
                        ChartXMLCompatibleUtils.read62AbstractChartStyle((Plot)this.obj, xMLableReader);
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        PiePlot piePlot = (PiePlot)xMLObject.getObject();
        dataLabelInfo.add2SeriesAttr(piePlot.getSeriesCollection().getDefaultSeriesAttr());
        return piePlot;
    }

    protected static void read62CategoryChartStyle(final CategoryPlot categoryPlot, XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if ("Values".equals(string)) {
            ChartXMLCompatibleUtils.read62AbstractChartStyle(categoryPlot, xMLableReader);
        } else if ("Plot".equals(string)) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        String string = xMLableReader.getTagName();
                        String string2 = null;
                        if ("Border".equals(string)) {
                            string2 = xMLableReader.getAttr("style");
                            if (string2 != null) {
                                categoryPlot.setBorderStyle(Integer.parseInt(string2));
                            }
                            if ((string2 = xMLableReader.getAttr("color")) != null) {
                                categoryPlot.setBorderColor(new Color(Integer.parseInt(string2), true));
                            }
                        } else if ("Background".equals(string)) {
                            categoryPlot.setBackground(BaseXMLUtils.readBackground(xMLableReader));
                        } else if ("GridLine".equals(string)) {
                            string2 = xMLableReader.getAttr("style");
                            if (string2 != null) {
                                categoryPlot.getCategoryAxis().setMainGridStyle(Integer.parseInt(string2));
                                categoryPlot.getValueAxis().setMainGridStyle(Integer.parseInt(string2));
                            }
                            if ((string2 = xMLableReader.getAttr("color")) != null) {
                                categoryPlot.getCategoryAxis().setMainGridColor(new Color(Integer.parseInt(string2), true));
                                categoryPlot.getValueAxis().setMainGridColor(new Color(Integer.parseInt(string2), true));
                            }
                        }
                    }
                }
            });
        } else if ("CategoryStyle".equals(string)) {
            String string2 = xMLableReader.getAttr("isStacked");
            if (string2 != null) {
                categoryPlot.setIsStacked(Boolean.valueOf(string2));
            }
            if ((string2 = xMLableReader.getAttr("bgStagger")) != null) {
                categoryPlot.setBgStagger(Boolean.valueOf(string2));
            }
            if ((string2 = xMLableReader.getAttr("isHorizontal")) != null && categoryPlot instanceof BarPlot) {
                ((BarPlot)categoryPlot).setIsHorizontal(Boolean.valueOf(string2));
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (!xMLableReader.isChildNode() || (string = xMLableReader.getAttr("class")) != null) {
                        // empty if block
                    }
                }
            });
        }
    }

    protected static void read62AbstractChartStyle(Plot plot, XMLableReader xMLableReader) {
        final DataLabelInfo dataLabelInfo = new DataLabelInfo();
        dataLabelInfo.add2SeriesAttr(plot.getSeriesCollection().getDefaultSeriesAttr());
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isAttr()) {
                    String string = xMLableReader.getAttr("isShowValues");
                    if (string != null && Boolean.valueOf(string).booleanValue()) {
                        String string2 = dataLabelInfo.getSeriesLabel();
                        string2 = string2 != null ? string2 + "${VALUE}" : "${VALUE}";
                    }
                } else if (xMLableReader.isChildNode()) {
                    if ("Format".equals(xMLableReader.getTagName())) {
                        dataLabelInfo.setFormat(ReportXMLUtils.readFormat(xMLableReader));
                    } else if ("TextAttributes".equals(xMLableReader.getTagName()) && xMLableReader.isAttr()) {
                        String string = xMLableReader.getAttr("isVerticalText");
                        if (string != null) {
                            dataLabelInfo.getTextAttr().setAlignText(Byte.parseByte(string));
                        }
                        if ((string = xMLableReader.getAttr("textDirection")) != null) {
                            dataLabelInfo.getTextAttr().setDirection(Integer.parseInt(string));
                        }
                        if ((string = xMLableReader.getAttr("rotation")) != null) {
                            dataLabelInfo.getTextAttr().setRotation(Integer.parseInt(string));
                        }
                    }
                }
            }
        });
    }

    public static SeriesCollection read65DataSeriesCollection(XMLableReader xMLableReader, final SeriesCollection seriesCollection) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("Default".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 19 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                String string;
                                if (xMLableReader.isAttr()) {
                                    String string2 = xMLableReader.getAttr("alpha");
                                    if (string2 != null) {
                                        SeriesAttrAlpha seriesAttrAlpha = new SeriesAttrAlpha();
                                        seriesAttrAlpha.setAlpha(Float.parseFloat(string2));
                                        19.access$400(this.this$0).getDefaultSeriesAttr().addCondition(seriesAttrAlpha);
                                    }
                                } else if (xMLableReader.isChildNode() && ("DataLabel".equals(string = xMLableReader.getTagName()) || string.equals("PieDataLabelInfo"))) {
                                    DataLabelInfo dataLabelInfo = (DataLabelInfo)xMLableReader.readXMLObject(new DataLabelInfo());
                                    dataLabelInfo.add2SeriesAttr(19.access$400(this.this$0).getDefaultSeriesAttr());
                                }
                            }
                        });
                    } else if ("ColorMap".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 19 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode() && "Entry".equals(xMLableReader.getTagName())) {
                                    int n = -1;
                                    String string = xMLableReader.getAttr("index");
                                    if (string != null) {
                                        n = Integer.parseInt(string);
                                    }
                                    Color color = null;
                                    string = xMLableReader.getAttr("color");
                                    if (string != null) {
                                        color = new Color(Integer.parseInt(string), true);
                                    }
                                    if (n != -1) {
                                        SeriesAttr seriesAttr = null;
                                        try {
                                            seriesAttr = (SeriesAttr)19.access$400(this.this$0).getSeriesAttr(n).clone();
                                        }
                                        catch (CloneNotSupportedException cloneNotSupportedException) {
                                            cloneNotSupportedException.printStackTrace();
                                        }
                                        SeriesAttrColor seriesAttrColor = new SeriesAttrColor();
                                        seriesAttrColor.setSeriesColor(color);
                                        seriesAttr.addCondition(seriesAttrColor);
                                        SeriesAttrBackground seriesAttrBackground = new SeriesAttrBackground();
                                        seriesAttrBackground.setSeriesBackground(ColorBackground.getInstance(color));
                                        seriesAttr.addCondition(seriesAttrBackground);
                                        SeriesAttrLine seriesAttrLine = new SeriesAttrLine();
                                        seriesAttrLine.setSeriesLineColor(color);
                                        seriesAttr.addCondition(seriesAttrLine);
                                        19.access$400(this.this$0).putSeriesAttr(n, seriesAttr);
                                    }
                                }
                            }
                        });
                    } else if ("LineColorMap".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 19 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode() && "Entry".equals(xMLableReader.getTagName())) {
                                    int n = -1;
                                    String string = xMLableReader.getAttr("index");
                                    if (string != null) {
                                        n = Integer.parseInt(string);
                                    }
                                    Color color = null;
                                    string = xMLableReader.getAttr("color");
                                    if (string != null) {
                                        color = new Color(Integer.parseInt(string), true);
                                    }
                                    if (n != -1) {
                                        SeriesAttr seriesAttr = null;
                                        try {
                                            seriesAttr = (SeriesAttr)19.access$400(this.this$0).getSeriesAttr(n).clone();
                                        }
                                        catch (CloneNotSupportedException cloneNotSupportedException) {
                                            cloneNotSupportedException.printStackTrace();
                                        }
                                        SeriesAttrBorder seriesAttrBorder = (SeriesAttrBorder)seriesAttr.isContains(new SeriesAttrBorder());
                                        if (seriesAttrBorder == null) {
                                            seriesAttrBorder = new SeriesAttrBorder();
                                            seriesAttr.addCondition(seriesAttrBorder);
                                        }
                                        seriesAttrBorder.setBorderColor(color);
                                        19.access$400(this.this$0).putSeriesAttr(n, seriesAttr);
                                    }
                                }
                            }
                        });
                    } else if ("LineStyleMap".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 19 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode() && "Entry".equals(xMLableReader.getTagName())) {
                                    int n = -1;
                                    String string = xMLableReader.getAttr("index");
                                    if (string != null) {
                                        n = Integer.parseInt(string);
                                    }
                                    if ((string = xMLableReader.getAttr("lineStyle")) != null) {
                                        int n2 = Integer.parseInt(string);
                                        if (n != -1) {
                                            SeriesAttr seriesAttr = null;
                                            try {
                                                seriesAttr = (SeriesAttr)19.access$400(this.this$0).getSeriesAttr(n).clone();
                                            }
                                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                                cloneNotSupportedException.printStackTrace();
                                            }
                                            SeriesAttrBorder seriesAttrBorder = (SeriesAttrBorder)seriesAttr.isContains(new SeriesAttrBorder());
                                            if (seriesAttrBorder == null) {
                                                seriesAttrBorder = new SeriesAttrBorder();
                                                seriesAttr.addCondition(seriesAttrBorder);
                                            }
                                            seriesAttrBorder.setBorderStyle(n2);
                                            19.access$400(this.this$0).putSeriesAttr(n, seriesAttr);
                                        }
                                    }
                                }
                            }
                        });
                    } else if ("DataLabelMap".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 19 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if ("Entry".equals(xMLableReader.getTagName())) {
                                    int n = -1;
                                    String string = xMLableReader.getAttr("index");
                                    if (string != null) {
                                        n = Integer.parseInt(string);
                                    }
                                    if (n != -1) {
                                        xMLableReader.readXMLObject(new XMLObject(this, new Integer(n)){
                                            private final /* synthetic */ 24 this$1;
                                            {
                                                super(object);
                                                this.this$1 = var1_1;
                                            }

                                            public void readXML(XMLableReader xMLableReader) {
                                                if (xMLableReader.isChildNode()) {
                                                    int n = Utils.string2Number(this.obj.toString()).intValue();
                                                    SeriesAttr seriesAttr = null;
                                                    try {
                                                        seriesAttr = (SeriesAttr)19.access$400(24.access$500(this.this$1)).getSeriesAttr(n).clone();
                                                    }
                                                    catch (CloneNotSupportedException cloneNotSupportedException) {
                                                        cloneNotSupportedException.printStackTrace();
                                                    }
                                                    String string = xMLableReader.getTagName();
                                                    if ("DataLabel".equals(string) || string.equals("PieDataLabelInfo")) {
                                                        DataLabelInfo dataLabelInfo = (DataLabelInfo)xMLableReader.readXMLObject(new DataLabelInfo());
                                                        dataLabelInfo.add2SeriesAttr(seriesAttr);
                                                    }
                                                    19.access$400(24.access$500(this.this$1)).putSeriesAttr(n, seriesAttr);
                                                }
                                            }
                                        });
                                    }
                                }
                            }

                            static /* synthetic */ 19 access$500(24 var0) {
                                return var0.this$0;
                            }
                        });
                    } else if ("SeriesLineStyleMap".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 19 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode() && "Entry".equals(xMLableReader.getTagName())) {
                                    int n = -1;
                                    String string = xMLableReader.getAttr("index");
                                    if (string != null) {
                                        n = Integer.parseInt(string);
                                    }
                                    if ((string = xMLableReader.getAttr("lineStyle")) != null) {
                                        int n2 = Integer.parseInt(string);
                                        if (n != -1) {
                                            SeriesAttr seriesAttr = null;
                                            try {
                                                seriesAttr = (SeriesAttr)19.access$400(this.this$0).getSeriesAttr(n).clone();
                                            }
                                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                                cloneNotSupportedException.printStackTrace();
                                            }
                                            SeriesAttrLine seriesAttrLine = (SeriesAttrLine)seriesAttr.isContains(new SeriesAttrLine());
                                            if (seriesAttrLine == null) {
                                                seriesAttrLine = new SeriesAttrLine();
                                                seriesAttr.addCondition(seriesAttrLine);
                                            }
                                            seriesAttrLine.setSeriesLineStyle(n2);
                                            19.access$400(this.this$0).putSeriesAttr(n, seriesAttr);
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
            }

            static /* synthetic */ SeriesCollection access$400(19 var0) {
                return var0.seriesCollection;
            }
        });
        return seriesCollection;
    }
}

