/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.LineStyleInfo;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class FoldLine
extends SoloGlyph {
    private static final long serialVersionUID = -1373367876731556523L;
    public static final String XML_TAG = "FoldLine";
    private GeneralPath generalPath;
    private LineStyleInfo lineStyleInfo = new LineStyleInfo();

    public FoldLine() {
    }

    public FoldLine(GeneralPath generalPath) {
        this.setGeneralPath(generalPath);
    }

    public void draw(Graphics graphics) {
        this.lineStyleInfo.paint(graphics, this.getGeneralPath());
    }

    public Shape getShape() {
        return this.getGeneralPath();
    }

    public void setGeneralPath(GeneralPath generalPath) {
        this.generalPath = generalPath;
    }

    public GeneralPath getGeneralPath() {
        return this.generalPath;
    }

    public void setLineStyleInfo(LineStyleInfo lineStyleInfo) {
        this.lineStyleInfo = lineStyleInfo;
    }

    public LineStyleInfo getLineStyleInfo() {
        return this.lineStyleInfo;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("GeneralPath")) {
            this.setGeneralPath(ReportXMLUtils.readGeneralPath(xMLableReader));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.getGeneralPath() != null) {
            ReportXMLUtils.writeGeneralPath(xMLPrintWriter, this.getGeneralPath());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FoldLine)) {
            return false;
        }
        FoldLine foldLine = (FoldLine)object;
        if (!Equals.euqalsShape(this.getGeneralPath(), foldLine.getGeneralPath())) {
            return false;
        }
        return Equals.equals(foldLine.lineStyleInfo, this.lineStyleInfo);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.generalPath != null) {
            jSONObject.put("generalPath", this.generalPath);
        }
        if (this.lineStyleInfo != null) {
            jSONObject.put("lineStyleInfo", this.lineStyleInfo.toJSONObject());
        }
        return jSONObject;
    }
}

