/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core;

import com.fr.base.core.GraphHelper;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.SoloGlyph;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;

public class LineGlyph
extends SoloGlyph {
    private static final long serialVersionUID = -8730002316936686988L;
    public static final String XML_TAG = "LineGlyph";
    private Line2D line;
    private int lineStyle = 1;
    private Color lineColor = Color.black;
    private float alpha = 1.0f;

    public LineGlyph() {
    }

    public LineGlyph(Line2D line2D) {
        this.line = line2D;
    }

    public Line2D getLine() {
        return this.line;
    }

    public void setLine(Line2D line2D) {
        this.line = line2D;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void draw(Graphics graphics) {
        if (this.line == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        graphics2D.setPaint(this.getLineColor());
        GraphHelper.drawLine(graphics2D, this.line.getX1(), this.line.getY1(), this.line.getX2(), this.line.getY2(), this.getLineStyle());
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public Shape getShape() {
        return this.line;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Line")) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                String string2 = xMLableReader.getAttr("x1");
                if (string2 != null) {
                    d = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("y1")) != null) {
                    d3 = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("x2")) != null) {
                    d2 = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("y2")) != null) {
                    d4 = Double.valueOf(string2);
                }
                this.line = new Line2D.Double(d, d3, d2, d4);
            } else if (string.equals("Attr")) {
                String string3 = xMLableReader.getAttr("lineColor");
                if (string3 != null) {
                    this.setLineColor(new Color(Integer.parseInt(string3), true));
                }
                if ((string3 = xMLableReader.getAttr("lineStyle")) != null) {
                    this.setLineStyle(Integer.parseInt(string3));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.line != null) {
            xMLPrintWriter.startTAG("Line").attr("x1", this.line.getX1()).attr("y1", this.line.getY1()).attr("x2", this.line.getX2()).attr("y2", this.line.getY2()).end();
        }
        xMLPrintWriter.startTAG("Attr");
        if (this.lineColor != null) {
            xMLPrintWriter.attr("lineColor", this.getLineColor().getRGB());
        }
        xMLPrintWriter.attr("lineStyle", this.getLineStyle());
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineGlyph)) {
            return false;
        }
        LineGlyph lineGlyph = (LineGlyph)object;
        if (!Equals.equals(lineGlyph.getLine(), this.getLine())) {
            return false;
        }
        if (!Equals.equals(lineGlyph.getLineColor(), this.getLineColor())) {
            return false;
        }
        return lineGlyph.getLineStyle() == this.getLineStyle();
    }
}

