/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.GeneralGlyph;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class RectangleGlyph
extends GeneralGlyph {
    private static final long serialVersionUID = -3506981313101696057L;
    protected boolean visible;
    public static RectangularShape NULL_SHAPE = new Rectangle(){

        public Rectangle2D getBounds2D() {
            return this;
        }
    };
    protected transient RectangularShape bounds = NULL_SHAPE;

    public void setBounds(RectangularShape rectangularShape) {
        this.bounds = rectangularShape;
    }

    public Rectangle2D getBounds() {
        if (this.bounds != null) {
            return this.bounds.getBounds2D();
        }
        return null;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Shape getOutline4Fill() {
        return this.bounds;
    }

    public Shape getShape() {
        return this.bounds;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RectangleGlyph)) {
            return false;
        }
        RectangleGlyph rectangleGlyph = (RectangleGlyph)object;
        if (!super.equals(rectangleGlyph)) {
            return false;
        }
        if (!Equals.equals(rectangleGlyph.getBounds(), this.getBounds())) {
            return false;
        }
        return rectangleGlyph.isVisible() == this.isVisible();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("Bounds".equals(string2)) {
                this.bounds = ReportXMLUtils.readRectangularShape(xMLableReader);
            }
            if (string2.equals("Visible") && (string = xMLableReader.getAttr("value")) != null) {
                this.visible = Boolean.valueOf(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.bounds != null) {
            ReportXMLUtils.writeRectangularShape(xMLPrintWriter, this.bounds);
        }
        xMLPrintWriter.startTAG("Visible").attr("value", this.visible).end();
    }

    public Object clone() throws CloneNotSupportedException {
        RectangleGlyph rectangleGlyph = (RectangleGlyph)super.clone();
        if (this.bounds != null) {
            rectangleGlyph.bounds = (RectangularShape)this.bounds.clone();
        }
        return rectangleGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("visible", this.visible);
        return jSONObject;
    }
}

