/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Shadow
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 316720726448090470L;
    public static final String XML_TAG = "Shadow";
    private Shape shape;
    private float offset = 0.0f;

    public Shadow(Shape shape) {
        this.shape = shape;
    }

    public void paint(Graphics graphics) {
        if (this.shape == null) {
            return;
        }
        float f = 3.0f;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        graphics2D.setPaint(new GradientPaint((float)rectangle2D.getWidth(), 0.0f, new Color(120, 120, 120), this.offset + (float)rectangle2D.getWidth() + f, 0.0f, Color.WHITE));
        graphics2D.fill(new Rectangle2D.Double(rectangle2D.getWidth(), 0.0, this.offset + f, rectangle2D.getHeight()));
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        graphics2D.setPaint(paint);
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public float getOffset() {
        return this.offset;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Shadow)) {
            return false;
        }
        Shadow shadow = (Shadow)object;
        if (!Equals.euqalsShape(shadow.shape, this.shape)) {
            return false;
        }
        return shadow.offset == this.offset;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            this.shape = ReportXMLUtils.readShape(xMLableReader);
            if (xMLableReader.getTagName().equals("Attr") && (string = xMLableReader.getAttr("offset")) != null) {
                this.offset = Float.parseFloat(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("offset", this.offset).end();
        if (this.getShape() != null) {
            ReportXMLUtils.writeShape(xMLPrintWriter, this.getShape());
        }
        xMLPrintWriter.end();
    }
}

