/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.LineStyleInfo;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.core.FoldLine;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class TrendLine
extends FoldLine {
    private static final long serialVersionUID = -993509754275088848L;
    public static int LINEAR = 0;
    public static int POLYNOMIAL = 1;
    public static int LOG = 2;
    public static int EXPONENT = 3;
    public static int POWER = 4;
    private double[] val = new double[2];
    private int equation = POLYNOMIAL;
    private double R = 0.0;
    private int square = 6;

    public TrendLine() {
    }

    public TrendLine(int n) {
        this.setEquation(n);
    }

    public void setEquation(int n) {
        this.equation = n;
    }

    public int getEquation() {
        return this.equation;
    }

    public double getR() {
        return this.R;
    }

    public Shape getTrendLine() {
        return this.getGeneralPath();
    }

    public void setSquare(int n) {
        this.square = n;
    }

    public int getSquare() {
        return this.square;
    }

    public void drawShape(Rectangle2D rectangle2D) {
        if (this.getEquation() < 0 || this.getEquation() > 4) {
            return;
        }
        boolean bl = true;
        GeneralPath generalPath = new GeneralPath();
        for (double d = rectangle2D.getX(); d < rectangle2D.getWidth() + rectangle2D.getX(); d += 1.0) {
            double d2 = this.calculator(d);
            if (d2 > rectangle2D.getHeight() || d2 < 0.0) {
                bl = true;
                continue;
            }
            if (bl) {
                generalPath.moveTo((float)d, (float)d2);
                bl = false;
                continue;
            }
            generalPath.lineTo((float)d, (float)d2);
        }
        this.setGeneralPath(generalPath);
    }

    public void fitting(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            return;
        }
        int n = this.square = this.square > dArray.length - 1 ? dArray.length - 1 : this.square;
        if (this.getEquation() == LINEAR) {
            this.linear(dArray, dArray2);
        } else if (this.getEquation() == POLYNOMIAL) {
            this.polynomial(dArray, dArray2, this.square);
        } else if (this.getEquation() == LOG) {
            this.log(dArray, dArray2);
        } else if (this.getEquation() == EXPONENT) {
            this.exponent(dArray, dArray2);
        } else if (this.getEquation() == POWER) {
            this.power(dArray, dArray2);
        }
        this.calR(dArray, dArray2);
    }

    public String toString() {
        if (this.getEquation() == LINEAR) {
            if (this.val[1] < 0.0) {
                return this.val[0] + " * x - " + -this.val[1];
            }
            return this.val[0] + " * x + " + this.val[1];
        }
        if (this.getEquation() == POLYNOMIAL) {
            String string;
            String string2;
            if (this.val[0] < 0.0) {
                string2 = -this.val[0] + "";
                string = "-";
            } else {
                string2 = this.val[0] + "";
                string = "+";
            }
            for (int i = 1; i < this.val.length; ++i) {
                string2 = " * POWER(x, " + i + ") " + string + " " + string2;
                if (this.val[i] < 0.0) {
                    string2 = -this.val[i] + string2;
                    string = "-";
                    continue;
                }
                string2 = this.val[i] + string2;
                string = "+";
            }
            return string2;
        }
        if (this.getEquation() == LOG) {
            if (this.val[1] < 0.0) {
                return this.val[0] + " * LN(x) - " + -this.val[1];
            }
            return this.val[0] + " * LN(x) + " + this.val[1];
        }
        if (this.getEquation() == EXPONENT) {
            return this.val[0] + " * EXP(" + this.val[1] + " * x)";
        }
        if (this.getEquation() == POWER) {
            return this.val[0] + " * POWER(x, " + this.val[1] + ")";
        }
        return "";
    }

    public Object clone() {
        TrendLine trendLine = new TrendLine(this.equation);
        trendLine.square = this.square;
        trendLine.setLineStyleInfo(this.getLineStyleInfo());
        return trendLine;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("LineStyleInfo")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getTagName();
                        if (string.equals("LineStyleInfo")) {
                            TrendLine.this.setLineStyleInfo((LineStyleInfo)xMLableReader.readXMLObject(new LineStyleInfo()));
                        }
                    }
                });
            } else if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("square");
                if (string2 != null) {
                    this.square = Integer.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("equation")) != null) {
                    this.equation = Integer.valueOf(string2);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("TrendLine");
        xMLPrintWriter.startTAG("Attr").attr("equation", this.equation).attr("square", this.square).end();
        this.getLineStyleInfo().writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("equation", this.equation);
        jSONObject.put("square", this.square);
        jSONObject.put("lineColor", ChartUtils.color2JS(this.getLineStyleInfo().getSeriesLineColor()));
        jSONObject.put("lineStyle", this.getLineStyleInfo().getSeriesLineStyle());
        return jSONObject;
    }

    protected void calR(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = this.calculator(dArray[i]);
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d += (dArray3[i] - dArray2[i]) * (dArray3[i] - dArray2[i]);
            d3 += dArray2[i];
            d2 += dArray2[i] * dArray2[i];
        }
        this.R = 1.0 - d / (d2 -= d3 * d3 / (double)dArray2.length);
    }

    protected double calculator(double d) {
        if (this.getEquation() == LINEAR) {
            return this.linearFunc(d);
        }
        if (this.getEquation() == POLYNOMIAL) {
            return this.polynomialFunc(d);
        }
        if (this.getEquation() == LOG) {
            return this.logFunc(d);
        }
        if (this.getEquation() == EXPONENT) {
            return this.exponentFunc(d);
        }
        if (this.getEquation() == POWER) {
            return this.powerFunc(d);
        }
        return Double.NaN;
    }

    protected void linear(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
            d2 += dArray2[i];
            d3 += dArray[i] * dArray[i];
            d4 += dArray[i] * dArray2[i];
        }
        if (d * d - d3 * (double)n == 0.0) {
            return;
        }
        this.val[0] = (d2 * d - d4 * (double)n) / (d * d - d3 * (double)n);
        this.val[1] = (d2 - d * this.val[0]) / (double)n;
    }

    protected void polynomial(double[] dArray, double[] dArray2, int n) {
        int n2;
        double d;
        int n3;
        int n4;
        double[][] dArray3 = new double[++n][dArray.length];
        double[][] dArray4 = new double[n][n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        this.val = new double[n];
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < dArray.length; ++n3) {
                d = 1.0;
                for (int i = 0; i < n4; ++i) {
                    d *= dArray[n3];
                }
                dArray3[n4][n3] = d;
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            for (n2 = 0; n2 < n; ++n2) {
                d = 0.0;
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    d += dArray3[n4][n3] * dArray3[n2][n3];
                }
                dArray4[n4][n2] = d;
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            d = 0.0;
            for (n3 = 0; n3 < dArray.length; ++n3) {
                d += dArray2[n3] * dArray3[n4][n3];
            }
            dArray5[n4] = d;
        }
        for (n4 = 1; n4 < n; ++n4) {
            dArray4[n4][0] = dArray4[n4][0] / dArray4[0][0];
        }
        for (n4 = 1; n4 < n; ++n4) {
            for (n3 = n4; n3 < n; ++n3) {
                d = 0.0;
                for (n2 = 0; n2 < n4; ++n2) {
                    d += dArray4[n2][n3] * dArray4[n4][n2];
                }
                dArray4[n4][n3] = dArray4[n4][n3] - d;
                if (n3 + 1 == n) continue;
                d = 0.0;
                for (n2 = 0; n2 < n4; ++n2) {
                    d += dArray4[n2][n4] * dArray4[n3 + 1][n2];
                }
                dArray4[n3 + 1][n4] = (dArray4[n3 + 1][n4] - d) / dArray4[n4][n4];
            }
        }
        dArray6[0] = dArray5[0];
        for (n4 = 1; n4 < n; ++n4) {
            d = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                d += dArray4[n4][n3] * dArray6[n3];
            }
            dArray6[n4] = dArray5[n4] - d;
        }
        this.val[n - 1] = dArray6[n - 1] / dArray4[n - 1][n - 1];
        for (n4 = n - 2; n4 >= 0; --n4) {
            d = 0.0;
            for (n3 = n4 + 1; n3 < n; ++n3) {
                d += dArray4[n4][n3] * this.val[n3];
            }
            this.val[n4] = (dArray6[n4] - d) / dArray4[n4][n4];
        }
    }

    protected void log(double[] dArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0)) continue;
            ++n;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0)) continue;
            dArray3[n] = Math.log(dArray[i]);
            dArray4[n] = dArray2[i];
            ++n;
        }
        this.linear(dArray3, dArray4);
    }

    protected void exponent(double[] dArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray2[i] > 0.0)) continue;
            ++n;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        n = 0;
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(dArray2[i] > 0.0)) continue;
            dArray3[n] = dArray[i];
            dArray4[n] = Math.log(dArray2[i]);
            ++n;
        }
        this.linear(dArray3, dArray4);
        double d = this.val[0];
        this.val[0] = Math.exp(this.val[1]);
        this.val[1] = d;
    }

    protected void power(double[] dArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0) || !(dArray2[i] > 0.0)) continue;
            ++n;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0) || !(dArray2[i] > 0.0)) continue;
            dArray3[n] = Math.log(dArray[i]);
            dArray4[n] = Math.log(dArray2[i]);
            ++n;
        }
        this.linear(dArray3, dArray4);
        double d = this.val[0];
        this.val[0] = Math.exp(this.val[1]);
        this.val[1] = d;
    }

    protected double linearFunc(double d) {
        return this.val[0] * d + this.val[1];
    }

    protected double polynomialFunc(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.val.length; ++i) {
            d2 += this.val[i] * Math.pow(d, i);
        }
        return d2;
    }

    protected double logFunc(double d) {
        if (d <= 0.0) {
            return Double.NaN;
        }
        return this.val[0] * Math.log(d) + this.val[1];
    }

    protected double exponentFunc(double d) {
        return this.val[0] * Math.exp(d * this.val[1]);
    }

    protected double powerFunc(double d) {
        return this.val[0] * Math.pow(d, this.val[1]);
    }
}

