/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.CategoryPlotGlyph;
import com.fr.chart.math.Plot3D;
import com.fr.chart.math.Projection;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.shape3d.Area3D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Area3DPlotGlyph
extends CategoryPlotGlyph
implements Plot3D {
    private static final long serialVersionUID = 823999902188932597L;
    public static final String XML_TAG = "Area3DPlotGlyph";
    private Projection projection = new Projection();
    private int deep;
    private double seriesIntervalPercent;

    public void layoutAxisGlyph() {
        super.layoutAxisGlyph();
        this.layout3DAxisGlyph();
    }

    public void layoutDataSeriesGlyph() {
        double d = this.getDeep();
        if (d == -1.0) {
            d = this.getBounds().getWidth();
        }
        if (this.isStacked()) {
            double d2 = d / (1.0 + this.getSeriesIntervalPercent());
            double d3 = -this.getSeriesIntervalPercent() * d2 * 0.5;
            for (int i = 0; i < this.getSeriesSize(); ++i) {
                int n;
                DataSeries dataSeries = this.getSeries(i);
                Area3D area3D = new Area3D(d3, d2);
                dataSeries.setDrawImpl(area3D);
                area3D.setProjection(this.projection);
                area3D.getColorInfo().dealCondition(this.getSeriesCollection(), i);
                double[] dArray = new double[dataSeries.getDataPointCount()];
                float f = (float)this.getCategoryAxisGlyph().getPoint2DCateAxis(0.0, 0.0).getX();
                float f2 = (float)this.getValueAxisGlyph().getPoint2D(0.0).getY();
                for (n = 0; n < dataSeries.getDataPointCount(); ++n) {
                    DataPoint dataPoint = dataSeries.getDataPoint(n);
                    if (dataPoint.isValueIsNull()) continue;
                    double d4 = this.getDataPointPercentValue(i, n);
                    f = (float)this.getCategoryAxisGlyph().getPoint2DCateAxis(n, 0.0).getX();
                    double d5 = 0.0;
                    for (int j = i - 1; j >= 0; --j) {
                        d5 += this.getDataPointPercentValue(j, n);
                    }
                    f2 = (float)(this.getValueAxisGlyph().getBounds().getY() + (double)((float)this.getValueAxisGlyph().getPoint2D(d5 + d4).getY()));
                    dArray[n] = this.getValueAxisGlyph().getBounds().getY() + (double)((float)this.getValueAxisGlyph().getPoint2D(d5).getY());
                    if (n == 0) {
                        area3D.moveTo(f, f2);
                    } else {
                        area3D.lineTo(f, f2);
                    }
                    Point2D point2D = this.projection.projectee(f, f2, d3);
                    dataPoint.setShape(new Arc2D.Double(point2D.getX() - 3.0, point2D.getY() - 3.0, 6.0, 6.0, 0.0, 360.0, 2));
                    this.dealDataPointLabelBounds(dataPoint, i);
                }
                for (n = dArray.length - 1; n >= 0; --n) {
                    if (dataSeries.getDataPoint(n).isValueIsNull()) continue;
                    area3D.lineTo((float)this.getCategoryAxisGlyph().getPoint2DCateAxis(n, 0.0).getX(), (float)dArray[n]);
                }
                area3D.closePath();
            }
        } else {
            int n = this.getSeriesSize();
            double d6 = d / ((1.0 + this.getSeriesIntervalPercent()) * (double)n);
            for (int i = 0; i < this.getSeriesSize(); ++i) {
                int n2;
                DataSeries dataSeries = this.getSeries(i);
                double d7 = -this.getSeriesIntervalPercent() * d6 * (0.5 + (double)i) - d6 * (double)i;
                Area3D area3D = new Area3D(d7, d6);
                dataSeries.setDrawImpl(area3D);
                area3D.setProjection(this.projection);
                area3D.getColorInfo().dealCondition(this.getSeriesCollection(), i);
                double[] dArray = new double[dataSeries.getDataPointCount()];
                float f = (float)this.getCategoryAxisGlyph().getPoint2DCateAxis(0.0, 0.0).getX();
                float f3 = (float)this.getValueAxisGlyph().getPoint2D(0.0).getY();
                for (n2 = 0; n2 < dataSeries.getDataPointCount(); ++n2) {
                    DataPoint dataPoint = dataSeries.getDataPoint(n2);
                    if (dataPoint.isValueIsNull()) continue;
                    double d8 = dataSeries.getDataPoint(n2).getValue();
                    f = (float)this.getCategoryAxisGlyph().getPoint2DCateAxis(n2, 0.0).getX();
                    f3 = (float)(this.getValueAxisGlyph().getBounds().getY() + (double)((float)this.getValueAxisGlyph().getPoint2D(d8).getY()));
                    dArray[n2] = this.getValueAxisGlyph().getBounds().getY() + (double)((float)this.getValueAxisGlyph().getPoint2D(0.0).getY());
                    if (n2 == 0) {
                        area3D.moveTo(f, f3);
                    } else {
                        area3D.lineTo(f, f3);
                    }
                    Point2D point2D = this.projection.projectee(f, f3, d7);
                    dataPoint.setShape(new Arc2D.Double(point2D.getX() - 3.0, point2D.getY() - 3.0, 6.0, 6.0, 0.0, 360.0, 2));
                    this.dealDataPointLabelBounds(dataPoint, i);
                }
                for (n2 = dArray.length - 1; n2 >= 0; --n2) {
                    if (dataSeries.getDataPoint(n2).isValueIsNull()) continue;
                    area3D.lineTo((float)this.getCategoryAxisGlyph().getPoint2DCateAxis(n2, 0.0).getX(), (float)dArray[n2]);
                }
                area3D.closePath();
            }
        }
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.valueAxisGlyph != null) {
            this.valueAxisGlyph.draw(graphics);
        }
        if (this.categoryAxisGlyph != null) {
            this.categoryAxisGlyph.draw(graphics);
        }
        if (this.isStacked) {
            int n;
            int n2 = this.getSeriesSize();
            for (n = 0; n < n2; ++n) {
                this.getSeries(n).draw(graphics);
            }
            n2 = this.getSeriesSize();
            for (n = 0; n < n2; ++n) {
                this.getSeries(n).drawLabel(graphics);
            }
        } else {
            int n;
            for (n = this.getSeriesSize() - 1; n >= 0; --n) {
                this.getSeries(n).draw(graphics);
            }
            for (n = this.getSeriesSize() - 1; n >= 0; --n) {
                this.getSeries(n).drawLabel(graphics);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setSeriesIntervalPercent(double d) {
        this.seriesIntervalPercent = d;
    }

    public double getSeriesIntervalPercent() {
        return this.seriesIntervalPercent;
    }

    public void setDeep(int n) {
        this.deep = n;
    }

    public int getDeep() {
        return this.deep;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("deep", this.deep).attr("seriesIntervalPercent", this.seriesIntervalPercent).end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("deep");
                if (string2 != null) {
                    this.deep = Integer.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("seriesIntervalPercent")) != null) {
                    this.seriesIntervalPercent = Double.valueOf(string2);
                }
            } else if (string.equals("Projection")) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Area3DPlotGlyph)) {
            return false;
        }
        Area3DPlotGlyph area3DPlotGlyph = (Area3DPlotGlyph)object;
        if (!super.equals(area3DPlotGlyph)) {
            return false;
        }
        if (area3DPlotGlyph.deep != this.deep) {
            return false;
        }
        if (area3DPlotGlyph.seriesIntervalPercent != this.seriesIntervalPercent) {
            return false;
        }
        return Equals.equals(area3DPlotGlyph.projection, this.projection);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("projection", this.projection.toJSONObject());
        jSONObject.put("seriesIntervalPercent", this.seriesIntervalPercent);
        jSONObject.put("deep", this.deep);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

