/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.Axis;
import com.fr.chart.axis.CategoryAxis;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public abstract class AxisGlyph
extends SoloGlyph {
    private static final long serialVersionUID = -1928073768268210599L;
    private TextGlyph titleGlyph = null;
    protected transient Point2D originPoint;
    protected transient double unitLength;
    protected transient double tickLength;
    protected transient double smallTickLength;
    protected transient double axisLength;
    protected transient double axisGridLength;
    protected transient Rectangle2D bounds;
    protected transient double axisLabelWidth = 8.0;
    protected double minValue = 0.0;
    protected double maxValue = 0.0;

    public AxisGlyph() {
    }

    public AxisGlyph(Axis axis) {
        this.setAxis(axis);
        if (axis.getTitle() != null) {
            this.setTitleGlyph(axis.getTitle().createGlyph());
        }
    }

    public void dealPlotBoundsWithAxisLabel(Rectangle2D rectangle2D) {
        Dimension2D dimension2D;
        double d = this.getMaxLabelWidth();
        if (d > 0.0) {
            this.setAxisLabelWidth(d += (double)(4 + this.getAxis().getTickLength() / 2));
        }
        if (this.titleGlyph != null) {
            TextAttr textAttr = this.titleGlyph.getTextAttr();
            String string = this.titleGlyph.getText();
            dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        } else {
            dimension2D = new Dimension(0, 0);
        }
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        int n = this.getAxis().getAxisLabelPosition();
        switch (this.getAxis().getPosition()) {
            case 2: {
                if (n == 2) {
                    rectangle2D.setRect(d2, d3, rectangle2D.getWidth() - d - dimension2D.getWidth() - 4.0, rectangle2D.getHeight());
                    break;
                }
                rectangle2D.setRect(d2 + d + dimension2D.getWidth() + 4.0, d3, rectangle2D.getWidth() - d - dimension2D.getWidth() - 4.0, rectangle2D.getHeight());
                break;
            }
            case 3: {
                if (n == 2) {
                    rectangle2D.setRect(d2, d3 + d + dimension2D.getHeight() + 4.0, rectangle2D.getWidth(), rectangle2D.getHeight() - d - dimension2D.getHeight() - 4.0);
                    break;
                }
                rectangle2D.setRect(d2, d3, rectangle2D.getWidth(), rectangle2D.getHeight() - d - dimension2D.getHeight() - 4.0);
                break;
            }
            case 4: {
                if (n == 1) {
                    rectangle2D.setRect(d2 + d + dimension2D.getWidth() + 4.0, d3, rectangle2D.getWidth() - d - dimension2D.getWidth() - 4.0, rectangle2D.getHeight());
                    break;
                }
                rectangle2D.setRect(d2, d3, rectangle2D.getWidth() - d - dimension2D.getWidth() - 4.0, rectangle2D.getHeight());
                break;
            }
            default: {
                if (n == 1) {
                    rectangle2D.setRect(d2, d3, rectangle2D.getWidth(), rectangle2D.getHeight() - d - dimension2D.getHeight() - 4.0);
                    break;
                }
                rectangle2D.setRect(d2, d3 + d + dimension2D.getHeight() + 4.0, rectangle2D.getWidth(), rectangle2D.getHeight() - d - dimension2D.getHeight() - 4.0);
            }
        }
    }

    public void calculateAxisGlyph(Rectangle2D rectangle2D) {
        this.init(rectangle2D);
        this.calculateAxisLengthUnit();
    }

    public void init(Rectangle2D rectangle2D) {
        double d;
        double d2;
        Point2D.Double double_ = null;
        Rectangle2D.Double double_2 = null;
        int n = this.getAxis().getAxisLabelPosition();
        switch (this.getAxis().getPosition()) {
            case 2: {
                d2 = rectangle2D.getHeight();
                d = rectangle2D.getWidth();
                if (n == 2) {
                    double_2 = new Rectangle2D.Double(rectangle2D.getWidth(), 0.0, this.axisLabelWidth, rectangle2D.getHeight());
                    double_ = new Point2D.Double(-rectangle2D.getWidth(), rectangle2D.getHeight());
                    break;
                }
                double_2 = new Rectangle2D.Double(-this.axisLabelWidth, 0.0, this.axisLabelWidth, rectangle2D.getHeight());
                double_ = new Point2D.Double(this.axisLabelWidth, rectangle2D.getHeight());
                break;
            }
            case 3: {
                d2 = rectangle2D.getWidth();
                d = rectangle2D.getHeight();
                if (n == 2) {
                    double_2 = new Rectangle2D.Double(0.0, -this.axisLabelWidth, rectangle2D.getWidth(), this.axisLabelWidth);
                    double_ = new Point2D.Double(0.0, rectangle2D.getHeight() + this.axisLabelWidth);
                    break;
                }
                double_2 = new Rectangle2D.Double(0.0, rectangle2D.getHeight(), rectangle2D.getWidth(), this.axisLabelWidth);
                double_ = new Point2D.Double(0.0, 0.0);
                break;
            }
            case 4: {
                d2 = rectangle2D.getHeight();
                d = rectangle2D.getWidth();
                if (n == 1) {
                    double_2 = new Rectangle2D.Double(-this.axisLabelWidth, 0.0, this.axisLabelWidth, rectangle2D.getHeight());
                    double_ = new Point2D.Double(this.axisLabelWidth + rectangle2D.getWidth(), rectangle2D.getHeight());
                    break;
                }
                double_2 = new Rectangle2D.Double(rectangle2D.getWidth(), 0.0, this.axisLabelWidth, rectangle2D.getHeight());
                double_ = new Point2D.Double(0.0, rectangle2D.getHeight());
                break;
            }
            default: {
                d2 = rectangle2D.getWidth();
                d = rectangle2D.getHeight();
                if (n == 1) {
                    double_2 = new Rectangle2D.Double(0.0, rectangle2D.getHeight(), rectangle2D.getWidth(), this.axisLabelWidth);
                    double_ = new Point2D.Double(0.0, -rectangle2D.getHeight());
                    break;
                }
                double_2 = new Rectangle2D.Double(0.0, -this.axisLabelWidth, rectangle2D.getWidth(), this.axisLabelWidth);
                double_ = new Point2D.Double(0.0, this.axisLabelWidth);
            }
        }
        this.setBounds(double_2);
        this.setOrigin(double_);
        this.setAxisLength(d2);
        this.setAxisGridLength(d);
    }

    public abstract void calculateAxisLengthUnit();

    public double getMaxLabelWidth() {
        double d = 8.0;
        if (this instanceof CategoryAxisGlyph) {
            CategoryAxisGlyph categoryAxisGlyph = (CategoryAxisGlyph)this;
            ArrayList arrayList = categoryAxisGlyph.getCategoryLabelList();
            Object[] objectArray = arrayList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                double d2 = this.getAxisLabelWidth(categoryAxisGlyph, objectArray[i].toString());
                d = d2 < d ? d : d2;
            }
        } else if (this instanceof ValueAxisGlyph) {
            ValueAxisGlyph valueAxisGlyph = (ValueAxisGlyph)this;
            double d3 = valueAxisGlyph.getMinValue();
            double d4 = valueAxisGlyph.getMaxValue();
            ValueAxis valueAxis = (ValueAxis)valueAxisGlyph.getAxis();
            double d5 = 1.0;
            d5 = valueAxis.isCustomIncrement() ? valueAxis.getIncrement() : Axis.calculateIncrement(d3, d4);
            BigDecimal bigDecimal = new BigDecimal(d3);
            for (double d6 = d3; d6 < d4; d6 += d5) {
                double d7 = this.getAxisLabelWidth(valueAxisGlyph, valueAxisGlyph.value2String((bigDecimal = bigDecimal.add(new BigDecimal(d5))).doubleValue()));
                d = d7 < d ? d : d7;
            }
        } else if (this instanceof DateAxisGlyph) {
            DateAxisGlyph dateAxisGlyph = (DateAxisGlyph)this;
            CategoryAxis categoryAxis = (CategoryAxis)dateAxisGlyph.getAxis();
            Date date = ChartUtils.int2Date((int)dateAxisGlyph.getMinValue());
            while (ChartUtils.date2Int(date) <= dateAxisGlyph.getMaxValue() && (int)this.tickLength > 0) {
                Format format;
                String string = "test";
                if (categoryAxis.getFormat() != null) {
                    format = categoryAxis.getFormat();
                    string = format.format(date);
                } else {
                    format = new SimpleDateFormat("yyyy-MM-dd");
                    string = format.format(date);
                }
                double d8 = this.getAxisLabelWidth(dateAxisGlyph, string);
                d = d8 < d ? d : d8;
                DateAxisGlyph.nextDate(date, categoryAxis.getMainType(), (int)this.tickLength);
            }
        }
        if (this.getAxis().isStagger()) {
            d *= 1.5;
        }
        return d;
    }

    public double getAxisLabelWidth(AxisGlyph axisGlyph, String string) {
        if (string == null) {
            return 0.0;
        }
        TextAttr textAttr = axisGlyph.getAxis().getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        if (axisGlyph.getAxis().getPosition() == 1 || axisGlyph.getAxis().getPosition() == 3) {
            return dimension2D.getHeight();
        }
        return dimension2D.getWidth();
    }

    public abstract void setAxis(Axis var1);

    public abstract Axis getAxis();

    public abstract void axisExtends(int var1, int var2);

    public Point2D getOrigin() {
        return this.originPoint;
    }

    public void setOrigin(Point2D point2D) {
        this.originPoint = point2D;
    }

    public abstract double getCrossValue();

    public double getAxisLength() {
        return this.axisLength;
    }

    public void setAxisLength(double d) {
        this.axisLength = d;
    }

    public double getUnitLen() {
        return this.unitLength;
    }

    public double getUnit() {
        return this.tickLength;
    }

    public double getSmallunit() {
        return this.smallTickLength;
    }

    public double getAxisGridLength() {
        return this.axisGridLength;
    }

    public void setAxisGridLength(double d) {
        this.axisGridLength = d;
    }

    public void setTitleGlyph(TextGlyph textGlyph) {
        this.titleGlyph = textGlyph;
    }

    public TextGlyph getTitleGlyph() {
        return this.titleGlyph;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public Point2D getPoint2D(double d) {
        d -= this.getCrossValue();
        if (this.getAxis().getPosition() == 2) {
            return new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() - this.unitLength * d);
        }
        if (this.getAxis().getPosition() == 4) {
            return new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() - this.unitLength * d);
        }
        if (this.getAxis().getPosition() == 1) {
            return new Point2D.Double(this.originPoint.getX() + this.unitLength * d, this.originPoint.getY());
        }
        return new Point2D.Double(this.originPoint.getX() + this.unitLength * d, this.originPoint.getY());
    }

    protected Point2D getPoint2DForSelf(double d) {
        return this.getPoint2D(d);
    }

    protected Point2D getPoint2DCateAxis(double d, double d2) {
        return this.getPoint2D(d + d2);
    }

    protected Line2D getTickLine(double d, int n, int n2) {
        Point2D point2D = this.getPoint2DForSelf(d);
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - (double)n / 2.0, point2D.getY());
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() + (double)n / 2.0, point2D.getY());
        Point2D.Double double_3 = new Point2D.Double(point2D.getX(), point2D.getY() - (double)n / 2.0);
        Point2D.Double double_4 = new Point2D.Double(point2D.getX(), point2D.getY() + (double)n / 2.0);
        if (n2 == 3) {
            if (this.getAxis().getPosition() == 2) {
                return new Line2D.Double(double_, double_2);
            }
            if (this.getAxis().getPosition() == 4) {
                return new Line2D.Double(double_, double_2);
            }
            if (this.getAxis().getPosition() == 1) {
                return new Line2D.Double(double_3, double_4);
            }
            return new Line2D.Double(double_3, double_4);
        }
        if (n2 == 1) {
            if (this.getAxis().getPosition() == 2) {
                return new Line2D.Double(point2D, double_2);
            }
            if (this.getAxis().getPosition() == 1) {
                return new Line2D.Double(point2D, double_4);
            }
            if (this.getAxis().getPosition() == 4) {
                return new Line2D.Double(point2D, double_);
            }
            return new Line2D.Double(point2D, double_3);
        }
        if (n2 == 2) {
            if (this.getAxis().getPosition() == 2) {
                return new Line2D.Double(point2D, double_);
            }
            if (this.getAxis().getPosition() == 1) {
                return new Line2D.Double(point2D, double_3);
            }
            if (this.getAxis().getPosition() == 4) {
                return new Line2D.Double(point2D, double_2);
            }
            return new Line2D.Double(point2D, double_4);
        }
        return new Line2D.Double(point2D, point2D);
    }

    protected void drawLabel(Graphics graphics, double d, double d2, String string) {
        Point2D point2D = this.getPoint2DForSelf(d + d2);
        TextAttr textAttr = this.getAxis().getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        Rectangle2D.Double double_ = null;
        int n = this.getAxis().getPosition();
        int n2 = this.getAxis().getAxisLabelPosition();
        if (n2 == 0) {
            return;
        }
        double d3 = 4 + this.getAxis().getTickLength() / 2;
        if (n == 2) {
            if (n2 == 1 || n2 == 3) {
                double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() - d3, point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            } else if (n2 == 2) {
                double_ = new Rectangle2D.Double(point2D.getX() + this.getAxisGridLength(), point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            }
        } else if (n == 1) {
            if (n2 == 3 || n2 == 2) {
                double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() - dimension2D.getHeight() - d3, dimension2D.getWidth(), dimension2D.getHeight());
            } else if (n2 == 1) {
                double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() + this.getAxisGridLength(), dimension2D.getWidth(), dimension2D.getHeight());
            }
        } else if (n == 4) {
            if (n2 == 3 || n2 == 2) {
                double_ = new Rectangle2D.Double(point2D.getX() + d3, point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            } else if (n2 == 1) {
                double_ = new Rectangle2D.Double(point2D.getX() - this.getAxisGridLength() - dimension2D.getWidth(), point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            }
        } else if (n2 == 3 || n2 == 1) {
            double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() + d3, dimension2D.getWidth(), dimension2D.getHeight());
        } else if (n2 == 2) {
            double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() - this.getAxisGridLength() - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
        }
        TextGlyph.drawLabel(graphics, string, textAttr, double_);
    }

    protected void drawBGLabel(Graphics graphics, double d, double d2, String string, int n) {
        boolean bl;
        Point2D point2D = this.getPoint2DForSelf(d + d2);
        TextAttr textAttr = this.getAxis().getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        Rectangle2D.Double double_ = null;
        int n2 = this.getAxis().getPosition();
        int n3 = this.getAxis().getAxisLabelPosition();
        if (n3 == 0) {
            return;
        }
        boolean bl2 = bl = n % 2 == 0;
        if (!bl) {
            this.drawLabel(graphics, d, d2, string);
            return;
        }
        if (n2 == 2) {
            if (n3 == 1 || n3 == 3) {
                double_ = new Rectangle2D.Double(point2D.getX() - this.getAxisLabelWidth(), point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            } else if (n3 == 2) {
                double_ = new Rectangle2D.Double(point2D.getX() + this.getAxisGridLength() + this.getAxisLabelWidth() - dimension2D.getWidth(), point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            }
        } else if (n2 == 1) {
            if (n3 == 3 || n3 == 2) {
                double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
            } else if (n3 == 1) {
                double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() + this.getAxisGridLength() + this.getAxisLabelWidth() - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
            }
        } else if (n2 == 4) {
            if (n3 == 3 || n3 == 2) {
                double_ = new Rectangle2D.Double(point2D.getX() + this.getAxisLabelWidth() - dimension2D.getWidth(), point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            } else if (n3 == 1) {
                double_ = new Rectangle2D.Double(point2D.getX() - this.getAxisLabelWidth() - this.getAxisGridLength(), point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            }
        } else if (n3 == 3 || n3 == 1) {
            double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() + this.getAxisLabelWidth() - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
        } else if (n3 == 2) {
            double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() - this.getAxisGridLength() - this.getAxisLabelWidth(), dimension2D.getWidth(), dimension2D.getHeight());
        }
        TextGlyph.drawLabel(graphics, string, textAttr, double_);
    }

    protected void drawTickLine(Graphics graphics, Line2D line2D, BasicStroke basicStroke) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(line2D);
        graphics2D.setStroke(stroke);
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGrid(graphics);
        this.drawAxisLine(graphics);
        this.drawAxisTitle(graphics);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    protected abstract void drawAxisGrid(Graphics var1);

    protected abstract void drawAxisLine(Graphics var1);

    protected void drawAxisTitle(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        TextGlyph textGlyph = this.getTitleGlyph();
        if (textGlyph != null) {
            Rectangle2D rectangle2D = this.calculatorTitleBounds(textGlyph);
            textGlyph.setBounds(rectangle2D);
            textGlyph.draw(graphics2D);
        }
    }

    public abstract void drawTicks(Graphics var1);

    public void drawArrow(Graphics graphics, Point2D point2D, Point2D point2D2) {
        if (this.getAxis().isArrowShow()) {
            Point2D.Double double_ = new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            Point2D.Double double_2 = new Point2D.Double();
            double d = point2D.distance(point2D2);
            double d2 = 9.0;
            double d3 = 15.0;
            double d4 = 7.0;
            double d5 = 3.0;
            ((Point2D)double_2).setLocation(d2 * ((Point2D)double_).getX() / d, d2 * ((Point2D)double_).getY() / d);
            Point2D.Double double_3 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            ((Point2D)double_2).setLocation(d3 * ((Point2D)double_).getX() / d, d3 * ((Point2D)double_).getY() / d);
            Point2D.Double double_4 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            ((Point2D)double_2).setLocation(d4 * ((Point2D)double_).getX() / d, d4 * ((Point2D)double_).getY() / d);
            Point2D.Double double_5 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            Point2D.Double double_6 = new Point2D.Double(((Point2D)double_5).getX() + ((Point2D)double_).getY() / d * d5, ((Point2D)double_5).getY() - ((Point2D)double_).getX() / d * d5);
            Point2D.Double double_7 = new Point2D.Double(((Point2D)double_5).getX() - ((Point2D)double_).getY() / d * d5, ((Point2D)double_5).getY() + ((Point2D)double_).getX() / d * d5);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
            generalPath.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
            generalPath.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
            generalPath.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
            generalPath.closePath();
            GraphHelper.draw(graphics, new Line2D.Double(point2D2, double_3), this.getAxis().getLineStyle());
            GraphHelper.draw(graphics, generalPath, this.getAxis().getLineStyle());
            GraphHelper.fill(graphics, generalPath);
        }
    }

    protected Line2D[] getGridLine(double d) {
        Point2D point2D = this.getPoint2DForSelf(d);
        Line2D.Double double_ = this.getAxis().getPosition() == 2 ? new Line2D.Double(point2D.getX(), point2D.getY(), point2D.getX() + this.getAxisGridLength(), point2D.getY()) : (this.getAxis().getPosition() == 4 ? new Line2D.Double(point2D.getX() - this.getAxisGridLength(), point2D.getY(), point2D.getX(), point2D.getY()) : (this.getAxis().getPosition() == 1 ? new Line2D.Double(point2D.getX(), point2D.getY() + this.getAxisGridLength(), point2D.getX(), point2D.getY()) : new Line2D.Double(point2D.getX(), point2D.getY() - this.getAxisGridLength(), point2D.getX(), point2D.getY())));
        return new Line2D[]{double_};
    }

    public Shape getShape() {
        return this.getBounds();
    }

    public void setAxisLabelWidth(double d) {
        this.axisLabelWidth = d;
    }

    public double getAxisLabelWidth() {
        return this.axisLabelWidth;
    }

    public Rectangle2D calculatorTitleBounds(TextGlyph textGlyph) {
        TextAttr textAttr = textGlyph.getTextAttr();
        String string = textGlyph.getText();
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        Rectangle2D.Double double_ = null;
        if (this.getAxis().getPosition() == 1) {
            double_ = this.getAxis().getAxisLabelPosition() == 1 ? new Rectangle2D.Double((this.axisLength - dimension2D.getWidth()) / 2.0, this.getAxisLabelWidth() + 4.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double((this.axisLength - dimension2D.getWidth()) / 2.0, -4.0 - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
        } else if (this.getAxis().getPosition() == 2) {
            double_ = this.getAxis().getAxisLabelPosition() == 2 ? new Rectangle2D.Double(this.getAxisLabelWidth() + 4.0, (this.axisLength - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(-dimension2D.getWidth() - 4.0, (this.axisLength - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        } else if (this.getAxis().getPosition() == 3) {
            double_ = this.getAxis().getAxisLabelPosition() == 2 ? new Rectangle2D.Double((this.axisLength - dimension2D.getWidth()) / 2.0, -dimension2D.getHeight() - 4.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double((this.axisLength - dimension2D.getWidth()) / 2.0, this.getAxisLabelWidth() + 4.0, dimension2D.getWidth(), dimension2D.getHeight());
        } else if (this.getAxis().getPosition() == 4) {
            double_ = this.getAxis().getAxisLabelPosition() == 1 ? new Rectangle2D.Double(-dimension2D.getWidth() - 4.0, (this.axisLength - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(this.getAxisLabelWidth() + 4.0, (this.axisLength - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        }
        return double_;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AxisGlyph)) {
            return false;
        }
        AxisGlyph axisGlyph = (AxisGlyph)object;
        if (!Equals.equals(axisGlyph.titleGlyph, this.titleGlyph)) {
            return false;
        }
        if (axisGlyph.getMaxValue() != this.getMaxValue()) {
            return false;
        }
        return axisGlyph.getMinValue() == this.getMinValue();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("TextGlyph".equals(string)) {
                this.titleGlyph = (TextGlyph)xMLableReader.readXMLObject(new TextGlyph());
            } else if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("minValue");
                if (string2 != null) {
                    this.setMinValue(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("maxValue")) != null) {
                    this.setMaxValue(Double.valueOf(string2));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.titleGlyph != null) {
            this.titleGlyph.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("Attr").attr("minValue", this.getMinValue()).attr("maxValue", this.getMaxValue()).end();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.titleGlyph != null) {
            jSONObject.put("titleGlyph", this.titleGlyph.toJSONObject());
        }
        jSONObject.put("axisGridLength", this.axisGridLength);
        jSONObject.put("axisLabelWidth", this.axisLabelWidth);
        jSONObject.put("axisLength", this.axisLength);
        jSONObject.put("smallTickLength", this.smallTickLength);
        jSONObject.put("tickLength", this.tickLength);
        jSONObject.put("unitLength", this.unitLength);
        jSONObject.put("bounds", this.bounds);
        jSONObject.put("originPoint", this.originPoint);
        jSONObject.put("minValue", this.minValue);
        jSONObject.put("maxValue", this.maxValue);
        return jSONObject;
    }
}

