/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.background.GradientBackground;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.DataLabelInfo;
import com.fr.chart.axis.SeriesAttrBackground;
import com.fr.chart.axis.SeriesAttrPosition;
import com.fr.chart.core.ChartCoreConstants;
import com.fr.chart.core.Shadow;
import com.fr.chart.core.glyph.BarPlotGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class Bar2DPlotGlyph
extends BarPlotGlyph {
    private static final long serialVersionUID = -5822126857464796926L;
    public static final String XML_TAG = "Bar2DPlotGlyph";
    private boolean isSimulation3D = false;

    public void setSimulation3D(boolean bl) {
        this.isSimulation3D = bl;
    }

    public boolean isSimulation3D() {
        return this.isSimulation3D;
    }

    public void layoutDataSeriesGlyph() {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n2 = 0;
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                if (dataSeries.getDataPoint(j).isValueIsNull()) continue;
                ++n2;
            }
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            n2 = 0;
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (dataPoint.isValueIsNull()) continue;
                ShapeGlyph shapeGlyph = new ShapeGlyph();
                dataPoint.setDrawImpl(shapeGlyph);
                Rectangle2D rectangle2D = this.getBarShape(i, j);
                shapeGlyph.setShape(rectangle2D);
                shapeGlyph.getInfo().dealCondition(this.getSeriesCollection(), i);
                Rectangle2D rectangle2D2 = rectangle2D;
                double d = this.getDataPointPercentValue(i, j);
                if (d > 0.0) {
                    dArray[n2] = rectangle2D2.getCenterX();
                    dArray2[n2] = rectangle2D2.getY();
                } else {
                    dArray[n2] = rectangle2D2.getCenterX();
                    dArray2[n2] = rectangle2D2.getY() + rectangle2D2.getHeight();
                }
                ++n2;
                if (!this.isHorizontal && !this.isStacked) {
                    shapeGlyph.getInfo().setShadow(new Shadow(rectangle2D));
                }
                if (this.isSimulation3D() && this.getSeriesCollection().getSeriesAttr(i).isContains(new SeriesAttrBackground()) == null) {
                    Color color = ChartCoreConstants.CHART_COLOR_ARRAY[i % ChartCoreConstants.CHART_COLOR_ARRAY.length];
                    shapeGlyph.getInfo().setBackground(new GradientBackground(color.brighter(), color, GradientBackground.TOP2BOTTOM));
                }
                this.dealDataPointLabelBounds(dataPoint, i);
            }
            if (this.isStacked() || this.isHorizontal) continue;
            this.trendLineFitting(dArray, dArray2, i);
        }
    }

    protected void dealDataPointLabelBounds(DataPoint dataPoint, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph instanceof TextGlyph) {
            TextGlyph textGlyph2 = textGlyph;
            SeriesAttrPosition seriesAttrPosition = (SeriesAttrPosition)this.getSeriesCollection().getSeriesCondition(new SeriesAttrPosition(), n);
            Rectangle2D rectangle2D = DataLabelInfo.preferredLabelBounds(textGlyph2, dataPoint, seriesAttrPosition.getPosition());
            textGlyph2.setBounds(rectangle2D);
            if (this.getIsHorizontal()) {
                this.resetDataLabelBounds(textGlyph2, seriesAttrPosition.getPosition(), dataPoint.getShape().getBounds2D());
            }
        }
    }

    private void resetDataLabelBounds(TextGlyph textGlyph, int n, Rectangle2D rectangle2D) {
        Dimension2D dimension2D = textGlyph.preferredDimension();
        if (n == 7) {
            textGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight()));
        } else if (n == 5) {
            textGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() - dimension2D.getWidth(), rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight()));
        } else if (n == 6) {
            textGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight()));
        }
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        super.draw(graphics);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Bar2DPlotGlyph)) {
            return false;
        }
        Bar2DPlotGlyph bar2DPlotGlyph = (Bar2DPlotGlyph)object;
        return super.equals(bar2DPlotGlyph);
    }

    public Object clone() throws CloneNotSupportedException {
        Bar2DPlotGlyph bar2DPlotGlyph = (Bar2DPlotGlyph)super.clone();
        return bar2DPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("isSimulation3D", this.isSimulation3D);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

