/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.background.GradientBackground;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.SeriesAttrBackground;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartCoreConstants;
import com.fr.chart.core.glyph.BarPlotGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.math.Plot3D;
import com.fr.chart.math.Projection;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.shape3d.Cubic;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class Bar3DPlotGlyph
extends BarPlotGlyph
implements Plot3D {
    private static final long serialVersionUID = -8494817723580336519L;
    public static final String XML_TAG = "Bar3DPlotGlyph";
    private boolean isCubic3D = true;
    private boolean isCascade = true;
    private double seriesIntervalPercent = 0.0;
    private int deep = -1;
    private boolean horizontalDrawBar = false;
    private Projection projection = new Projection();

    public void layoutAxisGlyph() {
        super.layoutAxisGlyph();
        this.layout3DAxisGlyph();
    }

    public void layoutDataSeriesGlyph() {
        if (this.deep == -1) {
            this.deep = (int)this.getBounds().getWidth();
        }
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                Object object;
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (dataPoint.isValueIsNull()) continue;
                Cubic cubic = new Cubic();
                cubic.setProjection(this.getProjection());
                cubic.getInfo().dealCondition(this.getSeriesCollection(), i);
                dataPoint.setDrawImpl(cubic);
                if (this.getSeriesCollection().getSeriesAttr(i).isContains(new SeriesAttrBackground()) == null) {
                    object = ChartCoreConstants.CHART_COLOR_ARRAY[i % ChartCoreConstants.CHART_COLOR_ARRAY.length];
                    cubic.getInfo().setBackground(new GradientBackground(((Color)object).brighter(), (Color)object, GradientBackground.LEFT2RIGHT));
                }
                object = this.getBarShape(i, j);
                double d = 0.0;
                double d2 = 0.0;
                if (this.isCascade() && !this.isStacked()) {
                    d = (double)this.deep / ((1.0 + this.getSeriesIntervalPercent()) * (double)this.getSeriesSize());
                    d2 = -this.getSeriesIntervalPercent() * d * (0.5 + (double)i) - d * (double)i;
                } else {
                    d = (double)this.deep / (1.0 + this.getSeriesIntervalPercent());
                    d2 = -this.getSeriesIntervalPercent() * d * 0.5;
                }
                if (this.horizontalDrawBar) {
                    d2 = 0.0;
                    d = 100.0;
                }
                cubic.setCubic(((RectangularShape)object).getX(), ((RectangularShape)object).getY(), d2, ((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight(), d);
                this.dealDataPointLabelBounds(dataPoint, i);
            }
        }
    }

    protected void dealDataPointLabelBounds(DataPoint dataPoint, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        Dimension2D dimension2D = textGlyph.preferredDimension();
        Rectangle2D rectangle2D = dataPoint.getShape().getBounds2D();
        if (this.isHorizontal) {
            textGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight()));
        } else {
            textGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY() - dimension2D.getHeight(), dimension2D.getWidth() + 4.0, dimension2D.getHeight()));
        }
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.valueAxisGlyph != null) {
            this.valueAxisGlyph.draw(graphics);
        }
        if (this.categoryAxisGlyph != null) {
            this.categoryAxisGlyph.draw(graphics);
        }
        if (this.isCascade && !this.isStacked) {
            int n;
            if (this.horizontalDrawBar) {
                for (n = 0; n < this.getSeries(0).getDataPointCount(); ++n) {
                    for (int i = 0; i < this.getSeriesSize(); ++i) {
                        this.getSeries(i).getDataPoint(n).draw(graphics2D);
                    }
                }
            } else {
                for (n = this.getSeriesSize() - 1; n >= 0; --n) {
                    this.getSeries(n).draw(graphics);
                }
            }
            for (n = this.getSeriesSize() - 1; n >= 0; --n) {
                this.getSeries(n).drawLabel(graphics);
            }
        } else {
            int n;
            for (n = 0; n < this.getSeries(0).getDataPointCount(); ++n) {
                int n2;
                DataPoint[] dataPointArray = new DataPoint[this.getSeriesSize()];
                for (n2 = 0; n2 < this.getSeriesSize(); ++n2) {
                    dataPointArray[n2] = this.getSeries(n2).getDataPoint(n);
                }
                for (n2 = 0; n2 < this.getSeriesSize(); ++n2) {
                    for (int i = this.getSeriesSize() - 1; i > n2; --i) {
                        if (dataPointArray[i].isValueIsNull() || !(dataPointArray[i].getValue() < 0.0)) continue;
                        DataPoint dataPoint = dataPointArray[i];
                        dataPointArray[i] = dataPointArray[i - 1];
                        dataPointArray[i - 1] = dataPoint;
                    }
                }
                for (n2 = 0; n2 < this.getSeriesSize(); ++n2) {
                    dataPointArray[n2].draw(graphics);
                }
            }
            int n3 = this.getSeriesSize();
            for (n = 0; n < n3; ++n) {
                this.getSeries(n).drawLabel(graphics);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public void setCubic3D(boolean bl) {
        this.isCubic3D = bl;
    }

    public boolean isCubic3D() {
        return this.isCubic3D;
    }

    public void setCascade(boolean bl) {
        this.isCascade = bl;
    }

    public boolean isCascade() {
        return this.isCascade;
    }

    public void setSeriesIntervalPercent(double d) {
        this.seriesIntervalPercent = d;
    }

    public double getSeriesIntervalPercent() {
        return this.seriesIntervalPercent;
    }

    public void setDeep(int n) {
        this.deep = n;
    }

    public int getDeep() {
        return this.deep;
    }

    public void setHorizontalDrawBar(boolean bl) {
        this.horizontalDrawBar = bl;
    }

    public boolean isHorizontalDrawBar() {
        return this.horizontalDrawBar;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("deep", this.deep).attr("isCas", this.isCascade).attr("isCubic", this.isCubic3D).attr("seriesPercent", this.seriesIntervalPercent).attr("horizontalDrawBar", this.horizontalDrawBar).end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("deep");
                if (string2 != null) {
                    this.deep = Integer.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isCas")) != null) {
                    this.isCascade = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isCubic")) != null) {
                    this.isCubic3D = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("seriesPercent")) != null) {
                    this.seriesIntervalPercent = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("horizontalDrawBar")) != null) {
                    this.horizontalDrawBar = Boolean.valueOf(string2);
                }
            } else if (string.equals("Projection")) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Bar3DPlotGlyph)) {
            return false;
        }
        Bar3DPlotGlyph bar3DPlotGlyph = (Bar3DPlotGlyph)object;
        if (!super.equals(bar3DPlotGlyph)) {
            return false;
        }
        if (bar3DPlotGlyph.deep != this.deep) {
            return false;
        }
        if (bar3DPlotGlyph.isCascade != this.isCascade) {
            return false;
        }
        if (bar3DPlotGlyph.horizontalDrawBar != this.horizontalDrawBar) {
            return false;
        }
        if (bar3DPlotGlyph.isCubic3D != this.isCubic3D) {
            return false;
        }
        if (bar3DPlotGlyph.seriesIntervalPercent != this.seriesIntervalPercent) {
            return false;
        }
        return Equals.equals(bar3DPlotGlyph.projection, this.projection);
    }

    public Object clone() throws CloneNotSupportedException {
        Bar3DPlotGlyph bar3DPlotGlyph = (Bar3DPlotGlyph)super.clone();
        if (this.projection != null) {
            bar3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return bar3DPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("deep", this.deep);
        jSONObject.put("isCascade", this.isCascade);
        jSONObject.put("isCubic3D", this.isCubic3D);
        jSONObject.put("seriesIntervalPercent", this.seriesIntervalPercent);
        jSONObject.put("horizontalDrawBar", this.horizontalDrawBar);
        if (this.projection != null) {
            jSONObject.put("projection", this.projection.toJSONObject());
        }
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

