/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.CategoryPlotGlyph;
import com.fr.chart.core.glyph.CustomPlotGlyph;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import java.awt.geom.Rectangle2D;

public abstract class BarPlotGlyph
extends CategoryPlotGlyph {
    private static final long serialVersionUID = 6835951801934449612L;
    public static final String XML_TAG = "BarPlotGlyph";
    protected boolean isHorizontal = false;
    protected double seriesOverlapPercent = 0.0;
    protected double categoryIntervalPercent = 2.0;

    protected Rectangle2D getBarShape(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = this.getBarPercent(this.getSeriesSize());
        double d6 = d5 * (1.0 - this.getSeriesOverlapPercent()) * (double)n + this.getCateIndex(this.getCategoryAxisGlyph(), n2) + 0.5 * this.getCategoryIntervalPercent() * d5;
        double d7 = this.getDataPointPercentValue(n, n2);
        if (this.getIsHorizontal()) {
            d4 = this.getCategoryAxisGlyph().getPoint2D(d6 + d5).getY();
            d3 = this.getCategoryAxisGlyph().getUnitLen() * d5;
            if (this.isStacked()) {
                double d8 = 0.0;
                double d9 = 0.0;
                for (int i = n - 1; i >= 0; --i) {
                    double d10 = this.getDataPointPercentValue(i, n2);
                    if (d10 > 0.0) {
                        d8 += d10;
                        continue;
                    }
                    d9 += d10;
                }
                if (d7 > 0.0) {
                    d2 = this.getValueAxisGlyph().getPoint2D(d8).getX();
                    d = Math.abs(this.getValueAxisGlyph().getPoint2D(d8).getX() - this.getValueAxisGlyph().getPoint2D(d8 + d7).getX());
                } else {
                    d2 = this.getValueAxisGlyph().getPoint2D(d9 + d7).getX();
                    d = Math.abs(this.getValueAxisGlyph().getPoint2D(d9 + d7).getX() - this.getValueAxisGlyph().getPoint2D(d9).getX());
                }
            } else {
                d2 = d7 > 0.0 ? this.getValueAxisGlyph().getPoint2D(0.0).getX() : this.getValueAxisGlyph().getPoint2D(d7).getX();
                d = Math.abs(this.getValueAxisGlyph().getPoint2D(d7).getX() - this.getValueAxisGlyph().getPoint2D(0.0).getX());
            }
        } else {
            d2 = this.getCategoryAxisGlyph().getPoint2D(d6).getX();
            d = this.getCategoryAxisGlyph().getUnitLen() * d5;
            if (this.isStacked()) {
                double d11 = 0.0;
                double d12 = 0.0;
                for (int i = n - 1; i >= 0; --i) {
                    double d13 = this.getDataPointPercentValue(i, n2);
                    if (d13 > 0.0) {
                        d11 += d13;
                        continue;
                    }
                    d12 += d13;
                }
                if (d7 > 0.0) {
                    d4 = this.getValueAxisGlyph().getPoint2D(d11 + d7).getY();
                    d3 = this.getValueAxisGlyph().getPoint2D(d11).getY() - this.getValueAxisGlyph().getPoint2D(d11 + d7).getY();
                } else {
                    d4 = this.getValueAxisGlyph().getPoint2D(d12).getY();
                    d3 = this.getValueAxisGlyph().getPoint2D(d12 + d7).getY() - this.getValueAxisGlyph().getPoint2D(d12).getY();
                }
            } else {
                d4 = d7 > 0.0 ? this.getValueAxisGlyph().getPoint2D(d7).getY() : this.getValueAxisGlyph().getPoint2D(0.0).getY();
                d3 = Math.abs(this.getValueAxisGlyph().getPoint2D(d7).getY() - this.getValueAxisGlyph().getPoint2D(0.0).getY());
            }
        }
        return new Rectangle2D.Double(d2, d4, d, d3);
    }

    protected double getBarPercent(int n) {
        return 1.0 / ((double)n - (double)(n - 1) * this.getSeriesOverlapPercent() + this.getCategoryIntervalPercent());
    }

    private double getCustomBarPercent(int n, CustomPlotGlyph customPlotGlyph) {
        return 1.0 / ((double)n - (double)(n - 1) * customPlotGlyph.getSeriesOverlapPercent() + customPlotGlyph.getCategoryIntervalPercent());
    }

    private double getCateIndex(CategoryAxisGlyph categoryAxisGlyph, int n) {
        if (categoryAxisGlyph instanceof DateAxisGlyph) {
            return ChartUtils.date2Int(DateUtils.object2Date(categoryAxisGlyph.getCategoryLabelList().get(n), true));
        }
        return n;
    }

    protected Rectangle2D getBarShape4CustomPlot(int n, int n2, CategoryAxisGlyph categoryAxisGlyph, ValueAxisGlyph valueAxisGlyph, CustomPlotGlyph customPlotGlyph, int n3, int n4) {
        double d;
        double d2;
        double d3 = this.getCustomBarPercent(n3, customPlotGlyph);
        double d4 = d3 * (1.0 - customPlotGlyph.getSeriesOverlapPercent()) * (double)n4 + this.getCateIndex(categoryAxisGlyph, n2) + 0.5 * customPlotGlyph.getCategoryIntervalPercent() * d3;
        double d5 = customPlotGlyph.getDataPointPercentValue(n, n2);
        double d6 = categoryAxisGlyph.getPoint2D(d4).getX();
        double d7 = categoryAxisGlyph.getUnitLen() * d3;
        if (this.isStacked()) {
            double d8 = 0.0;
            for (int i = n4 - 1; i >= 0; --i) {
                d8 += customPlotGlyph.getDataPointPercentValue(i, n2);
            }
            d2 = valueAxisGlyph.getBounds().getY() + valueAxisGlyph.getPoint2D(d8 + d5).getY();
            d = valueAxisGlyph.getPoint2D(d8).getY() - valueAxisGlyph.getPoint2D(d8 + d5).getY();
        } else {
            d2 = d5 > 0.0 ? valueAxisGlyph.getPoint2D(d5).getY() : valueAxisGlyph.getPoint2D(0.0).getY();
            d = Math.abs(valueAxisGlyph.getPoint2D(d5).getY() - valueAxisGlyph.getPoint2D(0.0).getY());
        }
        return new Rectangle2D.Double(d6, d2, d7, d);
    }

    public void setIsHorizontal(boolean bl) {
        this.isHorizontal = bl;
    }

    public boolean getIsHorizontal() {
        return this.isHorizontal;
    }

    public void setSeriesOverlapPercent(double d) {
        this.seriesOverlapPercent = d;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public void setCategoryIntervalPercent(double d) {
        this.categoryIntervalPercent = d;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("horizontal", this.isHorizontal).attr("seriesOberlapPercent", this.seriesOverlapPercent).attr("categoryIntervalPercent", this.categoryIntervalPercent).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            String string2 = xMLableReader.getAttr("horizontal");
            if (string2 != null) {
                this.isHorizontal = Boolean.valueOf(string2);
            }
            if ((string2 = xMLableReader.getAttr("seriesOberlapPercent")) != null) {
                this.seriesOverlapPercent = Double.valueOf(string2);
            }
            if ((string2 = xMLableReader.getAttr("categoryIntervalPercent")) != null) {
                this.categoryIntervalPercent = Double.valueOf(string2);
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof BarPlotGlyph)) {
            return false;
        }
        BarPlotGlyph barPlotGlyph = (BarPlotGlyph)object;
        if (!super.equals(barPlotGlyph)) {
            return false;
        }
        if (barPlotGlyph.isHorizontal != this.isHorizontal) {
            return false;
        }
        if (barPlotGlyph.seriesOverlapPercent != this.seriesOverlapPercent) {
            return false;
        }
        return barPlotGlyph.categoryIntervalPercent == this.categoryIntervalPercent;
    }

    public Object clone() throws CloneNotSupportedException {
        BarPlotGlyph barPlotGlyph = (BarPlotGlyph)super.clone();
        return barPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("seriesOverlapPercent", this.seriesOverlapPercent);
        jSONObject.put("isHorizontal", this.isHorizontal);
        jSONObject.put("categoryIntervalPercent", this.categoryIntervalPercent);
        return jSONObject;
    }
}

