/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.Axis;
import com.fr.chart.axis.CategoryAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.AxisGlyph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.text.Format;
import java.util.ArrayList;

public class CategoryAxisGlyph
extends AxisGlyph {
    private static final long serialVersionUID = -6116809732597680006L;
    public static final String XML_TAG = "CategoryAxisGlyph";
    protected ArrayList categoryLabelList = new ArrayList();
    protected CategoryAxis categoryAxis;
    private boolean isGantt = false;
    protected int forward = 0;
    protected int backward = 0;

    public CategoryAxisGlyph() {
    }

    public CategoryAxisGlyph(CategoryAxis categoryAxis) {
        super(categoryAxis);
    }

    public void calculateAxisLengthUnit() {
        this.unitLength = (double)this.getCategoryFullCount() - this.getCrossValue() == 0.0 ? 0.0 : this.axisLength / ((double)this.getCategoryFullCount() - this.getCrossValue());
        this.tickLength = 1.0;
        this.smallTickLength = this.tickLength / 5.0;
    }

    public int getCategoryCount() {
        return this.categoryLabelList.size();
    }

    public int getCategoryFullCount() {
        return this.categoryLabelList.size() + this.forward;
    }

    public Axis getAxis() {
        return this.categoryAxis;
    }

    public void setAxis(Axis axis) {
        if (!(axis instanceof CategoryAxis)) {
            throw new IllegalArgumentException();
        }
        this.categoryAxis = (CategoryAxis)axis;
    }

    public void setGantt(boolean bl) {
        this.isGantt = bl;
    }

    public boolean isGantt() {
        return this.isGantt;
    }

    public void setForward(int n) {
        this.forward = n;
    }

    public void setBackward(int n) {
        this.backward = n;
    }

    public void addCategoryLabel(Object object) {
        this.categoryLabelList.add(object);
    }

    public ArrayList getCategoryLabelList() {
        return this.categoryLabelList;
    }

    public void setCategoryLabelList(ArrayList arrayList) {
        this.categoryLabelList = arrayList;
    }

    protected void drawAxisGrid(Graphics graphics) {
        int n;
        Line2D[] line2DArray;
        double d;
        Paint paint;
        Stroke stroke;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getAxis().getSecondGridStyle() != 0 && this.smallTickLength > 0.0) {
            stroke = graphics2D.getStroke();
            paint = graphics2D.getPaint();
            graphics2D.setStroke(GraphHelper.getStroke(this.getAxis().getSecondGridStyle()));
            graphics2D.setPaint(this.getAxis().getSecondGridColor());
            for (d = this.smallTickLength + this.getCrossValue(); d <= (double)this.getCategoryFullCount(); d += this.smallTickLength) {
                line2DArray = this.getGridLine(d);
                for (n = 0; n < line2DArray.length; ++n) {
                    graphics2D.draw(line2DArray[n]);
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
        if (this.getAxis().getMainGridStyle() != 0 && this.tickLength > 0.0) {
            stroke = graphics2D.getStroke();
            paint = graphics2D.getPaint();
            graphics2D.setStroke(GraphHelper.getStroke(this.getAxis().getMainGridStyle()));
            graphics2D.setPaint(this.getAxis().getMainGridColor());
            for (d = this.tickLength + this.getCrossValue(); d <= (double)this.getCategoryFullCount(); d += this.tickLength) {
                line2DArray = this.getGridLine(d);
                for (n = 0; n < line2DArray.length; ++n) {
                    graphics2D.draw(line2DArray[n]);
                }
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }
    }

    protected void drawAxisLine(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = this.getAxis().getLineColor();
        int n = this.getAxis().getLineStyle();
        if (color != null && n != 0 && this.getAxis().isAxisShow()) {
            graphics2D.setPaint(color);
            Line2D.Double double_ = new Line2D.Double(this.getPoint2DForSelf(this.getCrossValue()), this.getPoint2DForSelf(this.getCategoryFullCount()));
            GraphHelper.draw(graphics2D, double_, n);
            this.drawArrow(graphics2D, this.getPoint2DForSelf(this.getCrossValue()), this.getPoint2DForSelf(this.getCategoryFullCount()));
        }
        this.drawTicks(graphics2D);
        graphics2D.setPaint(paint);
    }

    public void drawTicks(Graphics graphics) {
        int n;
        Object object;
        double d;
        double d2 = this.getCategoryFullCount();
        BasicStroke basicStroke = new BasicStroke(this.categoryAxis.getMainStroke(), 1, 0);
        BasicStroke basicStroke2 = new BasicStroke(this.categoryAxis.getSecStroke(), 1, 0);
        for (d = this.getCrossValue() + this.tickLength; d <= d2 && this.getAxis().isAxisShow(); d += this.tickLength) {
            object = this.getTickLine(d, this.categoryAxis.getTickLength(), this.categoryAxis.getTickMarkType());
            if (this.categoryAxis.getTickLength() == 0 || this.categoryAxis.getMainStroke() == 0.0f) continue;
            this.drawTickLine(graphics, (Line2D)object, basicStroke);
        }
        for (d = this.getCrossValue() + this.smallTickLength; d <= d2 && this.getAxis().isAxisShow(); d += this.smallTickLength) {
            if ((d - this.getCrossValue()) / this.smallTickLength == 5.0) continue;
            object = this.getTickLine(d, this.categoryAxis.getSecTickLength(), this.categoryAxis.getSecTickMarkType());
            if (this.categoryAxis.getSecTickLength() == 0 || this.categoryAxis.getSecStroke() == 0.0f) continue;
            this.drawTickLine(graphics, (Line2D)object, basicStroke2);
        }
        boolean bl = true;
        for (int i = 0; i < this.categoryLabelList.size(); ++i) {
            object = this.categoryLabelList.toArray();
            for (n = 0; n < object[i].toString().length(); ++n) {
                if (Character.isDigit(object[i].toString().charAt(n))) continue;
                bl = false;
                break;
            }
            if (!bl) break;
        }
        Format format = this.getAxis().getFormat();
        int n2 = 0;
        n = 0;
        n = this.getAxis().getLabelNumber() == -1 || this.getAxis().getLabelNumber() == 0 ? 1 : this.getAxis().getLabelNumber();
        for (int i = 0; i < this.categoryLabelList.size(); i += n) {
            if (format != null) {
                Object object2;
                Object[] objectArray = this.categoryLabelList.toArray();
                if (bl) {
                    object2 = format.format(Double.valueOf(objectArray[i].toString()));
                    if (this.getAxis().isStagger()) {
                        this.drawBGLabel(graphics, i, 0.5, (String)object2, n2);
                    } else {
                        this.drawLabel(graphics, i, (String)object2);
                    }
                } else {
                    String string;
                    object2 = DateUtils.object2Date(this.categoryLabelList.get(i), true);
                    String string2 = string = object2 == null ? this.categoryLabelList.get(i).toString() : format.format(object2);
                    if (this.getAxis().isStagger()) {
                        this.drawBGLabel(graphics, i, 0.5, string, n2);
                    } else {
                        this.drawLabel(graphics, i, string);
                    }
                }
            } else if (this.getAxis().isStagger()) {
                if (this.isGantt) {
                    this.drawBGLabel(graphics, i, 0.5, this.categoryLabelList.get(this.getCategoryCount() - i - 1).toString(), n2);
                } else {
                    this.drawBGLabel(graphics, i, 0.5, this.categoryLabelList.get(i).toString(), n2);
                }
            } else if (this.isGantt) {
                this.drawLabel(graphics, i, this.categoryLabelList.get(this.getCategoryCount() - i - 1).toString());
            } else {
                this.drawLabel(graphics, i, this.categoryLabelList.get(i).toString());
            }
            ++n2;
        }
    }

    public void axisExtends(int n, int n2) {
        this.setForward(n);
        this.setBackward(n2);
        this.calculateAxisLengthUnit();
    }

    public double getCrossValue() {
        return 0 - this.backward;
    }

    protected void drawLabel(Graphics graphics, double d, String string) {
        this.drawLabel(graphics, d, 0.5, string);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("LabelList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && "Label".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttr("value")) != null) {
                            CategoryAxisGlyph.this.categoryLabelList.add(string);
                        }
                    }
                });
            } else if (string2.equals("CategoryAxis") || string2.equals("DateAxis")) {
                String string3 = xMLableReader.getAttr("class");
                if (string3 != null && string3.endsWith(".CategoryAxis")) {
                    this.categoryAxis = (CategoryAxis)xMLableReader.readXMLObject(new CategoryAxis());
                }
            } else if (string2.equals("attr") && (string = xMLableReader.getAttr("isGantt")) != null) {
                this.setGantt(Boolean.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("attr").attr("isGantt", this.isGantt).end();
        if (this.categoryLabelList != null && this.categoryLabelList.size() > 0) {
            xMLPrintWriter.startTAG("LabelList");
            for (int i = 0; i < this.categoryLabelList.size(); ++i) {
                xMLPrintWriter.startTAG("Label").attr("value", this.categoryLabelList.get(i).toString()).end();
            }
            xMLPrintWriter.end();
        }
        if (this.categoryAxis != null) {
            this.categoryAxis.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CategoryAxisGlyph)) {
            return false;
        }
        CategoryAxisGlyph categoryAxisGlyph = (CategoryAxisGlyph)object;
        if (!super.equals(categoryAxisGlyph)) {
            return false;
        }
        if (!ComparatorUtils.equals(categoryAxisGlyph.categoryLabelList, this.categoryLabelList)) {
            return false;
        }
        if (!Equals.equals(categoryAxisGlyph.getAxis(), this.getAxis())) {
            return false;
        }
        return this.isGantt == categoryAxisGlyph.isGantt;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.categoryAxis != null) {
            jSONObject.put("categoryAxis", this.categoryAxis.toJSONObject());
        }
        if (this.categoryLabelList != null && this.categoryLabelList.size() > 0) {
            jSONObject.put("categoryLabelList", this.categoryLabelList.toArray());
        }
        jSONObject.put("isGantt", this.isGantt);
        jSONObject.put("forward", this.forward);
        jSONObject.put("backward", this.backward);
        return jSONObject;
    }

    public String getJSAxisType() {
        return XML_TAG;
    }
}

