/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.background.Background;
import com.fr.base.background.IntervalColorBackground;
import com.fr.base.core.IteratorChain;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.AxisGlyph;
import com.fr.chart.core.glyph.Bar3DPlotGlyph;
import com.fr.chart.core.glyph.CategoryAxis3DGlyph;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxis3DGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ValueAxis3DGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.math.Plot3D;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.shape3d.Cubic;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class CategoryPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 4363652839224475272L;
    public static final String XML_TAG = "CategoryPlotGlyph";
    protected ValueAxisGlyph valueAxisGlyph;
    protected CategoryAxisGlyph categoryAxisGlyph;
    protected boolean isStacked = false;

    public void layoutAxisGlyph() {
        Rectangle2D rectangle2D = this.getBounds();
        this.categoryAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.valueAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.categoryAxisGlyph.calculateAxisGlyph(rectangle2D);
        this.valueAxisGlyph.calculateAxisGlyph(rectangle2D);
        this.setBounds(rectangle2D);
        Background background = this.getInfo().getBackground();
        if (background instanceof IntervalColorBackground) {
            IntervalColorBackground intervalColorBackground = (IntervalColorBackground)background;
            intervalColorBackground.setIntervalLength(this.valueAxisGlyph.getUnit() * this.valueAxisGlyph.getUnitLen());
        }
    }

    public void layout3DAxisGlyph() {
        Plot3D plot3D = (Plot3D)((Object)this);
        double d = this.getBounds().getWidth();
        double d2 = this.getBounds().getHeight();
        Cubic cubic = new Cubic(0.0, 0.0, d, d2);
        int n = plot3D.getDeep();
        if (n == -1) {
            n = (int)d;
        }
        if (this instanceof Bar3DPlotGlyph && ((Bar3DPlotGlyph)this).isHorizontalDrawBar()) {
            n = 100;
        }
        cubic.setDeep(n);
        cubic.setProjection(plot3D.getProjection());
        cubic.setInfo(this.getInfo());
        cubic.setCovers(new byte[]{5, 2, 1});
        if (this.categoryAxisGlyph instanceof CategoryAxis3DGlyph) {
            ((CategoryAxis3DGlyph)this.categoryAxisGlyph).setCubic(cubic);
        } else {
            ((DateAxis3DGlyph)this.categoryAxisGlyph).setCubic(cubic);
        }
        ((ValueAxis3DGlyph)this.valueAxisGlyph).setCubic(cubic);
    }

    public Iterator selectableChildren() {
        ArrayList<AxisGlyph> arrayList = new ArrayList<AxisGlyph>();
        if (this.valueAxisGlyph != null) {
            arrayList.add(this.valueAxisGlyph);
        }
        if (this.categoryAxisGlyph != null) {
            arrayList.add(this.categoryAxisGlyph);
        }
        return new IteratorChain(new Iterator[]{super.selectableChildren(), arrayList.iterator()});
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.valueAxisGlyph != null) {
            this.valueAxisGlyph.draw(graphics);
        }
        if (this.categoryAxisGlyph != null) {
            this.categoryAxisGlyph.draw(graphics);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D);
    }

    public double getDataPointPercentValue(int n, int n2) {
        ValueAxis valueAxis = (ValueAxis)this.valueAxisGlyph.getAxis();
        double d = this.getSeries(n).getDataPoint(n2).getValue();
        if (!valueAxis.isPercentage()) {
            return d;
        }
        double d2 = 0.0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            d2 += Math.abs(dataSeries.getDataPoint(n2).getValue());
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public void setValueAxisGlyph(ValueAxisGlyph valueAxisGlyph) {
        this.valueAxisGlyph = valueAxisGlyph;
    }

    public ValueAxisGlyph getValueAxisGlyph() {
        return this.valueAxisGlyph;
    }

    public void setCategoryAxisGlyph(CategoryAxisGlyph categoryAxisGlyph) {
        this.categoryAxisGlyph = categoryAxisGlyph;
    }

    public CategoryAxisGlyph getCategoryAxisGlyph() {
        return this.categoryAxisGlyph;
    }

    public void setStacked(boolean bl) {
        this.isStacked = bl;
    }

    public boolean isStacked() {
        return this.isStacked;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CategoryPlotGlyph)) {
            return false;
        }
        CategoryPlotGlyph categoryPlotGlyph = (CategoryPlotGlyph)object;
        if (!super.equals(categoryPlotGlyph)) {
            return false;
        }
        if (categoryPlotGlyph.isStacked != this.isStacked) {
            return false;
        }
        if (!Equals.equals(categoryPlotGlyph.categoryAxisGlyph, this.categoryAxisGlyph)) {
            return false;
        }
        return Equals.equals(categoryPlotGlyph.valueAxisGlyph, this.valueAxisGlyph);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("stacked", this.isStacked).end();
        if (this.valueAxisGlyph != null) {
            this.valueAxisGlyph.writeXML(xMLPrintWriter);
        }
        if (this.categoryAxisGlyph != null) {
            this.categoryAxisGlyph.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("stacked");
                if (string2 != null) {
                    this.isStacked = Boolean.valueOf(string2);
                }
            } else if (string.equals("ValueAxisGlyph")) {
                this.valueAxisGlyph = (ValueAxisGlyph)xMLableReader.readXMLObject(new ValueAxisGlyph());
            } else if (string.equals("CategoryAxisGlyph")) {
                this.categoryAxisGlyph = (CategoryAxisGlyph)xMLableReader.readXMLObject(new CategoryAxisGlyph());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CategoryPlotGlyph categoryPlotGlyph = (CategoryPlotGlyph)super.clone();
        if (this.valueAxisGlyph != null) {
            categoryPlotGlyph.valueAxisGlyph = (ValueAxisGlyph)this.valueAxisGlyph.clone();
        }
        if (this.categoryAxisGlyph != null) {
            categoryPlotGlyph.categoryAxisGlyph = (CategoryAxisGlyph)this.categoryAxisGlyph.clone();
        }
        return categoryPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("isStacked", this.isStacked);
        if (this.categoryAxisGlyph != null) {
            jSONObject.put("categoryGlyphType", this.categoryAxisGlyph.getJSAxisType());
            jSONObject.put("categoryAxisGlyph", this.categoryAxisGlyph.toJSONObject());
        }
        if (this.valueAxisGlyph != null) {
            jSONObject.put("valueGlyphType", this.valueAxisGlyph.getJSAxisType());
            jSONObject.put("valueAxisGlyph", this.valueAxisGlyph.toJSONObject());
        }
        return jSONObject;
    }
}

