/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ChartGlyphLayout;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.RectangleGlyph;
import com.fr.chart.core.glyph.LegendGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;

public class ChartGlyph
extends RectangleGlyph {
    private static final long serialVersionUID = -4023596592305921803L;
    public static final String XML_TAG = "ChartGlyph";
    private PlotGlyph plotGlyph;
    private LegendGlyph legendGlyph;
    private TextGlyph titleGlyph;
    private boolean isJSDraw = false;

    public void setPlotGlyph(PlotGlyph plotGlyph) {
        this.plotGlyph = plotGlyph;
    }

    public PlotGlyph getPlotGlyph() {
        return this.plotGlyph;
    }

    public void setLegendGlyph(LegendGlyph legendGlyph) {
        this.legendGlyph = legendGlyph;
    }

    public LegendGlyph getLegendGlyph() {
        return this.legendGlyph;
    }

    public void setTitleGlyph(TextGlyph textGlyph) {
        this.titleGlyph = textGlyph;
    }

    public TextGlyph getTitleGlyph() {
        return this.titleGlyph;
    }

    public void setJSDraw(boolean bl) {
        this.isJSDraw = bl;
    }

    public boolean isJSDraw() {
        return this.isJSDraw;
    }

    public Iterator selectableChildren() {
        ArrayList<RectangleGlyph> arrayList = new ArrayList<RectangleGlyph>();
        if (this.plotGlyph != null) {
            arrayList.add(this.plotGlyph);
        }
        if (this.legendGlyph != null) {
            arrayList.add(this.legendGlyph);
        }
        if (this.titleGlyph != null) {
            arrayList.add(this.titleGlyph);
        }
        return arrayList.iterator();
    }

    public Image toImage(int n, int n2) {
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.isRoundBorder()) {
            this.setBounds(new RoundRectangle2D.Double(0.0, 0.0, n, n2, 10.0, 10.0));
        } else {
            this.setBounds(new Rectangle2D.Double(0.0, 0.0, n, n2));
        }
        this.draw(graphics2D);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        super.draw(graphics);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.doLayout();
        if (this.plotGlyph != null) {
            this.plotGlyph.draw(graphics2D);
        }
        if (this.legendGlyph != null) {
            this.legendGlyph.draw(graphics2D);
        }
        if (this.titleGlyph != null) {
            this.titleGlyph.draw(graphics2D);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setPaint(paint);
    }

    public void doLayout() {
        ChartGlyphLayout chartGlyphLayout = new ChartGlyphLayout();
        chartGlyphLayout.setLayoutBounds(this.getBounds());
        chartGlyphLayout.doLayout(this);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("LegendGlyph".equals(string2)) {
                this.legendGlyph = (LegendGlyph)xMLableReader.readXMLObject(new LegendGlyph());
            }
            if ("PlotGlyph".equals(string2)) {
                this.plotGlyph = (PlotGlyph)ReportXMLUtils.readXMLable(xMLableReader);
            }
            if ("TextGlyph".equals(string2)) {
                this.titleGlyph = (TextGlyph)xMLableReader.readXMLObject(new TextGlyph());
            }
            if ("ChartGlyphAttr".equals(string2) && (string = xMLableReader.getAttr("isJSDraw")) != null) {
                this.setJSDraw(Boolean.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ChartGlyphAttr").attr("isJSDraw", this.isJSDraw).end();
        if (this.plotGlyph != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.plotGlyph, "PlotGlyph");
        }
        if (this.legendGlyph != null) {
            this.legendGlyph.writeXML(xMLPrintWriter);
        }
        if (this.titleGlyph != null) {
            this.titleGlyph.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChartGlyph)) {
            return false;
        }
        ChartGlyph chartGlyph = (ChartGlyph)object;
        if (!super.equals(chartGlyph)) {
            return false;
        }
        if (!Equals.equals(chartGlyph.getPlotGlyph(), this.getPlotGlyph())) {
            return false;
        }
        if (!Equals.equals(chartGlyph.getTitleGlyph(), this.getTitleGlyph())) {
            return false;
        }
        if (!Equals.equals(chartGlyph.getLegendGlyph(), this.getLegendGlyph())) {
            return false;
        }
        return chartGlyph.isJSDraw == this.isJSDraw;
    }

    public Object clone() throws CloneNotSupportedException {
        ChartGlyph chartGlyph = (ChartGlyph)super.clone();
        if (this.legendGlyph != null) {
            chartGlyph.legendGlyph = (LegendGlyph)this.legendGlyph.clone();
        }
        if (this.titleGlyph != null) {
            chartGlyph.titleGlyph = (TextGlyph)this.titleGlyph.clone();
        }
        if (this.plotGlyph != null) {
            chartGlyph.plotGlyph = (PlotGlyph)this.plotGlyph.clone();
        }
        return chartGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.plotGlyph != null) {
            jSONObject.put("plotType", this.plotGlyph.getPlotGlyphType());
            jSONObject.put("plotGlyph", this.plotGlyph.toJSONObject());
        }
        if (this.legendGlyph != null) {
            jSONObject.put("legendGlyph", this.legendGlyph.toJSONObject());
        }
        if (this.titleGlyph != null) {
            jSONObject.put("titleGlyph", this.titleGlyph.toJSONObject());
        }
        return jSONObject;
    }
}

