/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.FoldLine;
import com.fr.chart.core.Glyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeGlyph
implements Glyph {
    private static final long serialVersionUID = -8132349394753019294L;
    public static final String XML_TAG = "CompositeGlyph";
    private List children = new ArrayList();

    public void draw(Graphics graphics) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).draw(graphics);
        }
    }

    public Shape getShape() {
        Area area = new Area();
        for (int i = 0; i < this.size(); ++i) {
            area.add(new Area(this.get(i).getShape()));
        }
        return area;
    }

    public Iterator selectableChildren() {
        return this.getChildren().iterator();
    }

    public Glyph get(int n) {
        return (Glyph)this.getChildren().get(n);
    }

    public void add(Glyph glyph) {
        this.getChildren().add(glyph);
    }

    public Glyph remove(int n) {
        return (Glyph)this.getChildren().remove(n);
    }

    public boolean remove(Glyph glyph) {
        return this.getChildren().remove(glyph);
    }

    public void setChildren(List list) {
        this.children = list;
    }

    public List getChildren() {
        return this.children;
    }

    public int size() {
        return this.getChildren().size();
    }

    public Object clone() throws CloneNotSupportedException {
        CompositeGlyph compositeGlyph = (CompositeGlyph)super.clone();
        return compositeGlyph;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("FoldLine")) {
                this.add((FoldLine)xMLableReader.readXMLObject(new FoldLine()));
            } else if (string.equals("ShapeGlyph")) {
                this.add((ShapeGlyph)xMLableReader.readXMLObject(new ShapeGlyph()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.children != null && this.getChildren().size() > 0) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((Glyph)this.children.get(i)).writeXML(xMLPrintWriter);
            }
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompositeGlyph)) {
            return false;
        }
        CompositeGlyph compositeGlyph = (CompositeGlyph)object;
        if (compositeGlyph.getChildren() != null) {
            if (this.getChildren() != null) {
                if (compositeGlyph.getChildren().size() != this.getChildren().size()) {
                    return false;
                }
                for (int i = 0; i < compositeGlyph.getChildren().size(); ++i) {
                    Glyph glyph = compositeGlyph.get(i);
                    if (glyph.equals(this.get(i))) continue;
                    return false;
                }
            }
        } else if (this.getChildren() != null) {
            return false;
        }
        return true;
    }

    public JSONObject toJSONObject() throws JSONException {
        return null;
    }
}

