/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.background.GradientBackground;
import com.fr.base.core.IteratorChain;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.SeriesAttrBackground;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartCoreConstants;
import com.fr.chart.core.FoldLine;
import com.fr.chart.core.GeneralGlyph;
import com.fr.chart.core.Glyph;
import com.fr.chart.core.glyph.Bar2DPlotGlyph;
import com.fr.chart.core.glyph.CategoryPlotGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.plot.CustomAttr;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.plot.MarkerGlyph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class CustomPlotGlyph
extends CategoryPlotGlyph {
    private static final long serialVersionUID = -717908304255012814L;
    public static final String XML_TAG = "CustomPlotGlyph";
    private boolean hasSecondValueAxis = false;
    private ValueAxisGlyph secondValueAxisGlyph;
    private boolean isSimulation3D = true;
    private double seriesOverlapPercent = -0.15;
    private double categoryIntervalPercent = 1.0;
    private boolean isShowLine = true;
    private boolean isShowMarker = true;
    private boolean isLineNullValueBreak = true;
    private boolean isAreaNullValueBreak = true;

    public void layoutAxisGlyph() {
        Rectangle2D rectangle2D = this.getBounds();
        if (this.hasSecondValueAxis && this.secondValueAxisGlyph != null) {
            this.secondValueAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        }
        this.categoryAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.valueAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.categoryAxisGlyph.calculateAxisGlyph(rectangle2D);
        this.valueAxisGlyph.calculateAxisGlyph(rectangle2D);
        if (this.hasSecondValueAxis && this.secondValueAxisGlyph != null) {
            this.secondValueAxisGlyph.calculateAxisGlyph(rectangle2D);
        }
        this.setBounds(rectangle2D);
    }

    public void layoutDataSeriesGlyph() {
        int n;
        if (!VT4FR.ADVANCED_CHART.support()) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.getSeriesSize(); ++n) {
            CustomAttr customAttr = (CustomAttr)this.getSeriesCollection().getSeriesAttr(n);
            int n3 = customAttr.getRenderer();
            if (n3 != 1) continue;
            ++n2;
        }
        n = 0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            Glyph glyph;
            ValueAxisGlyph valueAxisGlyph;
            DataSeries dataSeries = this.getSeries(i);
            int n4 = 0;
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                if (dataSeries.getDataPoint(j).isValueIsNull()) continue;
                ++n4;
            }
            double[] dArray = new double[n4];
            double[] dArray2 = new double[n4];
            n4 = 0;
            CustomAttr customAttr = (CustomAttr)this.getSeriesCollection().getSeriesAttr(i);
            int n5 = customAttr.getRenderer();
            String string = customAttr.getAxisPosition();
            ValueAxisGlyph valueAxisGlyph2 = valueAxisGlyph = string.equals("RIGHT") ? this.getSecondValueAxisGlyph() : this.getValueAxisGlyph();
            if (n5 == 1) {
                for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                    glyph = dataSeries.getDataPoint(j);
                    if (((DataPoint)glyph).isValueIsNull()) continue;
                    Bar2DPlotGlyph bar2DPlotGlyph = new Bar2DPlotGlyph();
                    ShapeGlyph shapeGlyph = new ShapeGlyph(bar2DPlotGlyph.getBarShape4CustomPlot(i, j, this.getCategoryAxisGlyph(), valueAxisGlyph, this, n2, n));
                    ((DataPoint)glyph).setDrawImpl(shapeGlyph);
                    shapeGlyph.getInfo().dealCondition(this.getSeriesCollection(), i);
                    if (this.isSimulation3D() && this.getSeriesCollection().getSeriesAttr(i).isContains(new SeriesAttrBackground()) == null) {
                        Color color = ChartCoreConstants.CHART_COLOR_ARRAY[i % ChartCoreConstants.CHART_COLOR_ARRAY.length];
                        shapeGlyph.getInfo().setBackground(new GradientBackground(color.brighter(), color, GradientBackground.TOP2BOTTOM));
                    }
                    double d = this.getDataPointPercentValue(i, j);
                    Rectangle2D rectangle2D = (Rectangle2D)shapeGlyph.getShape();
                    if (d > 0.0) {
                        dArray[n4] = rectangle2D.getCenterX();
                        dArray2[n4] = rectangle2D.getY();
                    } else {
                        dArray[n4] = rectangle2D.getCenterX();
                        dArray2[n4] = rectangle2D.getY() + rectangle2D.getHeight();
                    }
                    ++n4;
                    this.dealDataPointLabelBounds((DataPoint)glyph, i);
                }
                ++n;
            }
            if (n5 == 4) {
                int n6;
                GeneralPath generalPath = new GeneralPath(1);
                glyph = new ShapeGlyph(generalPath);
                dataSeries.setDrawImpl(glyph);
                ((GeneralGlyph)glyph).getInfo().dealCondition(this.getSeriesCollection(), i);
                float f = (float)this.getCategoryAxisGlyph().getPoint2DCateAxis(0.0, 0.0).getX();
                float f2 = (float)valueAxisGlyph.getPoint2D(valueAxisGlyph.getCrossValue()).getY();
                float f3 = (float)valueAxisGlyph.getPoint2D(0.0).getY();
                float f4 = (float)this.getCategoryAxisGlyph().getUnitLen();
                generalPath.moveTo(f + f4 / 2.0f, f3);
                for (n6 = 0; n6 < dataSeries.getDataPointCount(); ++n6) {
                    DataPoint dataPoint = dataSeries.getDataPoint(n6);
                    if (dataPoint.isValueIsNull()) {
                        if (!this.isAreaNullValueBreak()) continue;
                        if (n6 > 0) {
                            generalPath.lineTo((float)(this.getCategoryAxisGlyph().getPoint2DCateAxis(n6 - 1, 0.0).getX() + (double)(f4 / 2.0f)), f3);
                        }
                        generalPath.lineTo((float)(this.getCategoryAxisGlyph().getPoint2DCateAxis(n6, 0.0).getX() + (double)(f4 / 2.0f)), f3);
                        if (n6 >= dataSeries.getDataPointCount()) continue;
                        generalPath.lineTo((float)(this.getCategoryAxisGlyph().getPoint2DCateAxis(n6 + 1, 0.0).getX() + (double)(f4 / 2.0f)), f3);
                        continue;
                    }
                    double d = this.getDataPointPercentValue(i, n6);
                    f = (float)(this.getCategoryAxisGlyph().getPoint2DCateAxis(n6, 0.0).getX() + (double)(f4 / 2.0f));
                    f2 = (float)valueAxisGlyph.getPoint2D(d).getY();
                    dArray[n4] = f;
                    dArray2[n4] = f2;
                    ++n4;
                    generalPath.lineTo(f, f2);
                    dataPoint.setShape(new Arc2D.Double(f - 3.0f, f2 - 3.0f, 6.0, 6.0, 0.0, 360.0, 2));
                    this.dealDataPointLabelBounds(dataPoint, i);
                }
                for (n6 = dataSeries.getDataPointCount() - 1; n6 >= 0; --n6) {
                    if (dataSeries.getDataPoint(n6).isValueIsNull()) continue;
                    generalPath.lineTo((float)(this.getCategoryAxisGlyph().getPoint2DCateAxis(n6, 0.0).getX() + (double)(f4 / 2.0f)), f3);
                }
            }
            if (n5 == 2) {
                GeneralPath generalPath = new GeneralPath(1);
                boolean bl = true;
                for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                    DataPoint dataPoint = dataSeries.getDataPoint(j);
                    if (dataPoint.isValueIsNull()) {
                        if (!this.isLineNullValueBreak()) continue;
                        bl = true;
                        continue;
                    }
                    double d = this.getDataPointPercentValue(i, j);
                    float f = (float)this.getCategoryAxisGlyph().getPoint2DCateAxis(j, 0.5).getX();
                    float f5 = (float)valueAxisGlyph.getBounds().getY() + (float)valueAxisGlyph.getPoint2D(d).getY();
                    if (bl) {
                        generalPath.moveTo(f, f5);
                        bl = false;
                    } else {
                        generalPath.lineTo(f, f5);
                    }
                    dArray[n4] = f;
                    dArray2[n4] = f5;
                    ++n4;
                    if (this.isShowMarker()) {
                        MarkerGlyph markerGlyph = new MarkerGlyph();
                        markerGlyph.dealCondition4Line(this.getSeriesCollection(), i);
                        markerGlyph.setShape(new Rectangle2D.Double(f - 5.0f, f5 - 5.0f, 10.0, 10.0));
                        dataPoint.setDrawImpl(markerGlyph);
                    } else {
                        dataPoint.setShape(new Rectangle2D.Double(f - 5.0f, f5 - 5.0f, 10.0, 10.0));
                    }
                    this.dealDataPointLabelBounds(dataPoint, i);
                }
                if (this.isShowLine()) {
                    FoldLine foldLine = new FoldLine(generalPath);
                    dataSeries.setDrawImpl(foldLine);
                    foldLine.getLineStyleInfo().dealCondition(this.getSeriesCollection(), i);
                }
            }
            this.trendLineFitting(dArray, dArray2, i);
        }
    }

    public Iterator selectableChildren() {
        ArrayList<ValueAxisGlyph> arrayList = new ArrayList<ValueAxisGlyph>();
        if (this.hasSecondValueAxis && this.secondValueAxisGlyph != null) {
            arrayList.add(this.secondValueAxisGlyph);
        }
        return new IteratorChain(new Iterator[]{super.selectableChildren(), arrayList.iterator()});
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.hasSecondValueAxis && this.secondValueAxisGlyph != null) {
            this.secondValueAxisGlyph.draw(graphics2D);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D);
    }

    public void setHasSecondValueAxis(boolean bl) {
        this.hasSecondValueAxis = bl;
    }

    public boolean getHasSecondValueAxis() {
        return this.hasSecondValueAxis;
    }

    public void setSecondValueAxisGlyph(ValueAxisGlyph valueAxisGlyph) {
        this.secondValueAxisGlyph = valueAxisGlyph;
    }

    public ValueAxisGlyph getSecondValueAxisGlyph() {
        return this.secondValueAxisGlyph;
    }

    public void setSimulation3D(boolean bl) {
        this.isSimulation3D = bl;
    }

    public boolean isSimulation3D() {
        return this.isSimulation3D;
    }

    public void setSeriesOverlapPercent(double d) {
        this.seriesOverlapPercent = d;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public void setCategoryIntervalPercent(double d) {
        this.categoryIntervalPercent = d;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }

    public void setShowLine(boolean bl) {
        this.isShowLine = bl;
    }

    public boolean isShowLine() {
        return this.isShowLine;
    }

    public void setShowMarker(boolean bl) {
        this.isShowMarker = bl;
    }

    public boolean isShowMarker() {
        return this.isShowMarker;
    }

    public void setLineNullValueBreak(boolean bl) {
        this.isLineNullValueBreak = bl;
    }

    public boolean isLineNullValueBreak() {
        return this.isLineNullValueBreak;
    }

    public void setAreaNullValueBreak(boolean bl) {
        this.isAreaNullValueBreak = bl;
    }

    public boolean isAreaNullValueBreak() {
        return this.isAreaNullValueBreak;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("ValueAxisGlyph")) {
                this.secondValueAxisGlyph = (ValueAxisGlyph)xMLableReader.readXMLObject(new ValueAxisGlyph());
            } else if ("Attr".equals(string)) {
                String string2 = xMLableReader.getAttr("value");
                if (string2 != null) {
                    this.hasSecondValueAxis = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isShowLine")) != null) {
                    this.isShowLine = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isShowMarker")) != null) {
                    this.isShowMarker = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isAreaNullValueBreak")) != null) {
                    this.isAreaNullValueBreak = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isLineNullValueBreak")) != null) {
                    this.isLineNullValueBreak = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("categoryIntervalPercent")) != null) {
                    this.categoryIntervalPercent = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("seriesOverlapPercent")) != null) {
                    this.seriesOverlapPercent = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isSimulation3D")) != null) {
                    this.isSimulation3D = Boolean.valueOf(string2);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("value", this.hasSecondValueAxis).attr("isShowLine", this.isShowLine).attr("isShowMarker", this.isShowMarker).attr("isLineNullValueBreak", this.isLineNullValueBreak).attr("isAreaNullValueBreak", this.isAreaNullValueBreak).attr("seriesOverlapPercent", this.seriesOverlapPercent).attr("categoryIntervalPercent", this.categoryIntervalPercent).attr("isSimulation3D", this.isSimulation3D).end();
        if (this.secondValueAxisGlyph != null) {
            this.secondValueAxisGlyph.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CustomPlotGlyph)) {
            return false;
        }
        CustomPlotGlyph customPlotGlyph = (CustomPlotGlyph)object;
        if (!super.equals(customPlotGlyph)) {
            return false;
        }
        if (customPlotGlyph.hasSecondValueAxis != this.hasSecondValueAxis || customPlotGlyph.isAreaNullValueBreak != this.isAreaNullValueBreak || customPlotGlyph.isLineNullValueBreak != this.isLineNullValueBreak || customPlotGlyph.isShowLine != this.isShowLine || customPlotGlyph.isShowMarker != this.isShowMarker || customPlotGlyph.seriesOverlapPercent != this.seriesOverlapPercent || customPlotGlyph.categoryIntervalPercent != this.categoryIntervalPercent || customPlotGlyph.isSimulation3D != this.isSimulation3D) {
            return false;
        }
        return Equals.equals(customPlotGlyph.secondValueAxisGlyph, this.secondValueAxisGlyph);
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPlotGlyph customPlotGlyph = (CustomPlotGlyph)super.clone();
        if (this.valueAxisGlyph != null) {
            customPlotGlyph.valueAxisGlyph = (ValueAxisGlyph)this.valueAxisGlyph.clone();
        }
        return customPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("hasSecondValueAxis", this.hasSecondValueAxis);
        if (this.secondValueAxisGlyph != null) {
            jSONObject.put("secondValueAxisGlyph", this.secondValueAxisGlyph.toJSONObject());
        }
        jSONObject.put("isSimulation3D", this.isSimulation3D);
        jSONObject.put("seriesOverlapPercent", this.seriesOverlapPercent);
        jSONObject.put("categoryIntervalPercent", this.categoryIntervalPercent);
        jSONObject.put("isShowLine", this.isShowLine);
        jSONObject.put("isShowMarker", this.isShowMarker);
        jSONObject.put("isLineNullValueBreak", this.isLineNullValueBreak);
        jSONObject.put("isAreaNullValueBreak", this.isAreaNullValueBreak);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

