/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.CategoryAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.math.Projection;
import com.fr.chart.shape3d.Cubic;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class DateAxis3DGlyph
extends DateAxisGlyph {
    private static final long serialVersionUID = 5544350222096632005L;
    public static final String XML_TAG = "DateAxis3DGlyph";
    private Cubic cubic;

    public DateAxis3DGlyph() {
    }

    public DateAxis3DGlyph(CategoryAxis categoryAxis) {
        super(categoryAxis);
    }

    public DateAxis3DGlyph(CategoryAxis categoryAxis, Cubic cubic) {
        super(categoryAxis);
        this.setCubic(cubic);
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D point2D = this.getProjection().projectee(this.getBounds().getX(), this.getBounds().getY(), 0.0);
        graphics2D.translate(point2D.getX(), point2D.getY());
        this.drawAxisGrid(graphics);
        this.drawAxisLine(graphics);
        this.drawAxisTitle(graphics);
        graphics2D.translate(-point2D.getX(), -point2D.getY());
        if (this.cubic != null) {
            this.cubic.draw(graphics2D);
        }
    }

    protected Point2D getPoint2DForSelf(double d) {
        Point2D point2D = this.getPoint2D(d);
        return this.getProjection().projectee(point2D.getX(), point2D.getY(), 0.0);
    }

    protected Line2D[] getGridLine(double d) {
        Point2D point2D;
        Point2D point2D2;
        Point2D point2D3 = this.getPoint2D(d);
        Point2D point2D4 = this.getProjection().projectee(point2D3.getX(), point2D3.getY(), 0.0);
        Point2D point2D5 = this.getProjection().projectee(point2D3.getX(), point2D3.getY(), -this.cubic.getDeep());
        Line2D.Double double_ = new Line2D.Double(point2D4, point2D5);
        if (this.getAxis().getPosition() == 2) {
            point2D2 = this.getProjection().projectee(point2D3.getX(), point2D3.getY(), -this.cubic.getDeep());
            point2D = this.getProjection().projectee(point2D3.getX() + this.getAxisGridLength(), point2D3.getY(), -this.cubic.getDeep());
        } else if (this.getAxis().getPosition() == 4) {
            point2D2 = this.getProjection().projectee(point2D3.getX() - this.getAxisGridLength(), point2D3.getY(), -this.cubic.getDeep());
            point2D = this.getProjection().projectee(point2D3.getX() - this.getAxisGridLength(), point2D3.getY(), -this.cubic.getDeep());
        } else if (this.getAxis().getPosition() == 1) {
            point2D2 = this.getProjection().projectee(point2D3.getX(), point2D3.getY() + this.getAxisGridLength(), -this.cubic.getDeep());
            point2D = this.getProjection().projectee(point2D3.getX(), point2D3.getY(), -this.cubic.getDeep());
        } else {
            point2D2 = this.getProjection().projectee(point2D3.getX(), point2D3.getY() - this.getAxisGridLength(), -this.cubic.getDeep());
            point2D = this.getProjection().projectee(point2D3.getX(), point2D3.getY(), -this.cubic.getDeep());
        }
        Line2D.Double double_2 = new Line2D.Double(point2D2, point2D);
        return new Line2D[]{double_, double_2};
    }

    public void setCubic(Cubic cubic) {
        this.cubic = cubic;
    }

    public Cubic getCubic() {
        return this.cubic;
    }

    public Projection getProjection() {
        return this.cubic.getProjection();
    }

    public void setProjection(Projection projection) {
        this.cubic.setProjection(projection);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.cubic != null) {
            this.cubic.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Cubic")) {
            this.cubic = (Cubic)xMLableReader.readXMLObject(new Cubic());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateAxis3DGlyph)) {
            return false;
        }
        DateAxis3DGlyph dateAxis3DGlyph = (DateAxis3DGlyph)object;
        if (!super.equals(dateAxis3DGlyph)) {
            return false;
        }
        return Equals.equals(dateAxis3DGlyph.getCubic(), this.getCubic());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.cubic != null) {
            jSONObject.put("cubic", this.cubic.toJSONObject());
        }
        return jSONObject;
    }

    public String getJSAxisType() {
        return XML_TAG;
    }
}

