/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.DateUtils;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.Axis;
import com.fr.chart.axis.CategoryAxis;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateAxisGlyph
extends CategoryAxisGlyph {
    private static final long serialVersionUID = -317755190103222589L;
    public static final String XML_TAG = "DateAxisGlyph";

    public DateAxisGlyph() {
    }

    public DateAxisGlyph(CategoryAxis categoryAxis) {
        super(categoryAxis);
    }

    protected Point2D getPoint2DCateAxis(double d, double d2) {
        return this.getPoint2D(ChartUtils.date2Int(DateUtils.object2Date(this.getCategoryLabelList().get((int)d), true)));
    }

    public void calculateAxisLengthUnit() {
        this.unitLength = this.axisLength / (this.getMaxValue() - this.getMinValue());
    }

    public void initMinMaxValue(double d, double d2) {
        if (this.categoryAxis.isCustomMinValue()) {
            this.setMinValue(this.categoryAxis.getMinValue());
            d = this.getMinValue();
        } else {
            this.setMinValue(d);
        }
        if (this.categoryAxis.isCustomMaxValue()) {
            this.setMaxValue(this.categoryAxis.getMaxValue());
            d2 = this.getMaxValue();
        }
        if (d2 - d > 0.0) {
            this.tickLength = this.categoryAxis.isCustomMainDate() ? (double)((CategoryAxis)this.getAxis()).getMainDate() : Axis.calculateIncrement(this.getMinValue(), d2);
            this.smallTickLength = this.categoryAxis.isCustomSecondDate() ? (double)((CategoryAxis)this.getAxis()).getSecondDate() : (double)((int)this.tickLength / 5);
        }
        if ((d2 - d) % this.tickLength != 0.0) {
            d2 = d2 + this.tickLength - (d2 - d) % this.tickLength;
        }
        if (!this.categoryAxis.isCustomMaxValue()) {
            this.setMaxValue(d2 + this.tickLength);
        }
        if (this.getMinValue() >= this.getMaxValue()) {
            this.setMaxValue(this.getMinValue() + 10.0);
        }
    }

    protected void drawAxisGrid(Graphics graphics) {
        if (this.getAxis().getSecondGridStyle() != 0 && (int)this.smallTickLength > 0) {
            this.drawGridLine(graphics, this.getAxis().getSecondGridStyle(), this.getAxis().getSecondGridColor(), (int)this.smallTickLength, this.categoryAxis.getSecondType());
        }
        if (this.getAxis().getMainGridStyle() != 0 && (int)this.tickLength > 0) {
            this.drawGridLine(graphics, this.getAxis().getMainGridStyle(), this.getAxis().getMainGridColor(), (int)this.tickLength, this.categoryAxis.getMainType());
        }
    }

    private void drawGridLine(Graphics graphics, int n, Color color, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(GraphHelper.getStroke(n));
        graphics2D.setPaint(color);
        Date date = ChartUtils.int2Date((int)this.getMinValue());
        while (ChartUtils.date2Int(date) <= this.getMaxValue() && n2 > 0) {
            double d = ChartUtils.date2Int(date);
            Line2D[] line2DArray = this.getGridLine(d);
            for (int i = 0; i < line2DArray.length; ++i) {
                graphics2D.draw(line2DArray[i]);
            }
            DateAxisGlyph.nextDate(date, n3, n2);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    protected void drawAxisLine(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = this.getAxis().getLineColor();
        int n = this.getAxis().getLineStyle();
        if (color != null && n != 0 && this.getAxis().isAxisShow()) {
            graphics2D.setPaint(color);
            if (this.getMinValue() == this.getMaxValue()) {
                return;
            }
            Line2D.Double double_ = new Line2D.Double(this.getPoint2DForSelf(this.getMinValue()), this.getPoint2DForSelf(this.getMaxValue()));
            GraphHelper.draw(graphics2D, double_, n);
            this.drawArrow(graphics2D, this.getPoint2DForSelf(this.getMinValue()), this.getPoint2DForSelf(this.getMaxValue()));
        }
        this.drawTicks(graphics);
        graphics2D.setPaint(paint);
    }

    public void drawTicks(Graphics graphics) {
        BasicStroke basicStroke = new BasicStroke(this.categoryAxis.getMainStroke(), 1, 0);
        BasicStroke basicStroke2 = new BasicStroke(this.categoryAxis.getSecStroke(), 1, 0);
        if (this.getAxis().isAxisShow() && this.getMaxValue() > this.getMinValue()) {
            Date date = ChartUtils.int2Date((int)this.getMinValue());
            while (ChartUtils.date2Int(date) <= this.getMaxValue() && (int)this.smallTickLength > 0) {
                double d = ChartUtils.date2Int(date);
                Line2D line2D = this.getTickLine(d, this.categoryAxis.getSecTickLength(), this.categoryAxis.getSecTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke2);
                DateAxisGlyph.nextDate(date, this.categoryAxis.getSecondType(), (int)this.smallTickLength);
            }
            Date date2 = ChartUtils.int2Date((int)this.getMinValue());
            int n = 0;
            while (ChartUtils.date2Int(date2) <= this.getMaxValue() && (int)this.tickLength > 0) {
                Format format;
                double d = ChartUtils.date2Int(date2);
                Line2D line2D = this.getTickLine(d, this.categoryAxis.getTickLength(), this.categoryAxis.getTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke);
                String string = "";
                if (this.categoryAxis.getFormat() != null) {
                    format = this.categoryAxis.getFormat();
                    string = format.format(date2);
                } else {
                    format = new SimpleDateFormat("MM-dd");
                    string = format.format(date2);
                }
                if (this.getAxis().isStagger()) {
                    this.drawBGLabel(graphics, d, 0.0, string, n);
                } else {
                    this.drawLabel(graphics, d, 0.0, string);
                }
                ++n;
                int n2 = 0;
                n2 = this.getAxis().getLabelNumber() == -1 || this.getAxis().getLabelNumber() == 0 ? 1 : this.getAxis().getLabelNumber();
                DateAxisGlyph.nextDate(date2, this.categoryAxis.getMainType(), (int)this.tickLength * n2);
            }
        }
    }

    public static void nextDate(Date date, int n, int n2) {
        if (n == 1) {
            date.setDate(date.getDate() + n2);
        } else if (n == 2) {
            date.setMonth(date.getMonth() + n2);
        } else if (n == 3) {
            date.setYear(date.getYear() + n2);
        }
    }

    public double getCrossValue() {
        return this.getMinValue();
    }

    public void setAxis(Axis axis) {
        if (axis instanceof CategoryAxis && ((CategoryAxis)axis).isDateAxis()) {
            this.categoryAxis = (CategoryAxis)axis;
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("DateAxisAttr")) {
                String string2 = xMLableReader.getAttr("minValue");
                if (string2 != null) {
                    this.setMinValue(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("maxValue")) != null) {
                    this.setMaxValue(Double.valueOf(string2));
                }
            } else if (string.equals("CategoryAxis")) {
                this.categoryAxis = (CategoryAxis)xMLableReader.readXMLObject(new CategoryAxis());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateAxisGlyph)) {
            return false;
        }
        DateAxisGlyph dateAxisGlyph = (DateAxisGlyph)object;
        return super.equals(dateAxisGlyph);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        return jSONObject;
    }

    public String getJSAxisType() {
        return XML_TAG;
    }

    public void axisExtends(int n, int n2) {
        this.setMaxValue(this.getMaxValue() + (double)n);
        this.setMinValue(this.getMinValue() - (double)n2);
        this.calculateAxisLengthUnit();
    }
}

