/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.background.ColorBackground;
import com.fr.base.core.IteratorChain;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.marker.TriangleFilledMarker;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.plot.MarkerGlyph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class GanttPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 7888272466260745014L;
    public static final String XML_TAG = "GanttPlotGlyph";
    private CategoryAxisGlyph categoryAxisGlyph;
    private CategoryAxisGlyph dateAxisGlyph;

    public String getPlotGlyphType() {
        return XML_TAG;
    }

    public void layoutAxisGlyph() {
        Rectangle2D rectangle2D = this.getBounds();
        this.categoryAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.dateAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.categoryAxisGlyph.calculateAxisGlyph(rectangle2D);
        this.dateAxisGlyph.calculateAxisGlyph(rectangle2D);
        this.setBounds(rectangle2D);
    }

    public void layoutDataSeriesGlyph() {
        double d = Math.min(this.categoryAxisGlyph.getUnitLen() / 3.0, 20.0);
        int n = this.getSeries(0).getDataPointCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getSeriesSize();
            if (n2 <= 1) continue;
            DataSeries dataSeries = this.getSeries(0);
            DataPoint dataPoint = dataSeries.getDataPoint(i);
            DataSeries dataSeries2 = this.getSeries(1);
            DataPoint dataPoint2 = dataSeries2.getDataPoint(i);
            double d2 = dataPoint.getValue();
            double d3 = dataPoint2.getValue();
            double d4 = this.dateAxisGlyph.getPoint2D(d2).getX();
            double d5 = this.dateAxisGlyph.getPoint2D(d3).getX();
            double d6 = this.categoryAxisGlyph.getPoint2DCateAxis(n - i - 1, 0.5).getY();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d6 - d / 2.0, d5 - d4, d);
            ShapeGlyph shapeGlyph = new ShapeGlyph(double_);
            shapeGlyph.setBackground(ColorBackground.getInstance(new Color(200, 199, 199)));
            dataPoint.setDrawImpl(shapeGlyph);
            if (n2 <= 3) continue;
            DataSeries dataSeries3 = this.getSeries(2);
            DataPoint dataPoint3 = dataSeries3.getDataPoint(i);
            DataSeries dataSeries4 = this.getSeries(3);
            DataPoint dataPoint4 = dataSeries4.getDataPoint(i);
            double d7 = dataPoint3.getValue();
            double d8 = dataPoint4.getValue();
            double d9 = this.dateAxisGlyph.getPoint2D(d7).getX();
            double d10 = this.dateAxisGlyph.getPoint2D(d8).getX();
            double d11 = d6;
            TriangleFilledMarker triangleFilledMarker = new TriangleFilledMarker();
            triangleFilledMarker.setSize(d / 4.0);
            MarkerGlyph markerGlyph = new MarkerGlyph(triangleFilledMarker, new Color(113, 70, 22));
            markerGlyph.setShape(new Rectangle2D.Double(d9 - d / 4.0, d11, d / 2.0, d / 2.0));
            dataPoint3.setDrawImpl(markerGlyph);
            TriangleFilledMarker triangleFilledMarker2 = new TriangleFilledMarker();
            triangleFilledMarker2.setSize(d / 4.0);
            MarkerGlyph markerGlyph2 = new MarkerGlyph(triangleFilledMarker2, new Color(122, 190, 108));
            markerGlyph2.setShape(new Rectangle2D.Double(d10 - d / 4.0, d11, d / 2.0, d / 2.0));
            dataPoint4.setDrawImpl(markerGlyph2);
            if (n2 <= 4) continue;
            DataSeries dataSeries5 = this.getSeries(4);
            DataPoint dataPoint5 = dataSeries5.getDataPoint(i);
            double d12 = dataPoint5.getValue();
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d4, d6 - d / 2.0, (d5 - d4) * d12, d);
            ShapeGlyph shapeGlyph2 = new ShapeGlyph(double_2);
            shapeGlyph2.setBackground(ColorBackground.getInstance(new Color(0, 107, 172)));
            dataPoint2.setDrawImpl(shapeGlyph2);
        }
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.categoryAxisGlyph != null) {
            this.categoryAxisGlyph.draw(graphics);
        }
        if (this.dateAxisGlyph != null) {
            this.dateAxisGlyph.draw(graphics2D);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D);
    }

    public Iterator selectableChildren() {
        ArrayList<CategoryAxisGlyph> arrayList = new ArrayList<CategoryAxisGlyph>();
        if (this.dateAxisGlyph != null) {
            arrayList.add(this.dateAxisGlyph);
        }
        if (this.categoryAxisGlyph != null) {
            arrayList.add(this.categoryAxisGlyph);
        }
        return new IteratorChain(new Iterator[]{arrayList.iterator(), super.selectableChildren()});
    }

    public void setCategoryAxisGlyph(CategoryAxisGlyph categoryAxisGlyph) {
        this.categoryAxisGlyph = categoryAxisGlyph;
    }

    public CategoryAxisGlyph getCategoryAxisGlyph() {
        return this.categoryAxisGlyph;
    }

    public void setDateAxisGlyph(CategoryAxisGlyph categoryAxisGlyph) {
        this.dateAxisGlyph = categoryAxisGlyph;
    }

    public CategoryAxisGlyph getDateAxisGlyph() {
        return this.dateAxisGlyph;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.dateAxisGlyph != null) {
            this.dateAxisGlyph.writeXML(xMLPrintWriter);
        }
        if (this.categoryAxisGlyph != null) {
            this.categoryAxisGlyph.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("DateAxisGlyph")) {
                this.dateAxisGlyph = (DateAxisGlyph)xMLableReader.readXMLObject(new DateAxisGlyph());
            }
            if (string.equals("CategoryAxisGlyph")) {
                this.categoryAxisGlyph = (CategoryAxisGlyph)xMLableReader.readXMLObject(new CategoryAxisGlyph());
            }
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.categoryAxisGlyph != null) {
            jSONObject.put("categoryAxisGlyph", this.categoryAxisGlyph.toJSONObject());
        }
        if (this.dateAxisGlyph != null) {
            jSONObject.put("dateAxisGlyph", this.dateAxisGlyph.toJSONObject());
        }
        return jSONObject;
    }
}

