/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.ArrayUtils;
import com.fr.base.FRFont;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.RectangleGlyph;
import com.fr.chart.legend.LegendItem;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;

public class LegendGlyph
extends RectangleGlyph {
    private static final long serialVersionUID = 8315404889874481890L;
    public static final int MARGIN = 2;
    public static final String XML_TAG = "LegendGlyph";
    private LegendItem[] items;
    private FRFont font;
    private int position = 4;
    private boolean autoAdjustSize = false;

    public LegendGlyph() {
    }

    public LegendGlyph(LegendItem[] legendItemArray) {
        this.setItems(legendItemArray);
    }

    public void setItems(LegendItem[] legendItemArray) {
        this.items = legendItemArray;
    }

    public LegendItem[] getItems() {
        return this.items;
    }

    public void setFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public FRFont getFont() {
        return this.font;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public void setRoundRect(boolean bl) {
        this.setRoundBorder(bl);
    }

    public boolean isRoundRect() {
        return this.isRoundBorder();
    }

    public Iterator selectableChildren() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        graphics2D.clip(this.getBounds());
        graphics2D.translate(this.bounds.getX(), this.bounds.getY());
        if (this.getItems() != null) {
            for (int i = 0; i < this.getItems().length; ++i) {
                this.getItems()[i].draw(graphics2D, this.font);
            }
        }
        graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
        graphics2D.setClip(shape);
    }

    public Dimension2D prefferedSize() {
        double d;
        double d2;
        if (ArrayUtils.isEmpty(this.getItems())) {
            return new Dimension();
        }
        double d3 = 0.2;
        int n = GraphHelper.getLineStyleSize(this.getBorderStyle());
        if (this.position == 1 || this.position == 3) {
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < this.getItems().length; ++i) {
                Dimension2D dimension2D = this.getItems()[i].prefferedSize(this.font);
                d4 += dimension2D.getWidth();
                d5 = Math.max(d5, dimension2D.getHeight());
            }
            d2 = (double)(n * 2 + 4 * this.getItems().length) + d4 * (d3 + 1.0);
            d = 4.0 + Math.max(d5, (double)this.font.getSize() * (1.0 + d3));
        } else {
            double d6 = 0.0;
            double d7 = 0.0;
            for (int i = 0; i < this.getItems().length; ++i) {
                Dimension2D dimension2D = this.getItems()[i].prefferedSize(this.font);
                d7 += dimension2D.getHeight();
                d6 = Math.max(d6, dimension2D.getWidth());
            }
            d = (double)(n * 2 + 4 * this.getItems().length) + d7 * (1.0 + d3);
            d2 = (1.0 + d3) * d6 + 4.0 + (double)(n * 2);
        }
        return new Dimension((int)d2, (int)d);
    }

    public void calculateBounds(Rectangle2D rectangle2D) {
        if (ArrayUtils.isEmpty(this.getItems())) {
            return;
        }
        this.font = this.font.applySize(1);
        Dimension2D dimension2D = this.prefferedSize();
        while (dimension2D.getHeight() < rectangle2D.getHeight() && dimension2D.getWidth() < rectangle2D.getWidth()) {
            this.font = this.font.applySize(this.font.getSize() + 1);
            dimension2D = this.prefferedSize();
        }
        if (this.position == 1 || this.position == 3) {
            rectangle2D.setFrame(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, rectangle2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
        } else {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        }
    }

    public void refreshItemBounds() {
        if (this.getItems() == null || this.getItems().length <= 0) {
            return;
        }
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(this.font);
        int n = fontMetrics.getHeight();
        int n2 = GraphHelper.getLineStyleSize(this.getBorderStyle());
        double d = this.bounds.getWidth() - (double)(n2 * 2);
        double d2 = this.bounds.getHeight() - (double)(n2 * 2);
        int n3 = Math.max(n, this.font.getSize());
        double d3 = 0.0;
        for (int i = 0; i < this.getItems().length; ++i) {
            d3 += this.getItems()[i].prefferedSize(this.font).getWidth();
        }
        if (d3 < d) {
            double d4 = (d - d3) / (double)this.getItems().length;
            double d5 = Math.max(0.0, d2 - (double)n3);
            double d6 = 0.0;
            for (int i = 0; i < this.getItems().length; ++i) {
                double d7 = d4 / 2.0 + d6 + d4 * (double)i + (double)n2;
                double d8 = d5 / 2.0 + (double)n2;
                this.getItems()[i].setBounds(new Rectangle((int)d7, (int)d8, this.font.getSize(), this.font.getSize()));
                d6 += this.getItems()[i].prefferedSize(this.font).getWidth();
            }
        } else {
            int n4;
            double d9 = 0.0;
            for (n4 = 0; n4 < this.getItems().length; ++n4) {
                double d10 = this.getItems()[n4].prefferedSize(this.font).getWidth();
                d9 = Math.max(d10, d9);
            }
            if (d9 < 0.1) {
                return;
            }
            n4 = Math.max(1, (int)(d / d9));
            int n5 = this.getItems().length / n4;
            if (n5 * n4 < this.getItems().length) {
                ++n5;
            }
            double d11 = d2 / (double)n5 - (double)Math.max(n, this.font.getSize());
            d11 = Math.max(d11, 0.0);
            double d12 = d / (double)n4;
            for (int i = 0; i < this.getItems().length; ++i) {
                int n6 = i % n4;
                int n7 = i / n4;
                double d13 = d12 * (double)n6 + (d12 - d9) / 2.0 + (double)n2;
                double d14 = d11 / 2.0 + (double)(n7 * n3) + (double)n7 * d11 + (double)n2;
                this.getItems()[i].setBounds(new Rectangle((int)d13, (int)d14, this.font.getSize(), this.font.getSize()));
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("FRFont")) {
                this.font = BaseXMLUtils.readFRFont(xMLableReader);
            } else if (string.equals("Items")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("LegendItem")) {
                            LegendItem legendItem = (LegendItem)xMLableReader.readXMLObject(new LegendItem());
                            if (LegendGlyph.this.items == null) {
                                LegendGlyph.access$002(LegendGlyph.this, new LegendItem[]{legendItem});
                            } else {
                                LegendItem[] legendItemArray = LegendGlyph.this.items;
                                LegendGlyph.access$002(LegendGlyph.this, new LegendItem[legendItemArray.length + 1]);
                                System.arraycopy(legendItemArray, 0, LegendGlyph.this.items, 0, legendItemArray.length);
                                ((LegendGlyph)LegendGlyph.this).items[legendItemArray.length] = legendItem;
                            }
                        }
                    }
                });
            } else if (string.equals("Position")) {
                String string2 = xMLableReader.getAttr("value");
                if (string2 != null) {
                    this.setPosition(Integer.parseInt(string2));
                }
            } else if (string.equals("Attr")) {
                String string3 = xMLableReader.getAttr("position");
                if (string3 != null) {
                    this.setPosition(Integer.parseInt(string3));
                }
                if ((string3 = xMLableReader.getAttr("autoAdjustSize")) != null) {
                    this.setAutoAdjustSize(Boolean.valueOf(string3));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("position", this.position).attr("autoAdjustSize", this.autoAdjustSize).end();
        if (this.getFont() != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.getFont());
        }
        if (this.getItems() != null && this.getItems().length > 0) {
            xMLPrintWriter.startTAG("Items");
            for (int i = 0; i < this.getItems().length; ++i) {
                this.getItems()[i].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LegendGlyph)) {
            return false;
        }
        LegendGlyph legendGlyph = (LegendGlyph)object;
        if (!super.equals(legendGlyph)) {
            return false;
        }
        if (!Equals.equals(legendGlyph.font, this.font)) {
            return false;
        }
        if (legendGlyph.position != this.position) {
            return false;
        }
        if (legendGlyph.autoAdjustSize != this.autoAdjustSize) {
            return false;
        }
        if (legendGlyph.getItems() != null && this.getItems() != null) {
            if (legendGlyph.getItems().length != this.getItems().length) {
                return false;
            }
            for (int i = 0; i < legendGlyph.getItems().length; ++i) {
                if (Equals.equals(legendGlyph.getItems()[i], this.getItems()[i])) continue;
                return false;
            }
        } else if (legendGlyph.getItems() == null && this.getItems() != null || legendGlyph.getItems() != null && this.getItems() == null) {
            return false;
        }
        return true;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("position", this.position);
        jSONObject.put("autoAdjustSize", this.autoAdjustSize);
        if (this.font != null) {
            jSONObject.put("font", this.font.toJSONObject());
        }
        if (this.items != null && this.items.length > 0) {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < this.items.length; ++i) {
                jSONArray.put(this.items[i].toJSONObject());
            }
            jSONObject.put("items", jSONArray);
        }
        return jSONObject;
    }

    public void setAutoAdjustSize(boolean bl) {
        this.autoAdjustSize = bl;
    }

    public boolean isAutoAdjustSize() {
        return this.autoAdjustSize;
    }

    static /* synthetic */ LegendItem[] access$002(LegendGlyph legendGlyph, LegendItem[] legendItemArray) {
        legendGlyph.items = legendItemArray;
        return legendItemArray;
    }
}

