/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.CategoryPlotGlyph;
import com.fr.chart.math.Plot3D;
import com.fr.chart.math.Projection;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.shape3d.FoldLine3D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Line3DPlotGlyph
extends CategoryPlotGlyph
implements Plot3D {
    private static final long serialVersionUID = 8357789096646931867L;
    public static final String XML_TAG = "Line3DPlotGlyph";
    private double seriesIntervalPercent = 0.0;
    private int deep = -1;
    private Projection projection = new Projection();

    public void layoutAxisGlyph() {
        super.layoutAxisGlyph();
        this.layout3DAxisGlyph();
    }

    public void layoutDataSeriesGlyph() {
        if (this.deep == -1) {
            this.deep = (int)this.getBounds().getWidth();
        }
        int n = this.getSeriesSize();
        double d = (double)this.deep / ((1.0 + this.getSeriesIntervalPercent()) * (double)n);
        for (int i = n - 1; i >= 0; --i) {
            DataSeries dataSeries = this.getSeries(i);
            double d2 = -this.getSeriesIntervalPercent() * d * (0.5 + (double)i) - d * (double)i;
            FoldLine3D foldLine3D = new FoldLine3D(0.0f, 100.0f);
            dataSeries.setDrawImpl(foldLine3D);
            foldLine3D.setProjection(this.projection);
            foldLine3D.getColorInfo().dealCondition(this.getSeriesCollection(), i);
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                float f;
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                double d3 = this.getDataPointPercentValue(i, j);
                float f2 = (float)this.getCategoryAxisGlyph().getPoint2DCateAxis(j, 0.5).getX();
                if (this.isStacked()) {
                    double d4 = 0.0;
                    for (int k = i - 1; k >= 0; --k) {
                        d4 += this.getDataPointPercentValue(k, j);
                    }
                    f = (float)(this.getValueAxisGlyph().getBounds().getY() + (double)((float)this.getValueAxisGlyph().getPoint2D(d4 + d3).getY()));
                } else {
                    f = (float)(this.getValueAxisGlyph().getBounds().getY() + (double)((float)this.getValueAxisGlyph().getPoint2D(d3).getY()));
                }
                if (j == 0) {
                    foldLine3D.moveTo(f2, f);
                } else {
                    foldLine3D.lineTo(f2, f);
                }
                Point2D point2D = this.projection.projectee(f2, f, 0.0);
                dataPoint.setShape(new Arc2D.Double(point2D.getX() - 3.0, point2D.getY() - 3.0, 6.0, 6.0, 0.0, 360.0, 2));
                this.dealDataPointLabelBounds(dataPoint, i);
            }
        }
    }

    public int getDeep() {
        return this.deep;
    }

    public void setDeep(int n) {
        this.deep = n;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setSeriesIntervalPercent(double d) {
        this.seriesIntervalPercent = d;
    }

    public double getSeriesIntervalPercent() {
        return this.seriesIntervalPercent;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("deep", this.deep).attr("seriesIntervalPercent", this.seriesIntervalPercent).end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("deep");
                if (string2 != null) {
                    this.deep = Integer.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("seriesIntervalPercent")) != null) {
                    this.seriesIntervalPercent = Double.valueOf(string2);
                }
            } else if (string.equals("Projection")) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Line3DPlotGlyph)) {
            return false;
        }
        Line3DPlotGlyph line3DPlotGlyph = (Line3DPlotGlyph)object;
        if (!super.equals(line3DPlotGlyph)) {
            return false;
        }
        if (line3DPlotGlyph.deep != this.deep) {
            return false;
        }
        if (line3DPlotGlyph.seriesIntervalPercent != this.seriesIntervalPercent) {
            return false;
        }
        return Equals.equals(line3DPlotGlyph.projection, this.projection);
    }

    public Object clone() throws CloneNotSupportedException {
        Line3DPlotGlyph line3DPlotGlyph = (Line3DPlotGlyph)super.clone();
        if (this.projection != null) {
            line3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return line3DPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("deep", this.deep);
        jSONObject.put("projection", this.projection.toJSONObject());
        jSONObject.put("seriesIntervalPercent", this.seriesIntervalPercent);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

