/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.FoldLine;
import com.fr.chart.core.glyph.CategoryPlotGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.plot.MarkerGlyph;
import java.awt.Graphics;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class LinePlotGlyph
extends CategoryPlotGlyph {
    private static final long serialVersionUID = -1824689734124193168L;
    public static final String XML_TAG = "LinePlotGlyph";
    private boolean isShowLine = true;
    private boolean isShowMarker = true;

    public void layoutDataSeriesGlyph() {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n = 0;
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                if (dataSeries.getDataPoint(j).isValueIsNull()) continue;
                ++n;
            }
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            n = 0;
            GeneralPath generalPath = new GeneralPath(1);
            boolean bl = true;
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                float f;
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (dataPoint.isValueIsNull()) {
                    if (!this.isNullValueBreak()) continue;
                    bl = true;
                    continue;
                }
                double d = this.getDataPointPercentValue(i, j);
                float f2 = (float)this.getCategoryAxisGlyph().getPoint2DCateAxis(j, 0.5).getX();
                if (this.isStacked()) {
                    double d2 = 0.0;
                    for (int k = i - 1; k >= 0; --k) {
                        d2 += this.getDataPointPercentValue(k, j);
                    }
                    f = (float)this.getValueAxisGlyph().getBounds().getY() + (float)this.getValueAxisGlyph().getPoint2D(d2 + d).getY();
                } else {
                    f = (float)this.getValueAxisGlyph().getBounds().getY() + (float)this.getValueAxisGlyph().getPoint2D(d).getY();
                }
                dArray[n] = f2;
                dArray2[n] = f;
                ++n;
                if (bl) {
                    generalPath.moveTo(f2, f);
                    bl = false;
                } else {
                    generalPath.lineTo(f2, f);
                }
                if (this.isShowMarker()) {
                    MarkerGlyph markerGlyph = new MarkerGlyph();
                    markerGlyph.dealCondition4Line(this.getSeriesCollection(), i);
                    markerGlyph.setShape(new Rectangle2D.Double(f2 - 5.0f, f - 5.0f, 10.0, 10.0));
                    dataPoint.setDrawImpl(markerGlyph);
                } else {
                    dataPoint.setShape(new Rectangle2D.Double(f2 - 5.0f, f - 5.0f, 10.0, 10.0));
                }
                this.dealDataPointLabelBounds(dataPoint, i);
            }
            if (this.isShowLine()) {
                FoldLine foldLine = new FoldLine(generalPath);
                dataSeries.setDrawImpl(foldLine);
                foldLine.getLineStyleInfo().dealCondition(this.getSeriesCollection(), i);
            }
            if (this.isStacked()) continue;
            this.trendLineFitting(dArray, dArray2, i);
        }
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        super.draw(graphics);
    }

    public void setShowLine(boolean bl) {
        this.isShowLine = bl;
    }

    public boolean isShowLine() {
        return this.isShowLine;
    }

    public void setShowMarker(boolean bl) {
        this.isShowMarker = bl;
    }

    public boolean isShowMarker() {
        return this.isShowMarker;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("ShowLine", this.isShowLine).attr("ShowMarker", this.isShowMarker).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            String string2 = xMLableReader.getAttr("ShowLine");
            if (string2 != null) {
                this.isShowLine = Boolean.valueOf(string2);
            }
            if ((string2 = xMLableReader.getAttr("ShowMarker")) != null) {
                this.isShowMarker = Boolean.valueOf(string2);
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LinePlotGlyph)) {
            return false;
        }
        LinePlotGlyph linePlotGlyph = (LinePlotGlyph)object;
        if (!super.equals(linePlotGlyph)) {
            return false;
        }
        if (linePlotGlyph.isShowLine != this.isShowLine) {
            return false;
        }
        return linePlotGlyph.isShowMarker == this.isShowMarker;
    }

    public Object clone() throws CloneNotSupportedException {
        LinePlotGlyph linePlotGlyph = (LinePlotGlyph)super.clone();
        return linePlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("isShowLine", this.isShowLine);
        jSONObject.put("isShowMarker", this.isShowMarker);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

