/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.plot.Meter;
import com.fr.chart.plot.MeterStyle;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class MeterPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -7720249461263542792L;
    public static final double GAP = 10.0;
    public static final String XML_TAG = "MeterPlotGlyph";
    private MeterStyle meterStyle;

    public void layoutAxisGlyph() {
    }

    public void layoutDataSeriesGlyph() {
        if (!VT4FR.ADVANCED_CHART.support()) {
            return;
        }
        Rectangle2D rectangle2D = this.getBounds();
        int n = this.getSeriesSize();
        int n2 = this.getCategoryCount();
        double d = (rectangle2D.getHeight() - (double)(n + 1) * 10.0) / (double)n;
        double d2 = (rectangle2D.getWidth() - (double)(n2 + 1) * 10.0) / (double)n2;
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            for (int j = 0; j < n2; ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (dataPoint.isValueIsNull()) continue;
                String string = dataPoint.getCategoryName();
                Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, this.getMeterStyle().getTitleTextAttr());
                TextGlyph textGlyph = new TextGlyph(string, this.getMeterStyle().getTitleTextAttr());
                textGlyph.setBounds(new Rectangle2D.Double((d2 - dimension2D.getWidth()) * 0.5, -dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight()));
                Meter meter = new Meter(textGlyph, dataPoint.getValue(), this.getMeterStyle());
                dataPoint.setDrawImpl(meter);
                meter.setBounds(new Rectangle2D.Double((double)j * d2 + (double)(j + 1) * 10.0, (double)i * d + dimension2D.getHeight(), d2, d - dimension2D.getHeight()));
                this.dealDataPointLabelBounds(dataPoint, i);
            }
        }
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        super.draw(graphics);
    }

    public void setMeterStyle(MeterStyle meterStyle) {
        this.meterStyle = meterStyle;
    }

    public MeterStyle getMeterStyle() {
        return this.meterStyle;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.meterStyle != null) {
            this.meterStyle.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("MeterStyle")) {
            this.meterStyle = (MeterStyle)xMLableReader.readXMLObject(new MeterStyle());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MeterPlotGlyph)) {
            return false;
        }
        MeterPlotGlyph meterPlotGlyph = (MeterPlotGlyph)object;
        if (!super.equals(meterPlotGlyph)) {
            return false;
        }
        return Equals.equals(meterPlotGlyph.meterStyle, this.meterStyle);
    }

    public Object clone() throws CloneNotSupportedException {
        MeterPlotGlyph meterPlotGlyph = (MeterPlotGlyph)super.clone();
        if (this.meterStyle != null) {
            meterPlotGlyph.meterStyle = (MeterStyle)this.meterStyle.clone();
        }
        return meterPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.meterStyle != null) {
            jSONObject.put("meterStyle", this.meterStyle.toJSONObject());
        }
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

