/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.PiePlotGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.math.Projection;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.shape3d.Cylinder;
import com.fr.chart.shape3d.Pie3D;
import java.awt.geom.Point2D;

public class Pie3DPlotGlyph
extends PiePlotGlyph {
    private static final long serialVersionUID = -8454922131125531977L;
    public static final String XML_TAG = "Pie3DPlotGlyph";
    private int depth = 20;
    private Projection projection = new Projection();

    public boolean supportJSDrawing() {
        return false;
    }

    public void layoutAxisGlyph() {
    }

    public void layoutDataSeriesGlyph() {
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            this.instancePieNumber();
            double d = this.getPieDimension();
            double d2 = d / (2.0 + (double)(2 * this.getSeparatePercent()) / 100.0);
            double d3 = this.getStartAngle();
            double d4 = (double)this.getSeparatePercent() / 100.0 * d2;
            Pie3D pie3D = new Pie3D();
            pie3D.setProjection(this.getProjection());
            for (int j = 0; j < this.getSeriesSize(); ++j) {
                DataSeries dataSeries = this.getSeries(j);
                DataPoint dataPoint = dataSeries.getDataPoint(i);
                if (dataPoint.isValueIsNull()) continue;
                double d5 = this.getHalfAngle(d3, j, i);
                double d6 = ((double)i + 0.5) * this.getBounds().getWidth() / (double)this.getCategoryCount();
                Point2D.Double double_ = new Point2D.Double(d6, this.getBounds().getHeight() / 2.0);
                Cylinder cylinder = new Cylinder(0.0, this.getDepth(), d2);
                cylinder.setX(((Point2D)double_).getX() + d4 * Math.cos(Math.toRadians(d5)));
                cylinder.setY(((Point2D)double_).getY() - d4 * Math.sin(Math.toRadians(d5)));
                cylinder.setStart(d3);
                cylinder.setExtent(this.getPercent(j, i) * 360.0);
                cylinder.setProjection(this.getProjection());
                cylinder.getColorInfo().dealCondition(this.getSeriesCollection(), j);
                pie3D.addCylinder(cylinder);
                if (j == 0) {
                    dataPoint.setDrawImpl(pie3D);
                }
                TextGlyph textGlyph = dataPoint.getDataLabel();
                this.dealLabelBounds(cylinder.top().getBounds2D(), double_, d5, j, i, textGlyph, d * 0.5);
                this.dealLeadLine(cylinder.top(), dataPoint, textGlyph, j, d5);
                d3 += this.getPercent(j, i) * 360.0;
            }
        }
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("depth", this.depth).end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("depth");
                if (string2 != null) {
                    this.depth = Integer.valueOf(string2);
                }
            } else if (string.equals("Projection")) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pie3DPlotGlyph)) {
            return false;
        }
        Pie3DPlotGlyph pie3DPlotGlyph = (Pie3DPlotGlyph)object;
        if (!super.equals(pie3DPlotGlyph)) {
            return false;
        }
        if (pie3DPlotGlyph.depth != this.depth) {
            return false;
        }
        return Equals.equals(pie3DPlotGlyph.projection, this.projection);
    }

    public Object clone() throws CloneNotSupportedException {
        Pie3DPlotGlyph pie3DPlotGlyph = (Pie3DPlotGlyph)super.clone();
        if (this.projection != null) {
            pie3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return pie3DPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("depth", this.depth);
        jSONObject.put("projection", this.projection.toJSONObject());
        return jSONObject;
    }
}

