/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.DataLabelInfo;
import com.fr.chart.axis.SeriesAttrContents;
import com.fr.chart.axis.SeriesAttrPosition;
import com.fr.chart.axis.SeriesAttrStyle;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.shape3d.Cylinder;
import java.awt.Graphics;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PiePlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 7862387644048932954L;
    public static final String XML_TAG = "PiePlotGlyph";
    private int startAngle = 100;
    private int separatePercent = 0;
    protected transient int oneNumber;
    protected transient int twoNumber;
    protected transient int threeNumber;
    protected transient int fourNumber;

    public void layoutAxisGlyph() {
    }

    public void layoutDataSeriesGlyph() {
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            this.instancePieNumber();
            double d = this.getPieDimension();
            double d2 = d / (2.0 + (double)(2 * this.getSeparatePercent()) / 100.0);
            double d3 = this.getStartAngle();
            for (int j = 0; j < this.getSeriesSize(); ++j) {
                DataSeries dataSeries = this.getSeries(j);
                DataPoint dataPoint = dataSeries.getDataPoint(i);
                if (dataPoint.isValueIsNull()) continue;
                double d4 = ((double)i + 0.5) * this.getBounds().getWidth() / (double)this.getCategoryCount();
                Point2D.Double double_ = new Point2D.Double(d4, this.getBounds().getHeight() / 2.0);
                Arc2D arc2D = this.getDataPointShape(double_, j, i, d3, d2);
                ShapeGlyph shapeGlyph = new ShapeGlyph(arc2D);
                shapeGlyph.getInfo().dealCondition(this.getSeriesCollection(), j);
                dataPoint.setDrawImpl(shapeGlyph);
                TextGlyph textGlyph = dataPoint.getDataLabel();
                double d5 = this.getHalfAngle(d3, j, i);
                this.dealLabelBounds(dataPoint.getShape().getBounds2D(), double_, d5, j, i, textGlyph, d * 0.5);
                this.dealLeadLine(arc2D, dataPoint, textGlyph, j, d5);
                d3 += this.getPercent(j, i) * 360.0;
            }
        }
    }

    protected void instancePieNumber() {
        this.oneNumber = 0;
        this.twoNumber = 0;
        this.threeNumber = 0;
        this.fourNumber = 0;
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            double d = this.getStartAngle();
            for (int j = 0; j < this.getSeriesSize(); ++j) {
                TextGlyph textGlyph;
                DataSeries dataSeries = this.getSeries(j);
                DataPoint dataPoint = dataSeries.getDataPoint(i);
                SeriesAttrPosition seriesAttrPosition = (SeriesAttrPosition)this.getSeriesCollection().getSeriesCondition(new SeriesAttrPosition(), j);
                if (seriesAttrPosition.getPosition() == 6 && dataPoint.getDataLabel() != null && (textGlyph = dataPoint.getDataLabel()).getText() != null && textGlyph.getText().length() > 0) {
                    double d2 = this.getHalfAngle(d, j, i);
                    double d3 = d2 % 360.0;
                    if (d3 <= 90.0 && d3 > 0.0) {
                        ++this.oneNumber;
                    } else if (d3 <= 180.0 && d3 > 90.0) {
                        ++this.twoNumber;
                    } else if (d3 <= 270.0 && d3 > 180.0) {
                        ++this.threeNumber;
                    } else if (d3 <= 360.0 && d3 > 270.0) {
                        ++this.fourNumber;
                    }
                }
                d += this.getPercent(j, i) * 360.0;
            }
        }
    }

    protected double getPieDimension() {
        Rectangle2D rectangle2D = this.getBounds();
        double d = Math.min(rectangle2D.getWidth() / (double)this.getCategoryCount(), rectangle2D.getHeight());
        d = this.deal4BestRad(d);
        return d;
    }

    protected double deal4BestRad(double d) {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataLabelInfo dataLabelInfo = new DataLabelInfo();
            dataLabelInfo.dealCondition(this.getSeriesCollection(), i);
            if (dataLabelInfo == null || dataLabelInfo.getPosition() != 6) continue;
            d = (d - 28.0) * 0.6;
            return d;
        }
        return d;
    }

    private Arc2D getDataPointShape(Point2D point2D, int n, int n2, double d, double d2) {
        double d3 = (double)this.getSeparatePercent() / 100.0 * d2;
        double d4 = this.getHalfAngle(d, n, n2);
        Arc2D.Double double_ = new Arc2D.Double(point2D.getX() + d3 * Math.cos(Math.toRadians(d4)) - d2, point2D.getY() - d3 * Math.sin(Math.toRadians(d4)) - d2, 2.0 * d2, 2.0 * d2, d, this.getPercent(n, n2) * 360.0, 2);
        return double_;
    }

    protected void dealLeadLine(Arc2D arc2D, DataPoint dataPoint, TextGlyph textGlyph, int n, double d) {
        SeriesAttrContents seriesAttrContents = (SeriesAttrContents)this.getSeriesCollection().getSeriesCondition(new SeriesAttrContents(), n);
        SeriesAttrPosition seriesAttrPosition = (SeriesAttrPosition)this.getSeriesCollection().getSeriesCondition(new SeriesAttrPosition(), n);
        String string = textGlyph.getText();
        if (string != null && seriesAttrContents.isShowGuidLine() && textGlyph.getBounds() != null && seriesAttrPosition.getPosition() == 6) {
            Rectangle2D rectangle2D = textGlyph.getBounds();
            Point2D point2D = Cylinder.getArcPoint(arc2D, d);
            double d2 = point2D.getX();
            double d3 = point2D.getY();
            double d4 = rectangle2D.getX();
            double d5 = rectangle2D.getY();
            double d6 = 0.0;
            double d7 = 0.0;
            if ((d %= 360.0) >= 0.0 && d < 90.0) {
                d6 = rectangle2D.getX() - 4.0;
                d7 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
                d4 = rectangle2D.getX();
                d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            } else if (d >= 90.0 && d < 180.0) {
                d6 = d4 + rectangle2D.getWidth() + 4.0;
                d7 = d5 + rectangle2D.getHeight() / 2.0;
                d4 = rectangle2D.getX() + rectangle2D.getWidth();
                d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            } else if (d >= 180.0 && d < 270.0) {
                d6 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d7 = rectangle2D.getY() - 4.0;
                d4 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d5 = rectangle2D.getY();
            } else if (d >= 270.0 && d < 360.0) {
                d6 = rectangle2D.getX() - 4.0;
                d7 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
                d4 = rectangle2D.getX();
                d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)d2, (float)d3);
            generalPath.lineTo((float)d6, (float)d7);
            generalPath.lineTo((float)d4, (float)d5);
            dataPoint.setLeadLine(generalPath);
        }
    }

    protected void dealLabelBounds(Rectangle2D rectangle2D, Point2D point2D, double d, int n, int n2, TextGlyph textGlyph, double d2) {
        double d3 = d2 * 1.5;
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        String string = textGlyph.getText();
        if (string != null && string.length() > 0) {
            SeriesAttrStyle seriesAttrStyle = (SeriesAttrStyle)this.getSeriesCollection().getSeriesCondition(new SeriesAttrStyle(), n);
            TextAttr textAttr = seriesAttrStyle.getTextAttr();
            Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
            SeriesAttrPosition seriesAttrPosition = (SeriesAttrPosition)this.getSeriesCollection().getSeriesCondition(new SeriesAttrPosition(), n);
            if (seriesAttrPosition.getPosition() == 6) {
                double d6 = d % 360.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                if (d6 <= 90.0 && d6 > 0.0 && this.oneNumber > 0) {
                    double d10 = this.getIndexNumber(n2, 1, d6);
                    d9 = 90.0 * d10 / (double)(this.oneNumber + 1);
                } else if (d6 <= 180.0 && d6 > 90.0 && this.twoNumber > 0) {
                    double d11 = this.getIndexNumber(n2, 2, d6);
                    d9 = 90.0 * d11 / (double)(this.twoNumber + 1) + 90.0;
                } else if (d6 <= 270.0 && d6 > 180.0 && this.threeNumber > 0) {
                    double d12 = this.getIndexNumber(n2, 3, d6);
                    d9 = 90.0 * d12 / (double)(this.threeNumber + 1) + 180.0;
                } else if (d6 <= 360.0 && d6 > 270.0 && this.fourNumber > 0) {
                    double d13 = this.getIndexNumber(n2, 4, d6);
                    d9 = 90.0 * d13 / (double)(this.fourNumber + 1) + 270.0;
                }
                double d14 = dimension2D.getHeight();
                double d15 = dimension2D.getWidth();
                d7 = d4 + d3 * Math.cos(Math.PI * d9 / 180.0);
                d8 = d5 - d3 * Math.sin(Math.PI * d9 / 180.0);
                if (d9 > 90.0 && d9 < 270.0) {
                    d7 -= d15;
                }
                textGlyph.setBounds(new Rectangle2D.Double(d7, d8, d15, d14));
            } else {
                double d16 = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
                double d17 = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
                textGlyph.setBounds(new Rectangle2D.Double(d16, d17, dimension2D.getWidth(), dimension2D.getHeight()));
            }
        }
    }

    protected int getIndexNumber(int n, int n2, double d) {
        int n3 = 1;
        double d2 = this.getStartAngle();
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            TextGlyph textGlyph;
            TextGlyph textGlyph2;
            DataSeries dataSeries = this.getSeries(i);
            DataPoint dataPoint = dataSeries.getDataPoint(n);
            SeriesAttrPosition seriesAttrPosition = (SeriesAttrPosition)this.getSeriesCollection().getSeriesCondition(new SeriesAttrPosition(), i);
            if (seriesAttrPosition.getPosition() == 6 && dataPoint.getDataLabel() != null && (textGlyph2 = (textGlyph = dataPoint.getDataLabel())).getText() != null && textGlyph2.getText().length() > 0) {
                double d3 = this.getHalfAngle(d2, i, n) % 360.0;
                if (n2 == 1 && d < 90.0 && d > 0.0) {
                    if (d > d3 && d3 > 0.0) {
                        ++n3;
                    }
                } else if (n2 == 2 && d > 90.0 && d < 180.0) {
                    if (d > d3 && d3 > 90.0) {
                        ++n3;
                    }
                } else if (n2 == 3 && d > 180.0 && d < 270.0) {
                    if (d > d3 && d3 > 180.0) {
                        ++n3;
                    }
                } else if (n2 == 4 && d > 270.0 && d < 360.0 && d > d3 && d3 > 270.0) {
                    ++n3;
                }
            }
            d2 += this.getPercent(i, n) * 360.0;
        }
        return n3;
    }

    protected double getHalfAngle(double d, int n, int n2) {
        return d + 0.5 * this.getPercent(n, n2) * 360.0;
    }

    private double getTotalValue(int n) {
        double d = 0.0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint dataPoint = dataSeries.getDataPoint(n);
            d += Math.abs(dataPoint.getValue());
        }
        return d;
    }

    protected double getPercent(int n, int n2) {
        double d = this.getSeries(n).getDataPoint(n2).getValue();
        return Math.abs(d) / this.getTotalValue(n2);
    }

    public void setStartAngle(int n) {
        this.startAngle = n;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setSeparatePercent(int n) {
        this.separatePercent = n;
    }

    public int getSeparatePercent() {
        return this.separatePercent;
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        super.draw(graphics);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("startAngle", this.startAngle).attr("separatePercent", this.separatePercent).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            String string2 = xMLableReader.getAttr("startAngle");
            if (string2 != null) {
                this.startAngle = Integer.valueOf(string2);
            }
            if ((string2 = xMLableReader.getAttr("separatePercent")) != null) {
                this.separatePercent = Integer.valueOf(string2);
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof PiePlotGlyph)) {
            return false;
        }
        PiePlotGlyph piePlotGlyph = (PiePlotGlyph)object;
        if (!super.equals(piePlotGlyph)) {
            return false;
        }
        if (piePlotGlyph.startAngle != this.startAngle) {
            return false;
        }
        return piePlotGlyph.separatePercent == this.separatePercent;
    }

    public Object clone() throws CloneNotSupportedException {
        PiePlotGlyph piePlotGlyph = (PiePlotGlyph)super.clone();
        return piePlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("startAngle", this.getStartAngle());
        jSONObject.put("separatePercent", this.separatePercent);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

