/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.IteratorChain;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.DataLabelInfo;
import com.fr.chart.axis.SeriesAttrPosition;
import com.fr.chart.axis.SeriesAttrTrendLine;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.RectangleGlyph;
import com.fr.chart.core.TrendLine;
import com.fr.chart.core.glyph.AxisGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.plot.SeriesCollection;
import com.fr.report.js.NameJavaScriptGroup;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PlotGlyph
extends RectangleGlyph {
    private static final long serialVersionUID = -2464599809725765353L;
    public static final String XML_TAG = "PlotGlyph";
    protected List seriesList = new ArrayList();
    private SeriesCollection seriesCollection = new SeriesCollection();
    private NameJavaScriptGroup hotHyperLink;
    private String hotTooltip = null;
    private boolean isNullValueBreak;

    public void addSeries(DataSeries dataSeries) {
        this.seriesList.add(dataSeries);
    }

    public int getSeriesSize() {
        return this.seriesList.size();
    }

    public DataSeries getSeries(int n) {
        if (n < this.seriesList.size()) {
            return (DataSeries)this.seriesList.get(n);
        }
        return null;
    }

    public int getCategoryCount() {
        if (this.getSeries(0) != null) {
            return this.getSeries(0).getDataPointCount();
        }
        return 0;
    }

    public Iterator selectableChildren() {
        return new IteratorChain(new Iterator[]{this.seriesList.iterator()});
    }

    public boolean supportJSDrawing() {
        return true;
    }

    public void draw(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        int n2 = this.getSeriesSize();
        for (n = 0; n < n2; ++n) {
            this.getSeries(n).draw(graphics);
        }
        n2 = this.getSeriesSize();
        for (n = 0; n < n2; ++n) {
            this.getSeries(n).drawLabel(graphics);
        }
        n2 = this.getSeriesSize();
        for (n = 0; n < n2; ++n) {
            this.getSeries(n).drawTrendLine(graphics);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public void drawInfo(Graphics graphics) {
        this.getInfo().paint(graphics, this.getOutline4Fill());
    }

    public abstract void layoutAxisGlyph();

    public abstract void layoutDataSeriesGlyph();

    protected void dealDataPointLabelBounds(DataPoint dataPoint, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph instanceof TextGlyph) {
            TextGlyph textGlyph2 = textGlyph;
            SeriesAttrPosition seriesAttrPosition = (SeriesAttrPosition)this.getSeriesCollection().getSeriesCondition(new SeriesAttrPosition(), n);
            Rectangle2D rectangle2D = DataLabelInfo.preferredLabelBounds(textGlyph2, dataPoint, seriesAttrPosition.getPosition());
            textGlyph2.setBounds(rectangle2D);
        }
    }

    public void axisExtends(AxisGlyph axisGlyph) {
        int n = 0;
        int n2 = 0;
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            SeriesAttrTrendLine seriesAttrTrendLine = (SeriesAttrTrendLine)this.getSeriesCollection().getSeriesCondition(new SeriesAttrTrendLine(), i);
            if (seriesAttrTrendLine == null) continue;
            if (seriesAttrTrendLine.getBackward() > n) {
                n = seriesAttrTrendLine.getBackward();
            }
            if (seriesAttrTrendLine.getForward() <= n2) continue;
            n2 = seriesAttrTrendLine.getForward();
        }
        axisGlyph.axisExtends(n2, n);
    }

    protected void trendLineFitting(double[] dArray, double[] dArray2, int n) {
        DataSeries dataSeries = this.getSeries(n);
        SeriesAttrTrendLine seriesAttrTrendLine = (SeriesAttrTrendLine)this.getSeriesCollection().getSeriesCondition(new SeriesAttrTrendLine(), n);
        TrendLine trendLine = null;
        if (seriesAttrTrendLine != null) {
            trendLine = seriesAttrTrendLine.getLine();
        }
        if (trendLine != null) {
            trendLine = (TrendLine)trendLine.clone();
            trendLine.fitting(dArray, dArray2);
            trendLine.drawShape(new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight()));
            dataSeries.setTrendLine(trendLine);
        }
    }

    public void setSeriesCollection(SeriesCollection seriesCollection) {
        this.seriesCollection = seriesCollection;
    }

    public SeriesCollection getSeriesCollection() {
        return this.seriesCollection;
    }

    public void setHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup) {
        this.hotHyperLink = nameJavaScriptGroup;
    }

    public NameJavaScriptGroup getHotHyperLink() {
        return this.hotHyperLink;
    }

    public void setHotTooltip(String string) {
        this.hotTooltip = string;
    }

    public String getHotTooltip() {
        return this.hotTooltip;
    }

    public void setIsNullValueBreak(boolean bl) {
        this.isNullValueBreak = bl;
    }

    public boolean isNullValueBreak() {
        return this.isNullValueBreak;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("SeriesList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("DataSeries")) {
                            PlotGlyph.this.addSeries((DataSeries)xMLableReader.readXMLObject(new DataSeries()));
                        }
                    }
                });
            } else if (string.equals("NewSeriesCollection")) {
                this.seriesCollection = (SeriesCollection)xMLableReader.readXMLObject(new SeriesCollection());
            } else if ("NameJavaScriptGroup".equals(string) || "NameHyperlinks".equals(string) || "HyperlinkMap".equals(string)) {
                this.hotHyperLink = (NameJavaScriptGroup)xMLableReader.readXMLObject(new NameJavaScriptGroup());
            } else if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("hotTooltip");
                if (string2 != null) {
                    this.hotTooltip = string2;
                }
                if ((string2 = xMLableReader.getAttr("isNullValueBreak")) != null) {
                    this.isNullValueBreak = Boolean.valueOf(string2);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("hotTooltip", this.hotTooltip).attr("isNullValueBreak", this.isNullValueBreak).end();
        if (this.seriesList != null && this.seriesList.size() > 0) {
            xMLPrintWriter.startTAG("SeriesList");
            for (int i = 0; i < this.seriesList.size(); ++i) {
                ((DataSeries)this.seriesList.get(i)).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.seriesCollection != null) {
            this.seriesCollection.writeXML(xMLPrintWriter);
        }
        if (this.hotHyperLink != null) {
            this.hotHyperLink.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlotGlyph)) {
            return false;
        }
        PlotGlyph plotGlyph = (PlotGlyph)object;
        if (!super.equals(plotGlyph)) {
            return false;
        }
        if (plotGlyph.seriesList != null && plotGlyph.seriesList.size() > 0) {
            for (int i = 0; i < plotGlyph.seriesList.size(); ++i) {
                if (Equals.equals(plotGlyph.seriesList.get(i), this.seriesList.get(i))) continue;
                return false;
            }
        }
        if (!Equals.equals(plotGlyph.seriesCollection, this.seriesCollection)) {
            return false;
        }
        if (!Equals.equals(plotGlyph.getHotHyperLink(), this.getHotHyperLink())) {
            return false;
        }
        if (!Equals.equals(this.hotTooltip, plotGlyph.hotTooltip)) {
            return false;
        }
        return this.isNullValueBreak == plotGlyph.isNullValueBreak;
    }

    public Object clone() throws CloneNotSupportedException {
        PlotGlyph plotGlyph = (PlotGlyph)super.clone();
        if (this.seriesCollection != null) {
            plotGlyph.seriesCollection = (SeriesCollection)this.seriesCollection.clone();
        }
        if (this.seriesList != null) {
            plotGlyph.seriesList = new ArrayList();
            for (int i = 0; i < this.seriesList.size(); ++i) {
                plotGlyph.seriesList.add(((DataSeries)this.seriesList.get(i)).clone());
            }
        }
        if (this.hotHyperLink != null) {
            plotGlyph.hotHyperLink = (NameJavaScriptGroup)this.hotHyperLink.clone();
        }
        return plotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.seriesCollection != null) {
            jSONObject.put("seriesCollection", this.seriesCollection.toJSONObject());
        }
        if (this.seriesList != null && this.seriesList.size() > 0) {
            Object[] objectArray = this.seriesList.toArray();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = ((DataSeries)objectArray[i]).toJSONObject();
            }
            jSONObject.put("seriesList", objectArray2);
        }
        if (this.hotHyperLink != null) {
            // empty if block
        }
        jSONObject.put("isNullValueBreak", this.isNullValueBreak);
        return jSONObject;
    }

    public abstract String getPlotGlyphType();
}

