/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.Axis;
import com.fr.chart.axis.RadarAxis;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.AxisGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.util.Utils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public class RadarAxisGlyph
extends AxisGlyph {
    private static final long serialVersionUID = -2702639014404531055L;
    public static final String XML_TAG = "RadarAxisGlyph";
    private double D = 0.0;
    private double radian = 0.0;
    private int categoryCount;
    private RadarAxis radarAxis;
    private List labelList = new ArrayList();

    public RadarAxisGlyph() {
    }

    public RadarAxisGlyph(RadarAxis radarAxis) {
        super(radarAxis);
    }

    public void init(Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D);
        this.setOrigin(new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()));
        this.setD(Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()));
        this.setRadian(Math.toRadians(360 / this.getCategoryCount()));
        this.setAxisLength(this.getD() / 2.0);
    }

    public void initMinMaxValue(double d, double d2) {
        if (this.radarAxis.isCustomMinValue()) {
            d = this.minValue = this.radarAxis.getMinValue();
        } else {
            this.minValue = d;
        }
        if (this.radarAxis.isCustomMaxValue()) {
            d2 = this.maxValue = this.radarAxis.getMaxValue();
        }
        if (d2 - d > 0.0) {
            this.tickLength = Axis.calculateIncrement(this.minValue, d2);
            this.smallTickLength = this.tickLength / 5.0;
        }
        if ((d2 - d) % this.tickLength != 0.0) {
            d2 = d2 + this.tickLength - (d2 - d) % this.tickLength;
        }
        if (!this.radarAxis.isCustomMaxValue()) {
            this.maxValue = d2;
        }
        if (this.minValue >= this.maxValue) {
            this.maxValue = this.minValue + 10.0;
        }
    }

    public Axis getAxis() {
        return this.radarAxis;
    }

    public void setAxis(Axis axis) {
        if (!(axis instanceof RadarAxis)) {
            throw new IllegalArgumentException();
        }
        this.radarAxis = (RadarAxis)axis;
    }

    public void setCategoryCount(int n) {
        this.categoryCount = n;
    }

    public int getCategoryCount() {
        return this.categoryCount;
    }

    public void setD(double d) {
        this.D = d;
    }

    public double getD() {
        return this.D;
    }

    public void setRadian(double d) {
        this.radian = d;
    }

    public double getRadian() {
        return this.radian;
    }

    public void calculateAxisLengthUnit() {
        this.unitLength = this.axisLength / (this.getMaxValue() - this.getMinValue());
    }

    public Point2D getPoint2D(int n, double d) {
        return new Point2D.Double(this.originPoint.getX() + Math.cos(this.radian * (double)n + 1.5707963267948966) * (d -= this.getCrossValue()) * this.unitLength, this.originPoint.getY() - Math.sin(this.radian * (double)n + 1.5707963267948966) * d * this.unitLength);
    }

    protected void drawAxisGrid(Graphics graphics) {
        int n;
        Line2D[] line2DArray;
        double d;
        Paint paint;
        Stroke stroke;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getAxis().getSecondGridStyle() != 0 && this.smallTickLength > 0.0) {
            stroke = graphics2D.getStroke();
            paint = graphics2D.getPaint();
            graphics2D.setStroke(GraphHelper.getStroke(this.getAxis().getSecondGridStyle()));
            graphics2D.setPaint(this.getAxis().getSecondGridColor());
            for (d = this.getCrossValue(); d < this.getMaxValue(); d += this.smallTickLength) {
                line2DArray = this.getGridLine(d);
                for (n = 0; n < line2DArray.length; ++n) {
                    graphics2D.draw(line2DArray[n]);
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
        if (this.getAxis().getMainGridStyle() != 0 && this.tickLength > 0.0) {
            stroke = graphics2D.getStroke();
            paint = graphics2D.getPaint();
            graphics2D.setStroke(GraphHelper.getStroke(this.getAxis().getMainGridStyle()));
            graphics2D.setPaint(this.getAxis().getMainGridColor());
            for (d = this.getCrossValue(); d <= this.getMaxValue(); d += this.tickLength) {
                line2DArray = this.getGridLine(d);
                for (n = 0; n < line2DArray.length; ++n) {
                    graphics2D.draw(line2DArray[n]);
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    protected Line2D[] getGridLine(double d) {
        Line2D[] line2DArray = new Line2D[this.getCategoryCount()];
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            line2DArray[i] = new Line2D.Double(this.getPoint2D(i, d), this.getPoint2D(i + 1, d));
        }
        return line2DArray;
    }

    protected void drawAxisLine(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.getAxis().getLineColor());
        Line2D[] line2DArray = this.getAxisLines();
        for (int i = 0; i < line2DArray.length && this.getAxis().isAxisShow(); ++i) {
            GraphHelper.draw(graphics2D, line2DArray[i], this.getAxis().getLineStyle());
            this.drawArrow(graphics2D, line2DArray[i].getP1(), line2DArray[i].getP2());
            if (this.getAxis().isArrowShow()) {
                this.drawCateLabel(graphics2D, i, line2DArray[i].getP2(), 16.0);
                continue;
            }
            this.drawCateLabel(graphics2D, i, line2DArray[i].getP2(), 0.0);
        }
        this.drawTicks(graphics2D);
        graphics2D.setPaint(paint);
    }

    public void drawTicks(Graphics graphics) {
        int n;
        for (n = 0; n < this.getCategoryCount() && this.getAxis().isAxisShow(); ++n) {
            int n2 = 0;
            int n3 = 0;
            n3 = this.getAxis().getLabelNumber() == -1 || this.getAxis().getLabelNumber() == 0 ? 1 : this.getAxis().getLabelNumber();
            BigDecimal bigDecimal = new BigDecimal(Double.toString(this.getCrossValue()));
            BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.tickLength));
            BigDecimal bigDecimal3 = new BigDecimal(Double.toString(n3));
            for (double d = this.getCrossValue(); d <= this.getMaxValue(); d += this.tickLength * (double)n3) {
                GraphHelper.draw(graphics, this.getTickLine(n, d, this.radarAxis.getTickLength(), this.radarAxis.getTickMarkType()));
                if (n == 0) {
                    this.drawFirstAxisLabel(graphics, n, bigDecimal.doubleValue(), n2);
                }
                ++n2;
                bigDecimal = bigDecimal.add(bigDecimal2.multiply(bigDecimal3));
            }
        }
        for (n = 0; n < this.getCategoryCount() && this.getAxis().isAxisShow(); ++n) {
            for (double d = this.getCrossValue() + this.smallTickLength; d <= this.getMaxValue(); d += this.smallTickLength) {
                double d2 = (d - this.getCrossValue()) / this.smallTickLength;
                if (d2 == 5.0) continue;
                GraphHelper.draw(graphics, this.getTickLine(n, d, this.radarAxis.getSecTickLength(), this.radarAxis.getSecTickMarkType()));
            }
        }
    }

    private void drawCateLabel(Graphics graphics, int n, Point2D point2D, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.getLabelList().get(n).toString();
        Point2D.Double double_ = new Point2D.Double(point2D.getX() + Math.cos(this.radian * (double)n + 1.5707963267948966) * d, point2D.getY() - Math.sin(this.radian * (double)n + 1.5707963267948966) * d);
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, new TextAttr());
        double d2 = n * 360 / this.getCategoryCount() + 90;
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        double d5 = ((Point2D)double_).getY() - 0.5 * d4 * (Math.sin(Math.PI / 180 * d2) + 1.0);
        double d6 = ((Point2D)double_).getX() + 0.5 * d3 * (Math.cos(Math.PI / 180 * d2) - 1.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d6, d5, d3, d4);
        TextGlyph.drawLabel(graphics2D, string, new TextAttr(), double_2);
    }

    protected Line2D getTickLine(int n, double d, int n2, int n3) {
        Point2D point2D = this.getPoint2D(n, d);
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - (double)n2 / 2.0 * Math.cos((double)n * this.radian), point2D.getY() + (double)n2 / 2.0 * Math.sin((double)n * this.radian));
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() + (double)n2 / 2.0 * Math.cos((double)n * this.radian), point2D.getY() - (double)n2 / 2.0 * Math.sin((double)n * this.radian));
        if (n3 == 3) {
            return new Line2D.Double(double_, double_2);
        }
        if (n3 == 1) {
            return new Line2D.Double(double_, point2D);
        }
        if (n3 == 2) {
            return new Line2D.Double(point2D, double_2);
        }
        return new Line2D.Double(point2D, point2D);
    }

    protected void drawFirstAxisLabel(Graphics graphics, int n, double d, int n2) {
        Point2D point2D = this.getPoint2D(n, d);
        Format format = this.getAxis().getFormat();
        String string = null;
        string = format != null ? format.format(Double.valueOf(Utils.doubleToString(d))) : Utils.doubleToString(d);
        TextAttr textAttr = this.radarAxis.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        double d2 = 4 + this.getAxis().getTickLength() / 2;
        Rectangle2D.Double double_ = null;
        if (this.getAxis().getAxisLabelPosition() == 0) {
            return;
        }
        double_ = this.getAxis().isStagger() ? (n2 % 2 == 0 ? new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() - d2, point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(point2D.getX() - this.getAxisLabelWidth(), point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight())) : new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() - d2, point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        TextGlyph.drawLabel(graphics, string, textAttr, double_);
    }

    private Line2D[] getAxisLines() {
        Line2D[] line2DArray = new Line2D[this.getCategoryCount()];
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            line2DArray[i] = new Line2D.Double(this.getPoint2D(i, this.getCrossValue()), this.getPoint2D(i, this.getMaxValue()));
        }
        return line2DArray;
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        Line2D[] line2DArray = this.getAxisLines();
        for (int i = 0; i < line2DArray.length; ++i) {
            generalPath.append(line2DArray[i], false);
        }
        return generalPath;
    }

    public double getCrossValue() {
        return this.minValue;
    }

    public void setLabelList(List list) {
        this.labelList = list;
    }

    public List getLabelList() {
        return this.labelList;
    }

    public void addCategoryLabel(Object object) {
        this.labelList.add(object);
    }

    protected void drawAxisTitle(Graphics graphics) {
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Attr")) {
                String string3 = xMLableReader.getAttr("minValue");
                if (string3 != null) {
                    this.setMinValue(Double.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("maxValue")) != null) {
                    this.setMaxValue(Double.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("D")) != null) {
                    this.setD(Double.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("radian")) != null) {
                    this.setRadian(Double.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("count")) != null) {
                    this.setCategoryCount(Integer.parseInt(string3));
                }
            } else if (string2.equals("Axis") && (string = xMLableReader.getAttr("class")) != null && string.endsWith(".RadarAxis")) {
                this.radarAxis = (RadarAxis)xMLableReader.readXMLObject(new RadarAxis());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("D", this.getD()).attr("radian", this.getRadian()).attr("count", this.getCategoryCount()).end();
        if (this.getAxis() != null) {
            this.getAxis().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RadarAxisGlyph)) {
            return false;
        }
        RadarAxisGlyph radarAxisGlyph = (RadarAxisGlyph)object;
        if (!super.equals(radarAxisGlyph)) {
            return false;
        }
        if (radarAxisGlyph.getD() != this.getD()) {
            return false;
        }
        if (radarAxisGlyph.getRadian() != this.getRadian()) {
            return false;
        }
        if (radarAxisGlyph.getCategoryCount() != this.getCategoryCount()) {
            return false;
        }
        return Equals.equals(radarAxisGlyph.getAxis(), this.getAxis());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("D", this.D);
        jSONObject.put("radian", this.radian);
        jSONObject.put("categoryCount", this.categoryCount);
        if (this.radarAxis != null) {
            jSONObject.put("radarAxis", this.radarAxis.toJSONObject());
        }
        if (this.labelList != null && this.labelList.size() > 0) {
            jSONObject.put("labelList", this.labelList.toArray());
        }
        return jSONObject;
    }

    public String getJSAxisType() {
        return XML_TAG;
    }

    public void axisExtends(int n, int n2) {
    }
}

