/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.IteratorChain;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.FoldLine;
import com.fr.chart.core.GeneralGlyph;
import com.fr.chart.core.Glyph;
import com.fr.chart.core.glyph.CompositeGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.RadarAxisGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.plot.MarkerGlyph;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class RadarPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 2762582684044348340L;
    public static final String XML_TAG = "RadarPlotGlyph";
    private RadarAxisGlyph radarAxisGlyph;
    private boolean isFilled = false;
    private boolean showLine = true;
    private boolean showMarker = true;

    public void layoutAxisGlyph() {
        this.radarAxisGlyph.init(new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight()));
        this.radarAxisGlyph.calculateAxisLengthUnit();
    }

    public void layoutDataSeriesGlyph() {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            Glyph glyph;
            DataSeries dataSeries = this.getSeries(i);
            GeneralPath generalPath = new GeneralPath();
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                glyph = dataSeries.getDataPoint(j);
                double d = ((DataPoint)glyph).getValue();
                Point2D point2D = this.getRadarAxisGlyph().getPoint2D(j, d);
                if (((DataPoint)glyph).isValueIsNull()) {
                    if (!this.isNullValueBreak()) continue;
                    point2D = this.getRadarAxisGlyph().getOrigin();
                }
                if (j == 0) {
                    generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                } else {
                    generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
                }
                if (this.isShowMarker()) {
                    MarkerGlyph markerGlyph = new MarkerGlyph();
                    ((DataPoint)glyph).setDrawImpl(markerGlyph);
                    markerGlyph.setShape(new Rectangle2D.Double(point2D.getX() - 5.0, point2D.getY() - 5.0, 10.0, 10.0));
                    markerGlyph.dealCondition4Line(this.getSeriesCollection(), i);
                } else {
                    ((DataPoint)glyph).setShape(new Rectangle2D.Double(point2D.getX() - 5.0, point2D.getY() - 5.0, 10.0, 10.0));
                }
                this.dealDataPointLabelBounds((DataPoint)glyph, i);
            }
            generalPath.closePath();
            CompositeGlyph compositeGlyph = new CompositeGlyph();
            if (this.isShowLine()) {
                glyph = new FoldLine(generalPath);
                compositeGlyph.add(glyph);
                ((FoldLine)glyph).getLineStyleInfo().dealCondition(this.getSeriesCollection(), i);
            }
            if (this.isFilled()) {
                glyph = new ShapeGlyph(generalPath);
                ((GeneralGlyph)glyph).getInfo().dealCondition(this.getSeriesCollection(), i);
                compositeGlyph.add(glyph);
            }
            dataSeries.setDrawImpl(compositeGlyph);
        }
    }

    public Iterator selectableChildren() {
        ArrayList<RadarAxisGlyph> arrayList = new ArrayList<RadarAxisGlyph>();
        if (this.radarAxisGlyph != null) {
            arrayList.add(this.radarAxisGlyph);
        }
        return new IteratorChain(new Iterator[]{arrayList.iterator(), super.selectableChildren()});
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.radarAxisGlyph != null) {
            this.radarAxisGlyph.draw(graphics2D);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D);
    }

    public void setRadarAxisGlyph(RadarAxisGlyph radarAxisGlyph) {
        this.radarAxisGlyph = radarAxisGlyph;
    }

    public RadarAxisGlyph getRadarAxisGlyph() {
        return this.radarAxisGlyph;
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setShowLine(boolean bl) {
        this.showLine = bl;
    }

    public boolean isShowLine() {
        return this.showLine;
    }

    public void setShowMarker(boolean bl) {
        this.showMarker = bl;
    }

    public boolean isShowMarker() {
        return this.showMarker;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("showMarker", this.showMarker).attr("showLine", this.showLine).attr("fill", this.isFilled).end();
        if (this.radarAxisGlyph != null) {
            this.radarAxisGlyph.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("showMarker");
                if (string2 != null) {
                    this.showMarker = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("showLine")) != null) {
                    this.showLine = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("fill")) != null) {
                    this.isFilled = Boolean.valueOf(string2);
                }
            } else if (string.equals("RadarAxisGlyph")) {
                this.radarAxisGlyph = (RadarAxisGlyph)xMLableReader.readXMLObject(new RadarAxisGlyph());
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RadarPlotGlyph)) {
            return false;
        }
        RadarPlotGlyph radarPlotGlyph = (RadarPlotGlyph)object;
        if (!super.equals(radarPlotGlyph)) {
            return false;
        }
        if (radarPlotGlyph.showLine != this.showLine) {
            return false;
        }
        if (radarPlotGlyph.showMarker != this.showMarker) {
            return false;
        }
        if (radarPlotGlyph.isFilled != this.isFilled) {
            return false;
        }
        return Equals.equals(radarPlotGlyph.radarAxisGlyph, this.radarAxisGlyph);
    }

    public Object clone() throws CloneNotSupportedException {
        RadarPlotGlyph radarPlotGlyph = (RadarPlotGlyph)super.clone();
        if (this.radarAxisGlyph != null) {
            radarPlotGlyph.radarAxisGlyph = (RadarAxisGlyph)this.radarAxisGlyph.clone();
        }
        return radarPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.radarAxisGlyph != null) {
            jSONObject.put("radarAxisGlyph", this.radarAxisGlyph.toJSONObject());
        }
        jSONObject.put("isFilled", this.isFilled);
        jSONObject.put("showLine", this.showLine);
        jSONObject.put("showMarker", this.showMarker);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

