/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.FRFont;
import com.fr.base.Inter;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.Axis;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.core.RectangleGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.report.cellElement.Formula;
import com.fr.report.script.core.FArray;
import com.fr.util.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Format;

public class RangeAxisGlyph
extends ValueAxisGlyph {
    private static final long serialVersionUID = -3771020074467579784L;
    public static final String XML_TAG = "RangeAxisGlyph";
    private Color leftColor = new Color(215, 214, 214);
    private Color rightColor = new Color(240, 239, 239);

    public RangeAxisGlyph() {
    }

    public RangeAxisGlyph(Axis axis) {
        super(axis);
    }

    public void setLeftColor(Color color) {
        this.leftColor = color;
    }

    public Color getLeftColor() {
        return this.leftColor;
    }

    public void setRightColor(Color color) {
        this.rightColor = color;
    }

    public Color getRightColor() {
        return this.rightColor;
    }

    public void init(Rectangle2D rectangle2D, double d) {
        this.setBounds(rectangle2D);
        this.setOrigin(new Point2D.Double(0.0, rectangle2D.getHeight() / 2.0));
        this.setAxisLength(rectangle2D.getWidth());
        this.setAxisGridLength(d);
    }

    public void drawTicks(Graphics graphics) {
        String string;
        Format format;
        Number number;
        double d;
        Serializable serializable;
        Object object;
        double d2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = new BasicStroke(this.valueAxis.getSecStroke(), 1, 0);
        BasicStroke basicStroke2 = new BasicStroke(this.valueAxis.getMainStroke(), 1, 0);
        if (this.valueAxis.isLog()) {
            double d3;
            if (this.tickLength > 1.0) {
                d2 = this.getCrossValue();
                d3 = Math.log(d2) / Math.log(this.tickLength);
                while (d2 <= this.maxValue) {
                    object = this.getTickLine(d2, this.valueAxis.getTickLength(), this.valueAxis.getTickMarkType());
                    if (this.valueAxis.getTickLength() != 0 && this.valueAxis.getMainStroke() != 0.0f) {
                        this.drawTickLine(graphics, (Line2D)object, basicStroke2);
                    }
                    d2 = Math.exp((d3 += 1.0) * Math.log(this.tickLength));
                }
            }
            if (this.smallTickLength > 1.0) {
                d2 = this.getCrossValue();
                d3 = Math.log(d2) / Math.log(this.smallTickLength);
                while (d2 <= this.maxValue) {
                    if ((d2 - this.getCrossValue()) / this.smallTickLength != 5.0) {
                        object = this.getTickLine(d2, this.valueAxis.getSecTickLength(), this.valueAxis.getSecTickMarkType());
                        if (this.valueAxis.getSecTickLength() != 0 && this.valueAxis.getSecStroke() != 0.0f) {
                            this.drawTickLine(graphics, (Line2D)object, basicStroke);
                        }
                    }
                    d2 = Math.exp((d3 += 1.0) * Math.log(this.smallTickLength));
                }
            }
        } else {
            Line2D line2D;
            for (d2 = (double)((int)this.minValue); d2 <= this.maxValue; d2 += this.tickLength) {
                line2D = this.getTickLine(d2, this.valueAxis.getTickLength(), this.valueAxis.getTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke2);
            }
            for (d2 = (double)((int)this.minValue); d2 <= this.maxValue; d2 += this.smallTickLength) {
                if ((d2 - this.minValue) % this.tickLength == 0.0) continue;
                line2D = this.getTickLine(d2, this.valueAxis.getSecTickLength(), this.valueAxis.getSecTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke);
            }
        }
        d2 = 1.0;
        String string2 = this.valueAxis.getShowUnit();
        if (string2 != null) {
            d2 = ValueAxis.getDivideUnit(string2);
            serializable = new TextGlyph(Inter.getLocText("Unit") + ":" + string2, null);
            object = new Rectangle(0, -45, 100, 20);
            ((RectangleGlyph)serializable).setBounds((RectangularShape)object);
            ((TextGlyph)serializable).draw(graphics2D);
        }
        serializable = new BigDecimal(Double.toString(this.tickLength));
        if (this.valueAxis.isLog()) {
            if (this.tickLength > 1.0) {
                object = new BigDecimal(Double.toString(this.getCrossValue()));
                for (d = this.getCrossValue(); d <= this.maxValue; d *= this.tickLength) {
                    number = ((BigDecimal)object).multiply(new BigDecimal(Double.toString(1.0 / d2)));
                    format = this.getAxis().getFormat();
                    string = "";
                    string = format != null ? format.format(Double.valueOf(((BigDecimal)number).toString())) : ((BigDecimal)number).toString();
                    this.drawLabel(graphics, d, 0.0, string);
                    object = ((BigDecimal)object).multiply((BigDecimal)serializable);
                }
            }
        } else {
            object = new BigDecimal(Double.toString(this.minValue));
            for (d = this.minValue; d <= this.maxValue; d += this.tickLength) {
                number = ((BigDecimal)object).multiply(new BigDecimal(Double.toString(1.0 / d2)));
                format = this.getAxis().getFormat();
                string = "";
                string = format != null ? format.format(Double.valueOf(((BigDecimal)number).toString())) : ((BigDecimal)number).toString();
                this.drawLabel(graphics, d, 0.0, string);
                object = ((BigDecimal)object).add((BigDecimal)serializable);
            }
        }
        if (this.valueAxis.hasAlertValue() && (object = this.valueAxis.getAlertValue()) != null) {
            if (object instanceof Formula) {
                this.drawAlertValueLabel(graphics, (this.maxValue - this.minValue) / 4.0, 0.0, Inter.getLocText("ChartF-Alert"));
            } else if (object instanceof FArray) {
                FArray fArray = (FArray)object;
                for (int i = 0; i < fArray.length(); ++i) {
                    double d4;
                    number = Utils.string2Number(fArray.elementAt(i).toString());
                    if (number == null || !((d4 = number.doubleValue()) >= this.getMinValue()) || !(d4 <= this.getMaxValue())) continue;
                    this.drawAlertValueLabel(graphics, d4, 0.0, fArray.elementAt(i).toString());
                }
            } else {
                double d5;
                Number number2 = Utils.string2Number(object.toString());
                if (number2 != null && (d5 = number2.doubleValue()) >= this.getMinValue() && d5 <= this.getMaxValue()) {
                    this.drawAlertValueLabel(graphics, d5, 0.0, object.toString());
                }
            }
        }
    }

    protected void drawAxisGrid(Graphics graphics) {
        int n;
        int n2;
        Line2D[] line2DArray;
        double d;
        double d2;
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getAxis().getSecondGridStyle() != 0 && this.smallTickLength > 0.0) {
            object2 = graphics2D.getStroke();
            object = graphics2D.getPaint();
            graphics2D.setStroke(GraphHelper.getStroke(this.getAxis().getSecondGridStyle()));
            graphics2D.setPaint(this.getAxis().getSecondGridColor());
            if (this.valueAxis.isLog()) {
                if (this.smallTickLength > 1.0) {
                    d2 = this.getCrossValue();
                    d = Math.log(d2) / Math.log(this.smallTickLength);
                    while (d2 <= this.maxValue) {
                        if ((d2 - this.getCrossValue()) / this.smallTickLength != 5.0) {
                            line2DArray = this.getGridLine(d2);
                            for (n2 = 0; n2 < line2DArray.length; ++n2) {
                                graphics2D.draw(line2DArray[n2]);
                            }
                        }
                        d2 = Math.exp((d += 1.0) * Math.log(this.smallTickLength));
                    }
                }
            } else {
                for (d2 = this.minValue + this.smallTickLength; d2 <= this.maxValue; d2 += this.smallTickLength) {
                    Line2D[] line2DArray2 = this.getGridLine(d2);
                    for (n = 0; n < line2DArray2.length; ++n) {
                        graphics2D.draw(line2DArray2[n]);
                    }
                }
            }
            graphics2D.setPaint((Paint)object);
            graphics2D.setStroke((Stroke)object2);
        }
        if (this.getAxis().getMainGridStyle() != 0 && this.tickLength > 0.0) {
            object2 = graphics2D.getStroke();
            object = graphics2D.getPaint();
            graphics2D.setStroke(GraphHelper.getStroke(this.getAxis().getMainGridStyle()));
            graphics2D.setPaint(this.getAxis().getMainGridColor());
            if (this.valueAxis.isLog()) {
                if (this.tickLength > 1.0) {
                    d2 = this.getCrossValue();
                    d = Math.log(d2) / Math.log(this.tickLength);
                    while (d2 <= this.maxValue) {
                        line2DArray = this.getGridLine(d2);
                        for (n2 = 0; n2 < line2DArray.length; ++n2) {
                            graphics2D.draw(line2DArray[n2]);
                        }
                        d2 = Math.exp((d += 1.0) * Math.log(this.tickLength));
                    }
                }
            } else {
                for (d2 = this.minValue + this.tickLength; d2 <= this.maxValue; d2 += this.tickLength) {
                    Line2D[] line2DArray3 = this.getGridLine(d2);
                    for (n = 0; n < line2DArray3.length; ++n) {
                        graphics2D.draw(line2DArray3[n]);
                    }
                }
            }
            graphics2D.setPaint((Paint)object);
            graphics2D.setStroke((Stroke)object2);
        }
        if (this.valueAxis.hasAlertValue()) {
            object2 = graphics2D.getPaint();
            graphics2D.setPaint(Color.RED);
            object = this.valueAxis.getAlertValue();
            if (object != null) {
                if (object instanceof Formula) {
                    Line2D[] line2DArray4 = this.getGridLine((this.maxValue - this.minValue) / 4.0);
                    for (int i = 0; i < line2DArray4.length; ++i) {
                        graphics2D.draw(line2DArray4[i]);
                    }
                } else if (object instanceof FArray) {
                    FArray fArray = (FArray)object;
                    for (int i = 0; i < fArray.length(); ++i) {
                        double d3;
                        Number number = Utils.string2Number(fArray.elementAt(i).toString());
                        if (number == null || !((d3 = number.doubleValue()) <= this.getMaxValue()) || !(d3 >= this.getMinValue())) continue;
                        Line2D[] line2DArray5 = this.getGridLine(d3);
                        for (int j = 0; j < line2DArray5.length; ++j) {
                            graphics2D.draw(line2DArray5[j]);
                        }
                    }
                } else {
                    double d4;
                    String string = object.toString();
                    if (Utils.string2Number(string) != null && (d4 = Utils.string2Number(string).doubleValue()) <= this.getMaxValue() && d4 >= this.getMinValue()) {
                        Line2D[] line2DArray6 = this.getGridLine(d4);
                        for (int i = 0; i < line2DArray6.length; ++i) {
                            graphics2D.draw(line2DArray6[i]);
                        }
                    }
                }
            }
            graphics2D.setPaint((Paint)object2);
        }
        this.drawAxisGround(graphics2D);
    }

    protected void drawAxisGround(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Point2D.Double double_ = new Point2D.Double(0.0, this.getBounds().getHeight() / 2.0);
        Point2D.Double double_2 = new Point2D.Double(this.axisLength, this.getBounds().getHeight() / 2.0);
        graphics2D.setPaint(new GradientPaint(double_, this.getLeftColor(), double_2, this.getRightColor(), true));
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, this.axisLength, this.getBounds().getHeight()));
        graphics2D.setPaint(paint);
    }

    protected Line2D[] getGridLine(double d) {
        Point2D point2D = this.getPoint2DForSelf(d);
        Line2D.Double double_ = new Line2D.Double(point2D.getX(), point2D.getY() - this.getAxisGridLength() / 2.0, point2D.getX(), point2D.getY() + this.getAxisGridLength() / 2.0);
        return new Line2D[]{double_};
    }

    protected void drawLabel(Graphics graphics, double d, double d2, String string) {
        Point2D point2D = this.getPoint2DForSelf(d + d2);
        TextAttr textAttr = this.getAxis().getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        Rectangle2D.Double double_ = null;
        int n = this.valueAxis.getAxisLabelPosition();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() + this.getBounds().getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        } else if (n == 2 || n == 3) {
            double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() - this.getBounds().getHeight() / 2.0 - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
        }
        TextGlyph.drawLabel(graphics, string, textAttr, double_);
    }

    private void drawAlertValueLabel(Graphics graphics, double d, double d2, String string) {
        Point2D point2D = this.getPoint2DForSelf(d + d2);
        TextAttr textAttr = new TextAttr();
        textAttr.setFRFont(FRFont.getInstance("SimSun", 12, 12, Color.red));
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        Rectangle2D.Double double_ = null;
        int n = this.valueAxis.getAxisLabelPosition();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY() + this.getBounds().getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        } else if (n == 2 || n == 3) {
            double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY() - this.getBounds().getHeight() / 2.0 - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
        }
        TextGlyph.drawLabel(graphics, string, textAttr, double_);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Color")) {
            String string2 = xMLableReader.getAttr("leftColor");
            if (string2 != null) {
                this.setLeftColor(new Color(Integer.parseInt(string2), true));
            }
            if ((string2 = xMLableReader.getAttr("rightColor")) != null) {
                this.setRightColor(new Color(Integer.parseInt(string2), true));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Color");
        if (this.leftColor != null) {
            xMLPrintWriter.attr("leftColor", this.getLeftColor().getRGB());
        }
        if (this.rightColor != null) {
            xMLPrintWriter.attr("rightColor", this.getRightColor().getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RangeAxisGlyph)) {
            return false;
        }
        RangeAxisGlyph rangeAxisGlyph = (RangeAxisGlyph)object;
        if (!super.equals(rangeAxisGlyph)) {
            return false;
        }
        if (rangeAxisGlyph.getLeftColor() != null ? !rangeAxisGlyph.getLeftColor().equals(this.getLeftColor()) : this.getLeftColor() != null) {
            return false;
        }
        return !(rangeAxisGlyph.getRightColor() != null ? !rangeAxisGlyph.getRightColor().equals(this.getRightColor()) : this.getRightColor() != null);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.leftColor != null) {
            jSONObject.put("leftColor", ChartUtils.color2JS(this.leftColor));
        }
        if (this.rightColor != null) {
            jSONObject.put("rightColor", ChartUtils.color2JS(this.rightColor));
        }
        return jSONObject;
    }

    public String getJSAxisType() {
        return XML_TAG;
    }
}

