/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.core.IteratorChain;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.LineGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.RangeAxisGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RangePlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -3079867047500181470L;
    public static final String XML_TAG = "RangePlotGlyph";
    public static final double RectHeight = 50.0;
    private LineGlyph middleLineGlyph;
    private RangeAxisGlyph rangeAxisGlyph = new RangeAxisGlyph();
    private double seriesWidth = 2.0;
    private List rangeAxisGlyphList = new ArrayList();

    public void layoutAxisGlyph() {
        this.rangeAxisGlyphList.clear();
        int n = this.getCategoryCount();
        for (int i = 0; i < n; ++i) {
            double d = this.getBounds().getHeight();
            double d2 = this.getBounds().getWidth();
            double d3 = d / (double)(n * 2) > 50.0 ? 50.0 : d / (double)(n * 2);
            double d4 = (double)(i + 1) * d / (double)(1 + n) - d3 / 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, d4, d2, d3);
            RangeAxisGlyph rangeAxisGlyph = new RangeAxisGlyph();
            try {
                rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyph.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            rangeAxisGlyph.init(double_, d);
            rangeAxisGlyph.calculateAxisLengthUnit();
            this.rangeAxisGlyphList.add(rangeAxisGlyph);
        }
    }

    public void layoutDataSeriesGlyph() {
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            for (int j = 0; j < this.getSeriesSize(); ++j) {
                DataSeries dataSeries = this.getSeries(j);
                DataPoint dataPoint = dataSeries.getDataPoint(i);
                if (dataPoint.isValueIsNull()) continue;
                RangeAxisGlyph rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyphList.get(i);
                Point2D point2D = rangeAxisGlyph.getPoint2D(dataPoint.getValue());
                double d = rangeAxisGlyph.getBounds().getHeight();
                double d2 = rangeAxisGlyph.getBounds().getY();
                Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - this.getSeriesWidth() / 2.0, d2 + point2D.getY() - d / 2.0, this.getSeriesWidth(), d);
                ShapeGlyph shapeGlyph = new ShapeGlyph(double_);
                shapeGlyph.getInfo().dealCondition(this.getSeriesCollection(), j);
                dataPoint.setDrawImpl(shapeGlyph);
                this.dealDataPointLabelBounds(dataPoint, j);
            }
        }
    }

    public Iterator selectableChildren() {
        ArrayList<LineGlyph> arrayList = new ArrayList<LineGlyph>();
        if (this.middleLineGlyph != null) {
            arrayList.add(this.middleLineGlyph);
        }
        if (this.rangeAxisGlyphList != null && this.rangeAxisGlyphList.size() > 0) {
            arrayList.addAll(this.rangeAxisGlyphList);
        }
        return new IteratorChain(new Iterator[]{super.selectableChildren(), arrayList.iterator()});
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.rangeAxisGlyphList != null && this.rangeAxisGlyphList.size() > 0) {
            for (int i = 0; i < this.rangeAxisGlyphList.size(); ++i) {
                ((RangeAxisGlyph)this.rangeAxisGlyphList.get(i)).draw(graphics2D);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D);
    }

    public void setRangeAxisGlyph(RangeAxisGlyph rangeAxisGlyph) {
        this.rangeAxisGlyph = rangeAxisGlyph;
    }

    public RangeAxisGlyph getRangeAxisGlyph() {
        return this.rangeAxisGlyph;
    }

    public void setMiddleLineGlyph(LineGlyph lineGlyph) {
        this.middleLineGlyph = lineGlyph;
    }

    public LineGlyph getMiddleLineGlyph() {
        return this.middleLineGlyph;
    }

    public void setSeriesWidth(double d) {
        this.seriesWidth = d;
    }

    public double getSeriesWidth() {
        return this.seriesWidth;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("seriesWidth", this.getSeriesWidth()).end();
        if (this.rangeAxisGlyph != null) {
            this.rangeAxisGlyph.writeXML(xMLPrintWriter);
        }
        if (this.middleLineGlyph != null) {
            this.middleLineGlyph.writeXML(xMLPrintWriter);
        }
        if (this.rangeAxisGlyphList != null && this.rangeAxisGlyphList.size() > 0) {
            xMLPrintWriter.startTAG("RangeList");
            for (int i = 0; i < this.rangeAxisGlyphList.size(); ++i) {
                ReportXMLUtils.writeXMLable(xMLPrintWriter, (RangeAxisGlyph)this.rangeAxisGlyphList.get(i), "AxisGlyphList");
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("seriesWidth");
                if (string2 != null) {
                    this.setSeriesWidth(Double.valueOf(string2));
                }
            } else if (string.equals("RangeAxisGlyph")) {
                this.rangeAxisGlyph = (RangeAxisGlyph)xMLableReader.readXMLObject(new RangeAxisGlyph());
            } else if (string.equals("LineGlyph")) {
                this.middleLineGlyph = (LineGlyph)xMLableReader.readXMLObject(new LineGlyph());
            } else if (string.equals("RangeList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("AxisGlyphList")) {
                            RangeAxisGlyph rangeAxisGlyph = (RangeAxisGlyph)ReportXMLUtils.readXMLable(xMLableReader);
                            RangePlotGlyph.this.rangeAxisGlyphList.add(rangeAxisGlyph);
                        }
                    }
                });
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RangePlotGlyph)) {
            return false;
        }
        RangePlotGlyph rangePlotGlyph = (RangePlotGlyph)object;
        if (!super.equals(rangePlotGlyph)) {
            return false;
        }
        if (rangePlotGlyph.getSeriesWidth() != this.getSeriesWidth()) {
            return false;
        }
        if (!Equals.equals(rangePlotGlyph.rangeAxisGlyph, this.rangeAxisGlyph)) {
            return false;
        }
        return Equals.equals(rangePlotGlyph.middleLineGlyph, this.middleLineGlyph);
    }

    public Object clone() throws CloneNotSupportedException {
        RangePlotGlyph rangePlotGlyph = (RangePlotGlyph)super.clone();
        if (this.rangeAxisGlyph != null) {
            rangePlotGlyph.rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyph.clone();
        }
        if (this.middleLineGlyph != null) {
            rangePlotGlyph.middleLineGlyph = (LineGlyph)this.middleLineGlyph.clone();
        }
        return rangePlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.rangeAxisGlyph != null) {
            jSONObject.put("rangeAxisGlyph", this.rangeAxisGlyph.toJSONObject());
        }
        jSONObject.put("middleLineGlyph", this.middleLineGlyph.toJSONObject());
        jSONObject.put("seriesWidth", this.getSeriesWidth());
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

