/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.IntervalColorBackground;
import com.fr.base.core.IteratorChain;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.core.LineGlyph;
import com.fr.chart.core.glyph.AxisGlyph;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class StockPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 3316033411141629460L;
    public static final int HIGH_LOW_CLOSE = 0;
    public static final int OPEN_HIGH_LOW_CLOSE = 1;
    public static final int VOLUME_HIGH_LOW_CLOSE = 2;
    public static final int VOLUME_OPEN_HIGH_LOW_CLOSE = 3;
    public static final String XML_TAG = "StockPlotGlyph";
    private int subType = 0;
    private CategoryAxisGlyph categoryAxisGlyph = null;
    private ValueAxisGlyph volumeAxisGlyph = null;
    private ValueAxisGlyph priceAxisGlyph = null;
    private TextGlyph errTextGlyph = null;
    private int highLowLineStyle = 1;
    private Color highLowLineColor = Color.gray;
    private int upBarBorderLineStyle = 1;
    private Color upBarBorderLineColor = Color.red;
    private Background upBarBackground = ColorBackground.getInstance(Color.white);
    private int downBarBorderLineStyle = 1;
    private Color downBarBorderLineColor = Color.green;
    private Background downBarBackground = ColorBackground.getInstance(Color.white);
    private LineGlyph[] highLowGlyph;
    private ShapeGlyph[] openCloseShapeGlyph;

    public void layoutAxisGlyph() {
        Rectangle2D rectangle2D = this.getBounds();
        this.categoryAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.priceAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        if (this.getSubType() == 2 || this.getSubType() == 3) {
            this.volumeAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        }
        this.categoryAxisGlyph.calculateAxisGlyph(rectangle2D);
        this.priceAxisGlyph.calculateAxisGlyph(rectangle2D);
        if (this.getSubType() == 2 || this.getSubType() == 3) {
            this.volumeAxisGlyph.calculateAxisGlyph(rectangle2D);
        }
        this.setBounds(rectangle2D);
        Background background = this.getInfo().getBackground();
        if (background instanceof IntervalColorBackground) {
            IntervalColorBackground intervalColorBackground = (IntervalColorBackground)background;
            intervalColorBackground.setIntervalLength(this.priceAxisGlyph.getUnit() * this.priceAxisGlyph.getUnitLen());
        }
    }

    public void layoutDataSeriesGlyph() {
        Cloneable cloneable;
        DataSeries dataSeries;
        int n;
        Rectangle2D rectangle2D = this.getBounds();
        int n2 = this.getSeriesSize();
        if (this.getErrTextGlyph() != null) {
            TextGlyph textGlyph = this.getErrTextGlyph();
            textGlyph.setBounds(new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight()));
            return;
        }
        Line2D[] line2DArray = new Line2D[this.getSeries(0).getDataPointCount()];
        double d = this.getCategoryAxisGlyph().getUnitLen();
        double d2 = d / 10.0 > 20.0 ? 20.0 : d / 10.0;
        double d3 = d / 4.0 > 80.0 ? 80.0 : d / 4.0;
        for (n = 0; n < n2; ++n) {
            dataSeries = this.getSeries(n);
            int n3 = 0;
            for (int i = 0; i < dataSeries.getDataPointCount(); ++i) {
                if (dataSeries.getDataPoint(i).isValueIsNull()) continue;
                ++n3;
            }
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            n3 = 0;
            int n4 = dataSeries.getDataPointCount();
            for (int i = 0; i < n4; ++i) {
                cloneable = dataSeries.getDataPoint(i);
                if (cloneable.isValueIsNull()) continue;
                double d4 = cloneable.getValue();
                ShapeGlyph shapeGlyph = new ShapeGlyph();
                cloneable.setDrawImpl(shapeGlyph);
                shapeGlyph.getInfo().dealCondition(this.getSeriesCollection(), n);
                Point2D.Double double_ = null;
                if (this.getSubType() == 0) {
                    double_ = new Point2D.Double(this.getCategoryAxisGlyph().getPoint2DCateAxis(i, 0.5).getX(), this.getPriceAxisGlyph().getPoint2D(d4).getY());
                    if (n == 0) {
                        line2DArray[i] = new Line2D.Double(double_, double_);
                    } else if (n == 1) {
                        line2DArray[i].setLine(line2DArray[i].getP1(), double_);
                    }
                    shapeGlyph.setShape(new Rectangle2D.Double(((Point2D)double_).getX() - d2 / 2.0, ((Point2D)double_).getY() - 2.0, d2, 4.0));
                } else if (this.getSubType() == 1) {
                    double_ = new Point2D.Double(this.getCategoryAxisGlyph().getPoint2DCateAxis(i, 0.5).getX(), this.getPriceAxisGlyph().getPoint2D(d4).getY());
                    if (n == 1) {
                        line2DArray[i] = new Line2D.Double(double_, double_);
                    } else if (n == 2) {
                        line2DArray[i].setLine(line2DArray[i].getP1(), double_);
                    }
                    if (n == 0 || n == 3) {
                        // empty if block
                    }
                    shapeGlyph.setShape(new Rectangle2D.Double(((Point2D)double_).getX() - d2 / 2.0, ((Point2D)double_).getY() - 2.0, d2, 4.0));
                } else if (this.getSubType() == 2) {
                    if (n == 0) {
                        double_ = new Point2D.Double(this.getCategoryAxisGlyph().getPoint2DCateAxis(i, 0.5).getX(), this.getVolumeAxisGlyph().getPoint2D(d4).getY());
                        shapeGlyph.setShape(new Rectangle2D.Double(((Point2D)double_).getX() - d3 / 2.0, ((Point2D)double_).getY(), d3, this.getVolumeAxisGlyph().getPoint2D(0.0).getY() - ((Point2D)double_).getY()));
                    } else {
                        double_ = new Point2D.Double(this.getCategoryAxisGlyph().getPoint2DCateAxis(i, 0.5).getX(), this.getPriceAxisGlyph().getPoint2D(d4).getY());
                        if (n == 1) {
                            line2DArray[i] = new Line2D.Double(double_, double_);
                        } else if (n == 2) {
                            line2DArray[i].setLine(line2DArray[i].getP1(), double_);
                        }
                        shapeGlyph.setShape(new Rectangle2D.Double(((Point2D)double_).getX() - d2 / 2.0, ((Point2D)double_).getY() - 2.0, d2, 4.0));
                    }
                } else if (this.getSubType() == 3) {
                    if (n == 0) {
                        double_ = new Point2D.Double(this.getCategoryAxisGlyph().getPoint2DCateAxis(i, 0.5).getX(), this.getVolumeAxisGlyph().getPoint2D(d4).getY());
                        shapeGlyph.setShape(new Rectangle2D.Double(((Point2D)double_).getX() - d3 / 2.0, ((Point2D)double_).getY(), d3, this.getVolumeAxisGlyph().getPoint2D(0.0).getY() - ((Point2D)double_).getY()));
                    } else {
                        double_ = new Point2D.Double(this.getCategoryAxisGlyph().getPoint2DCateAxis(i, 0.5).getX(), this.getPriceAxisGlyph().getPoint2D(d4).getY());
                        if (n == 2) {
                            line2DArray[i] = new Line2D.Double(double_, double_);
                        } else if (n == 3) {
                            line2DArray[i].setLine(line2DArray[i].getP1(), double_);
                        }
                        shapeGlyph.setShape(new Rectangle2D.Double(((Point2D)double_).getX() - d2 / 2.0, ((Point2D)double_).getY() - 2.0, d2, 4.0));
                    }
                }
                this.dealDataPointLabelBounds((DataPoint)cloneable, n);
                dArray[n3] = ((Point2D)double_).getX();
                dArray2[n3] = ((Point2D)double_).getY();
                ++n3;
            }
            this.trendLineFitting(dArray, dArray2, n);
        }
        if (this.getSubType() == 1 || this.getSubType() == 3) {
            this.openCloseShapeGlyph = new ShapeGlyph[this.getSeries(0).getDataPointCount()];
            for (n = 0; n < this.getSeries(0).getDataPointCount(); ++n) {
                ShapeGlyph shapeGlyph;
                double d5;
                dataSeries = this.getSeries(this.getSubType() == 1 ? 0 : 1);
                DataSeries dataSeries2 = this.getSeries(this.getSubType() == 1 ? 3 : 4);
                double d6 = dataSeries.getDataPoint(n).getValue();
                if (d6 < (d5 = dataSeries2.getDataPoint(n).getValue())) {
                    cloneable = new Rectangle2D.Double(this.getCategoryAxisGlyph().getPoint2DCateAxis(n, 0.5).getX() - d2 / 2.0, this.getPriceAxisGlyph().getPoint2D(d5).getY(), d2, this.getPriceAxisGlyph().getPoint2D(d6).getY() - this.getPriceAxisGlyph().getPoint2D(d5).getY());
                    this.openCloseShapeGlyph[n] = shapeGlyph = new ShapeGlyph();
                    shapeGlyph.setBackground(this.upBarBackground);
                    shapeGlyph.setBorderColor(this.upBarBorderLineColor);
                    shapeGlyph.setBorderStyle(this.upBarBorderLineStyle);
                    shapeGlyph.setShape((Shape)((Object)cloneable));
                    continue;
                }
                cloneable = new Rectangle2D.Double(this.getCategoryAxisGlyph().getPoint2DCateAxis(n, 0.5).getX() - d2 / 2.0, this.getPriceAxisGlyph().getPoint2D(d6).getY(), d2, this.getPriceAxisGlyph().getPoint2D(d5).getY() - this.getPriceAxisGlyph().getPoint2D(d6).getY());
                this.openCloseShapeGlyph[n] = shapeGlyph = new ShapeGlyph();
                shapeGlyph.setBackground(this.downBarBackground);
                shapeGlyph.setBorderColor(this.downBarBorderLineColor);
                shapeGlyph.setBorderStyle(this.downBarBorderLineStyle);
                shapeGlyph.setShape((Shape)((Object)cloneable));
            }
        }
        this.highLowGlyph = new LineGlyph[this.getSeries(0).getDataPointCount()];
        for (n = 0; n < this.getSeries(0).getDataPointCount(); ++n) {
            this.highLowGlyph[n] = new LineGlyph();
            this.highLowGlyph[n].setLineColor(this.getHighLowLineColor());
            this.highLowGlyph[n].setLineStyle(this.getHighLowLineStyle());
            this.highLowGlyph[n].setLine(line2DArray[n]);
        }
    }

    public Iterator selectableChildren() {
        ArrayList<AxisGlyph> arrayList = new ArrayList<AxisGlyph>();
        if (this.priceAxisGlyph != null) {
            arrayList.add(this.priceAxisGlyph);
        }
        if (this.categoryAxisGlyph != null) {
            arrayList.add(this.categoryAxisGlyph);
        }
        if (this.volumeAxisGlyph != null) {
            arrayList.add(this.volumeAxisGlyph);
        }
        return new IteratorChain(new Iterator[]{super.selectableChildren(), arrayList.iterator()});
    }

    public void draw(Graphics graphics) {
        int n;
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.categoryAxisGlyph != null) {
            this.categoryAxisGlyph.draw(graphics2D);
        }
        if (this.priceAxisGlyph != null) {
            this.priceAxisGlyph.draw(graphics2D);
        }
        if (this.volumeAxisGlyph != null) {
            this.volumeAxisGlyph.draw(graphics2D);
        }
        if (this.errTextGlyph != null) {
            this.errTextGlyph.draw(graphics2D);
        }
        if (this.openCloseShapeGlyph != null && this.openCloseShapeGlyph.length > 0) {
            for (n = 0; n < this.openCloseShapeGlyph.length; ++n) {
                this.openCloseShapeGlyph[n].draw(graphics2D);
            }
        }
        if (this.highLowGlyph != null && this.highLowGlyph.length > 0) {
            for (n = 0; n < this.highLowGlyph.length; ++n) {
                this.highLowGlyph[n].draw(graphics2D);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D);
    }

    public void setCategoryAxisGlyph(CategoryAxisGlyph categoryAxisGlyph) {
        this.categoryAxisGlyph = categoryAxisGlyph;
    }

    public CategoryAxisGlyph getCategoryAxisGlyph() {
        return this.categoryAxisGlyph;
    }

    public void setVolumeAxisGlyph(ValueAxisGlyph valueAxisGlyph) {
        this.volumeAxisGlyph = valueAxisGlyph;
    }

    public ValueAxisGlyph getVolumeAxisGlyph() {
        return this.volumeAxisGlyph;
    }

    public void setPriceAxisGlyph(ValueAxisGlyph valueAxisGlyph) {
        this.priceAxisGlyph = valueAxisGlyph;
    }

    public ValueAxisGlyph getPriceAxisGlyph() {
        return this.priceAxisGlyph;
    }

    public void setSubType(int n) {
        this.subType = n;
    }

    public int getSubType() {
        return this.subType;
    }

    public void setErrTextGlyph(TextGlyph textGlyph) {
        this.errTextGlyph = textGlyph;
    }

    public TextGlyph getErrTextGlyph() {
        return this.errTextGlyph;
    }

    public void setHighLowGlyph(LineGlyph[] lineGlyphArray) {
        this.highLowGlyph = lineGlyphArray;
    }

    public LineGlyph[] getHighLowGlyph() {
        return this.highLowGlyph;
    }

    public void setOpenCloseShapeGlyph(ShapeGlyph[] shapeGlyphArray) {
        this.openCloseShapeGlyph = shapeGlyphArray;
    }

    public ShapeGlyph[] getOpenCloseShapeGlyph() {
        return this.openCloseShapeGlyph;
    }

    public void setUpBarBorderLineStyle(int n) {
        this.upBarBorderLineStyle = n;
    }

    public int getUpBarBorderLineStyle() {
        return this.upBarBorderLineStyle;
    }

    public void setUpBarBorderLineColor(Color color) {
        this.upBarBorderLineColor = color;
    }

    public Color getUpBarBorderLineColor() {
        return this.upBarBorderLineColor;
    }

    public void setUpBarBackground(Background background) {
        this.upBarBackground = background;
    }

    public Background getUpBarBackground() {
        return this.upBarBackground;
    }

    public void setDownBarBorderLineStyle(int n) {
        this.downBarBorderLineStyle = n;
    }

    public int getDownBarBorderLineStyle() {
        return this.downBarBorderLineStyle;
    }

    public void setDownBarBorderLineColor(Color color) {
        this.downBarBorderLineColor = color;
    }

    public Color getDownBarBorderLineColor() {
        return this.downBarBorderLineColor;
    }

    public void setDownBarBackground(Background background) {
        this.downBarBackground = background;
    }

    public Background getDownBarBackground() {
        return this.downBarBackground;
    }

    public void setHighLowLineStyle(int n) {
        this.highLowLineStyle = n;
    }

    public int getHighLowLineStyle() {
        return this.highLowLineStyle;
    }

    public void setHighLowLineColor(Color color) {
        this.highLowLineColor = color;
    }

    public Color getHighLowLineColor() {
        return this.highLowLineColor;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("subType", this.subType).end();
        if (this.categoryAxisGlyph != null) {
            this.categoryAxisGlyph.writeXML(xMLPrintWriter);
        }
        if (this.priceAxisGlyph != null) {
            xMLPrintWriter.startTAG("Price");
            this.priceAxisGlyph.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.volumeAxisGlyph != null) {
            xMLPrintWriter.startTAG("Volume");
            this.volumeAxisGlyph.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.errTextGlyph != null) {
            this.errTextGlyph.writeXML(xMLPrintWriter);
        }
        if (this.highLowGlyph != null) {
            xMLPrintWriter.startTAG("HighLow");
            for (n = 0; n < this.highLowGlyph.length; ++n) {
                this.highLowGlyph[n].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.openCloseShapeGlyph != null) {
            xMLPrintWriter.startTAG("OpenClose");
            for (n = 0; n < this.openCloseShapeGlyph.length; ++n) {
                this.openCloseShapeGlyph[n].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("subType");
                if (string2 != null) {
                    this.subType = Integer.valueOf(string2);
                }
            } else if (string.equals("Price")) {
                this.priceAxisGlyph = (ValueAxisGlyph)xMLableReader.readXMLObject(new ValueAxisGlyph());
            } else if (string.equals("Volume")) {
                this.volumeAxisGlyph = (ValueAxisGlyph)xMLableReader.readXMLObject(new ValueAxisGlyph());
            } else if (string.equals("TextGlyph")) {
                this.errTextGlyph = (TextGlyph)xMLableReader.readXMLObject(new TextGlyph());
            } else if (string.equals("HighLow")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getTagName();
                        LineGlyph lineGlyph = null;
                        if (string.equals("LineGlyph")) {
                            lineGlyph = (LineGlyph)xMLableReader.readXMLObject(new LineGlyph());
                        }
                        if (StockPlotGlyph.this.highLowGlyph == null) {
                            StockPlotGlyph.access$002(StockPlotGlyph.this, new LineGlyph[]{lineGlyph});
                        } else {
                            LineGlyph[] lineGlyphArray = StockPlotGlyph.this.highLowGlyph;
                            StockPlotGlyph.access$002(StockPlotGlyph.this, new LineGlyph[lineGlyphArray.length + 1]);
                            System.arraycopy(lineGlyphArray, 0, StockPlotGlyph.this.highLowGlyph, 0, lineGlyphArray.length);
                            ((StockPlotGlyph)StockPlotGlyph.this).highLowGlyph[lineGlyphArray.length] = lineGlyph;
                        }
                    }
                });
            } else if (string.equals("OpenClose")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getTagName();
                        ShapeGlyph shapeGlyph = null;
                        if (string.equals("ShapeGlyph")) {
                            shapeGlyph = (ShapeGlyph)xMLableReader.readXMLObject(new ShapeGlyph());
                        }
                        if (StockPlotGlyph.this.openCloseShapeGlyph == null) {
                            StockPlotGlyph.access$102(StockPlotGlyph.this, new ShapeGlyph[]{shapeGlyph});
                        } else {
                            ShapeGlyph[] shapeGlyphArray = StockPlotGlyph.this.openCloseShapeGlyph;
                            StockPlotGlyph.access$102(StockPlotGlyph.this, new ShapeGlyph[shapeGlyphArray.length + 1]);
                            System.arraycopy(shapeGlyphArray, 0, StockPlotGlyph.this.openCloseShapeGlyph, 0, shapeGlyphArray.length);
                            ((StockPlotGlyph)StockPlotGlyph.this).openCloseShapeGlyph[shapeGlyphArray.length] = shapeGlyph;
                        }
                    }
                });
            }
        }
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof StockPlotGlyph)) {
            return false;
        }
        StockPlotGlyph stockPlotGlyph = (StockPlotGlyph)object;
        if (!super.equals(stockPlotGlyph)) {
            return false;
        }
        if (stockPlotGlyph.subType != this.subType) {
            return false;
        }
        if (!Equals.equals(stockPlotGlyph.categoryAxisGlyph, this.categoryAxisGlyph)) {
            return false;
        }
        if (!Equals.equals(stockPlotGlyph.priceAxisGlyph, this.priceAxisGlyph)) {
            return false;
        }
        if (!Equals.equals(stockPlotGlyph.volumeAxisGlyph, this.volumeAxisGlyph)) {
            return false;
        }
        if (!Equals.equals(stockPlotGlyph.errTextGlyph, this.errTextGlyph)) {
            return false;
        }
        if (stockPlotGlyph.highLowGlyph.length != this.highLowGlyph.length) {
            return false;
        }
        for (n = 0; n < stockPlotGlyph.highLowGlyph.length; ++n) {
            if (Equals.equals(stockPlotGlyph.highLowGlyph[n], this.highLowGlyph[n])) continue;
            return false;
        }
        if (stockPlotGlyph.openCloseShapeGlyph.length != this.openCloseShapeGlyph.length) {
            return false;
        }
        for (n = 0; n < stockPlotGlyph.openCloseShapeGlyph.length; ++n) {
            if (Equals.equals(stockPlotGlyph.openCloseShapeGlyph[n], this.openCloseShapeGlyph[n])) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        StockPlotGlyph stockPlotGlyph = (StockPlotGlyph)super.clone();
        if (this.categoryAxisGlyph != null) {
            stockPlotGlyph.categoryAxisGlyph = (CategoryAxisGlyph)this.categoryAxisGlyph.clone();
        }
        if (this.priceAxisGlyph != null) {
            stockPlotGlyph.priceAxisGlyph = (ValueAxisGlyph)this.priceAxisGlyph.clone();
        }
        if (this.volumeAxisGlyph != null) {
            stockPlotGlyph.volumeAxisGlyph = (ValueAxisGlyph)this.volumeAxisGlyph.clone();
        }
        if (this.errTextGlyph != null) {
            stockPlotGlyph.errTextGlyph = (TextGlyph)this.errTextGlyph.clone();
        }
        if (this.highLowGlyph != null && this.highLowGlyph.length > 0) {
            stockPlotGlyph.highLowGlyph = new LineGlyph[this.highLowGlyph.length];
            for (n = 0; n < this.highLowGlyph.length; ++n) {
                stockPlotGlyph.highLowGlyph[n] = (LineGlyph)this.highLowGlyph[n].clone();
            }
        }
        if (this.openCloseShapeGlyph != null && this.openCloseShapeGlyph.length > 0) {
            stockPlotGlyph.openCloseShapeGlyph = new ShapeGlyph[this.openCloseShapeGlyph.length];
            for (n = 0; n < this.openCloseShapeGlyph.length; ++n) {
                stockPlotGlyph.openCloseShapeGlyph[n] = (ShapeGlyph)this.openCloseShapeGlyph[n].clone();
            }
        }
        return stockPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("subType", this.subType);
        jSONObject.put("upBarBorderLineStyle", this.upBarBorderLineStyle);
        jSONObject.put("upBarBorderLineColor", ChartUtils.color2JS(this.upBarBorderLineColor));
        jSONObject.put("upBarBackground", this.upBarBackground.toJSONObject());
        jSONObject.put("downBarBorderLineStyle", this.downBarBorderLineStyle);
        jSONObject.put("downBarBorderLineColor", ChartUtils.color2JS(this.downBarBorderLineColor));
        jSONObject.put("downBarBackground", this.downBarBackground.toJSONObject());
        jSONObject.put("highLowLineStyle", this.highLowLineStyle);
        jSONObject.put("highLowLineColor", ChartUtils.color2JS(this.highLowLineColor));
        if (this.categoryAxisGlyph instanceof DateAxisGlyph) {
            jSONObject.put("dateAxisGlyph", this.categoryAxisGlyph.toJSONObject());
        } else if (this.categoryAxisGlyph instanceof CategoryAxisGlyph) {
            jSONObject.put("categoryAxisGlyph", this.categoryAxisGlyph.toJSONObject());
        }
        if (this.priceAxisGlyph != null) {
            jSONObject.put("priceAxisGlyph", this.priceAxisGlyph.toJSONObject());
        }
        if (this.volumeAxisGlyph != null) {
            jSONObject.put("volumeAxisGlyph", this.volumeAxisGlyph.toJSONObject());
        }
        if (this.errTextGlyph != null) {
            jSONObject.put("errTextGlyph", this.errTextGlyph.toJSONObject());
        }
        if (this.highLowGlyph != null) {
            jSONObject.put("highLowGlyph", this.highLowGlyph);
        }
        if (this.openCloseShapeGlyph != null) {
            jSONObject.put("openCloseShapeGlyph", this.openCloseShapeGlyph);
        }
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }

    static /* synthetic */ LineGlyph[] access$002(StockPlotGlyph stockPlotGlyph, LineGlyph[] lineGlyphArray) {
        stockPlotGlyph.highLowGlyph = lineGlyphArray;
        return lineGlyphArray;
    }

    static /* synthetic */ ShapeGlyph[] access$102(StockPlotGlyph stockPlotGlyph, ShapeGlyph[] shapeGlyphArray) {
        stockPlotGlyph.openCloseShapeGlyph = shapeGlyphArray;
        return shapeGlyphArray;
    }
}

