/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.FRFont;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.core.BaseCoreConstants;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.GlyphCondition;
import com.fr.chart.axis.SeriesAttrAlpha;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.RectangleGlyph;
import com.fr.chart.plot.SeriesCollection;
import com.fr.report.core.PaintUtils;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;

public class TextGlyph
extends RectangleGlyph
implements GlyphCondition {
    private static final long serialVersionUID = -3597929707303851528L;
    public static final String XML_TAG = "TextGlyph";
    private String text;
    private TextAttr textAttr;

    public TextGlyph() {
    }

    public TextGlyph(String string, TextAttr textAttr) {
        this.text = string;
        this.textAttr = textAttr;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public Iterator selectableChildren() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (this.getText() != null && this.getBounds() != null) {
            TextGlyph.drawLabel(graphics2D, this.getText(), this.getTextAttr(), this.getBounds());
        }
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    public static void drawLabel(Graphics graphics, String string, TextAttr textAttr, Rectangle2D rectangle2D) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (StringUtils.isEmpty(string)) {
            return;
        }
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        Style style = textAttr.getFRFont() != null ? Style.getInstance(textAttr.getFRFont()) : Style.getInstance();
        style = style.deriveTextDirection(textAttr.getDirection());
        style = style.deriveRotation(textAttr.getRotation());
        style = style.deriveHorizontalAlignment(textAttr.getHorizontalAlignment());
        style = style.deriveVerticalAlignment(textAttr.getVerticalAlignment());
        style = style.deriveVerticalText(textAttr.getAlignText());
        PaintUtils.paintContent(graphics2D, (Object)string, style, (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight());
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
    }

    public Dimension2D preferredDimension() {
        return TextGlyph.calculateTextDimension(this.text, this.textAttr);
    }

    public static Dimension2D calculateTextDimension(String string, TextAttr textAttr) {
        FRFont fRFont;
        if (StringUtils.isEmpty(string)) {
            return new Dimension(0, 0);
        }
        FRFont fRFont2 = fRFont = textAttr == null ? null : textAttr.getFRFont();
        if (fRFont == null) {
            fRFont = FRFont.getInstance();
        }
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GraphHelper.stringDimension(string, fRFont, textAttr.getRotation(), BaseCoreConstants.DEFAULT_FRC);
        dimension2D.setSize(dimension2D.getWidth() + 2.0, dimension2D.getHeight() + 2.0);
        if (textAttr.getAlignText() == 1) {
            dimension2D.setSize(dimension2D.getHeight(), dimension2D.getHeight() * ((double)string.length() + 0.2));
        }
        return dimension2D;
    }

    public void dealCondition(SeriesCollection seriesCollection, int n) {
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)seriesCollection.getSeriesCondition(new SeriesAttrAlpha(), n);
        this.setAlpha(seriesAttrAlpha.getAlpha());
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextGlyph)) {
            return false;
        }
        TextGlyph textGlyph = (TextGlyph)object;
        if (!super.equals(textGlyph)) {
            return false;
        }
        if (!Equals.equals(textGlyph.getText(), this.getText())) {
            return false;
        }
        return Equals.equals(textGlyph.getTextAttr(), this.getTextAttr());
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Text") && (string = xMLableReader.getAttr("text")) != null) {
                this.setText(string);
            }
            if (string2.equals("TextAttr")) {
                this.textAttr = (TextAttr)xMLableReader.readXMLObject(new TextAttr());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Text").attr("text", this.getText()).end();
        if (this.getTextAttr() != null) {
            this.textAttr.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("text", this.text);
        if (this.textAttr != null) {
            jSONObject.put("textAttr", this.textAttr.toJSONObject());
        }
        return jSONObject;
    }
}

