/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.FRFont;
import com.fr.base.Inter;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.Axis;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.AxisGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.report.cellElement.Formula;
import com.fr.report.script.core.FArray;
import com.fr.util.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.math.BigDecimal;
import java.text.Format;

public class ValueAxisGlyph
extends AxisGlyph {
    private static final long serialVersionUID = 2649354991884111487L;
    public static final String XML_TAG = "ValueAxisGlyph";
    protected ValueAxis valueAxis;

    public ValueAxisGlyph() {
    }

    public ValueAxisGlyph(Axis axis) {
        super(axis);
    }

    public void calculateAxisLengthUnit() {
        if (this.valueAxis.isLog()) {
            this.unitLength = this.axisLength / (Math.log(this.maxValue) / Math.log(this.tickLength) - Math.log(this.minValue) / Math.log(this.tickLength));
        } else if (this.maxValue - this.minValue > 0.0) {
            this.unitLength = this.axisLength / (this.maxValue - this.minValue);
        }
    }

    public void axisExtends(int n, int n2) {
        this.setMaxValue(this.getMaxValue() + (double)n);
        this.setMinValue(this.getMinValue() - (double)n2);
        this.calculateAxisLengthUnit();
    }

    public void initMinMaxValue(double d, double d2) {
        if (this.valueAxis.isCustomMinValue()) {
            d = this.minValue = this.valueAxis.getMinValue();
        } else {
            this.minValue = d;
        }
        if (this.valueAxis.isCustomMaxValue()) {
            d2 = this.maxValue = this.valueAxis.getMaxValue();
        }
        if (this.valueAxis.isLog()) {
            this.tickLength = this.valueAxis.isCustomIncrement() ? ((ValueAxis)this.getAxis()).getIncrement() : 10.0;
            this.smallTickLength = this.tickLength / 5.0;
        } else if (d2 - d > 0.0) {
            if (this.valueAxis.isCustomIncrement()) {
                this.tickLength = ((ValueAxis)this.getAxis()).getIncrement();
                if (this.valueAxis.isPercentage()) {
                    this.tickLength /= 100.0;
                }
            } else {
                this.tickLength = Axis.calculateIncrement(this.minValue, d2);
            }
            this.smallTickLength = this.tickLength / 5.0;
        }
        if (d2 > d && (d2 - d) % this.tickLength != 0.0) {
            d2 = d2 + this.tickLength - (d2 - d) % this.tickLength;
        }
        if (!this.valueAxis.isCustomMaxValue()) {
            this.maxValue = d2 + this.tickLength;
        }
        if (!this.valueAxis.isCustomMinValue() && this.minValue < 0.0) {
            this.minValue -= this.tickLength;
        }
        if (this.minValue >= this.maxValue) {
            this.maxValue = this.minValue + 10.0;
        }
        if (this.valueAxis.isLog()) {
            this.minValue = Math.max(1.0, this.minValue);
        }
    }

    public Axis getAxis() {
        return this.valueAxis;
    }

    public void setAxis(Axis axis) {
        if (!(axis instanceof ValueAxis)) {
            throw new IllegalArgumentException();
        }
        this.valueAxis = (ValueAxis)axis;
    }

    public double getCrossValue() {
        if (this.valueAxis.isCustomCrossValue()) {
            return this.valueAxis.getCrossValue();
        }
        return this.minValue;
    }

    public String value2String(double d) {
        Format format = this.getAxis().getFormat();
        String string = null;
        string = format != null ? format.format(Double.valueOf(Utils.doubleToString(d))) : String.valueOf(d);
        return string;
    }

    public Point2D getPoint2D(double d) {
        if (this.valueAxis.isLog() && this.getCrossValue() > 0.0) {
            if (d <= 1.0E-10) {
                d = this.getCrossValue();
            }
            d = (Math.log(d) - Math.log(this.getCrossValue())) / Math.log(this.tickLength);
        } else {
            d -= this.getCrossValue();
        }
        if (this.getAxis().getPosition() == 2 || this.getAxis().getPosition() == 4) {
            return new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() - this.unitLength * d);
        }
        return new Point2D.Double(this.originPoint.getX() + this.unitLength * d, this.originPoint.getY());
    }

    protected void drawAxisGrid(Graphics graphics) {
        int n;
        int n2;
        Line2D[] line2DArray;
        double d;
        double d2;
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getAxis().getSecondGridStyle() != 0 && this.smallTickLength > 0.0) {
            object2 = graphics2D.getStroke();
            object = graphics2D.getPaint();
            graphics2D.setStroke(GraphHelper.getStroke(this.getAxis().getSecondGridStyle()));
            graphics2D.setPaint(this.getAxis().getSecondGridColor());
            if (this.valueAxis.isLog()) {
                if (this.smallTickLength > 1.0) {
                    d2 = this.getCrossValue();
                    d = Math.log(d2) / Math.log(this.smallTickLength);
                    while (d2 <= this.maxValue) {
                        if ((d2 - this.getCrossValue()) / this.smallTickLength != 5.0) {
                            line2DArray = this.getGridLine(d2);
                            for (n2 = 0; n2 < line2DArray.length; ++n2) {
                                graphics2D.draw(line2DArray[n2]);
                            }
                        }
                        d2 = Math.exp((d += 1.0) * Math.log(this.smallTickLength));
                    }
                }
            } else {
                for (d2 = this.minValue + this.smallTickLength; d2 <= this.maxValue; d2 += this.smallTickLength) {
                    Line2D[] line2DArray2 = this.getGridLine(d2);
                    for (n = 0; n < line2DArray2.length; ++n) {
                        graphics2D.draw(line2DArray2[n]);
                    }
                }
            }
            graphics2D.setPaint((Paint)object);
            graphics2D.setStroke((Stroke)object2);
        }
        if (this.getAxis().getMainGridStyle() != 0 && this.tickLength > 0.0) {
            object2 = graphics2D.getStroke();
            object = graphics2D.getPaint();
            graphics2D.setStroke(GraphHelper.getStroke(this.getAxis().getMainGridStyle()));
            graphics2D.setPaint(this.getAxis().getMainGridColor());
            if (this.valueAxis.isLog()) {
                if (this.tickLength > 1.0) {
                    d2 = this.getCrossValue();
                    d = Math.log(d2) / Math.log(this.tickLength);
                    while (d2 <= this.maxValue) {
                        line2DArray = this.getGridLine(d2);
                        for (n2 = 0; n2 < line2DArray.length; ++n2) {
                            graphics2D.draw(line2DArray[n2]);
                        }
                        d2 = Math.exp((d += 1.0) * Math.log(this.tickLength));
                    }
                }
            } else {
                for (d2 = this.minValue + this.tickLength; d2 <= this.maxValue; d2 += this.tickLength) {
                    Line2D[] line2DArray3 = this.getGridLine(d2);
                    for (n = 0; n < line2DArray3.length; ++n) {
                        graphics2D.draw(line2DArray3[n]);
                    }
                }
            }
            graphics2D.setPaint((Paint)object);
            graphics2D.setStroke((Stroke)object2);
        }
        if (this.valueAxis.hasAlertValue()) {
            object2 = graphics2D.getPaint();
            graphics2D.setPaint(Color.RED);
            object = this.valueAxis.getAlertValue();
            if (object != null) {
                if (object instanceof Formula) {
                    Line2D[] line2DArray4 = this.getGridLine((this.maxValue - this.minValue) / 4.0);
                    for (int i = 0; i < line2DArray4.length; ++i) {
                        graphics2D.draw(line2DArray4[i]);
                    }
                } else if (object instanceof FArray) {
                    FArray fArray = (FArray)object;
                    for (int i = 0; i < fArray.length(); ++i) {
                        double d3;
                        Number number = Utils.string2Number(fArray.elementAt(i).toString());
                        if (number == null || !((d3 = number.doubleValue()) <= this.getMaxValue()) || !(d3 >= this.getMinValue())) continue;
                        Line2D[] line2DArray5 = this.getGridLine(d3);
                        for (int j = 0; j < line2DArray5.length; ++j) {
                            graphics2D.draw(line2DArray5[j]);
                        }
                    }
                } else {
                    double d4;
                    String string = object.toString();
                    if (Utils.string2Number(string) != null && (d4 = Utils.string2Number(string).doubleValue()) <= this.getMaxValue() && d4 >= this.getMinValue()) {
                        Line2D[] line2DArray6 = this.getGridLine(d4);
                        for (int i = 0; i < line2DArray6.length; ++i) {
                            graphics2D.draw(line2DArray6[i]);
                        }
                    }
                }
            }
            graphics2D.setPaint((Paint)object2);
        }
    }

    protected void drawAxisLine(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.minValue == this.maxValue) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        Color color = this.getAxis().getLineColor();
        int n = this.getAxis().getLineStyle();
        if (color != null && n != 0 && this.getAxis().isAxisShow()) {
            graphics2D.setPaint(color);
            Line2D.Double double_ = new Line2D.Double(this.getPoint2DForSelf(this.minValue), this.getPoint2DForSelf(this.maxValue));
            GraphHelper.draw(graphics2D, double_, n);
            this.drawArrow(graphics2D, this.getPoint2DForSelf(this.minValue), this.getPoint2DForSelf(this.maxValue));
        }
        this.drawTicks(graphics2D);
        graphics2D.setPaint(paint);
    }

    public void drawTicks(Graphics graphics) {
        Number number;
        double d;
        Object object;
        Shape shape;
        double d2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = new BasicStroke(this.valueAxis.getMainStroke(), 1, 0);
        BasicStroke basicStroke2 = new BasicStroke(this.valueAxis.getSecStroke(), 1, 0);
        if (this.getAxis().isAxisShow()) {
            if (this.valueAxis.isLog()) {
                double d3;
                if (this.tickLength > 1.0) {
                    d2 = this.getCrossValue();
                    d3 = Math.log(d2) / Math.log(this.tickLength);
                    while (d2 <= this.maxValue) {
                        shape = this.getTickLine(d2, this.valueAxis.getTickLength(), this.valueAxis.getTickMarkType());
                        if (this.valueAxis.getTickLength() != 0 && this.valueAxis.getMainStroke() != 0.0f) {
                            this.drawTickLine(graphics, (Line2D)shape, basicStroke);
                        }
                        d2 = Math.exp((d3 += 1.0) * Math.log(this.tickLength));
                    }
                }
                if (this.smallTickLength > 1.0) {
                    d2 = this.getCrossValue();
                    d3 = Math.log(d2) / Math.log(this.smallTickLength);
                    while (d2 <= this.maxValue) {
                        if ((d2 - this.getCrossValue()) / this.smallTickLength != 5.0) {
                            shape = this.getTickLine(d2, this.valueAxis.getSecTickLength(), this.valueAxis.getSecTickMarkType());
                            if (this.valueAxis.getSecTickLength() != 0 && this.valueAxis.getSecStroke() != 0.0f) {
                                this.drawTickLine(graphics, (Line2D)shape, basicStroke2);
                            }
                        }
                        d2 = Math.exp((d3 += 1.0) * Math.log(this.smallTickLength));
                    }
                }
            } else if (this.maxValue > this.minValue && this.tickLength > 0.0 && this.smallTickLength > 0.0) {
                Line2D line2D;
                for (d2 = this.minValue + this.tickLength; d2 <= this.maxValue; d2 += this.tickLength) {
                    line2D = this.getTickLine(d2, this.valueAxis.getTickLength(), this.valueAxis.getTickMarkType());
                    this.drawTickLine(graphics, line2D, basicStroke);
                }
                for (d2 = this.minValue + this.smallTickLength; d2 <= this.maxValue; d2 += this.smallTickLength) {
                    if ((d2 - this.minValue) / this.smallTickLength == 5.0) continue;
                    line2D = this.getTickLine(d2, this.valueAxis.getSecTickLength(), this.valueAxis.getSecTickMarkType());
                    this.drawTickLine(graphics, line2D, basicStroke2);
                }
            }
        }
        d2 = 1.0;
        String string = this.valueAxis.getShowUnit();
        if (string != null) {
            d2 = ValueAxis.getDivideUnit(string);
            TextGlyph textGlyph = new TextGlyph(Inter.getLocText("Unit") + ":" + string, null);
            shape = null;
            if (this.getAxis().getPosition() == 1) {
                shape = new Rectangle(0, -30, 100, 20);
            } else if (this.getAxis().getPosition() == 2) {
                shape = new Rectangle(-20, -25, 100, 20);
            } else if (this.getAxis().getPosition() == 3) {
                shape = new Rectangle(0, (int)this.getAxisLabelWidth(), 100, 20);
            } else if (this.getAxis().getPosition() == 4) {
                shape = new Rectangle(15, -25, 100, 20);
            }
            textGlyph.setBounds((RectangularShape)shape);
            textGlyph.draw(graphics2D);
        }
        int n = 0;
        int n2 = 0;
        n2 = this.getAxis().getLabelNumber() == -1 || this.getAxis().getLabelNumber() == 0 ? 1 : this.getAxis().getLabelNumber();
        BigDecimal bigDecimal = new BigDecimal(Double.toString(this.tickLength));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(n2));
        if (this.valueAxis.isLog()) {
            if (this.tickLength > 1.0) {
                object = new BigDecimal(Double.toString(this.getCrossValue()));
                d = this.getCrossValue();
                while (d <= this.maxValue) {
                    number = ((BigDecimal)object).multiply(new BigDecimal(Double.toString(1.0 / d2)));
                    if (this.getAxis().isStagger()) {
                        this.drawBGLabel(graphics, d, 0.0, this.value2String(((BigDecimal)number).doubleValue()), n);
                    } else {
                        this.drawLabel(graphics, d, 0.0, this.value2String(((BigDecimal)number).doubleValue()));
                    }
                    ++n;
                    object = ((BigDecimal)object).multiply(bigDecimal.multiply(bigDecimal2));
                    d = d * this.tickLength * (double)n2;
                }
            }
        } else if (this.maxValue > this.minValue && this.tickLength > 0.0 && this.smallTickLength > 0.0) {
            object = new BigDecimal(Double.toString(this.minValue));
            for (d = this.minValue; d <= this.maxValue; d += this.tickLength * (double)n2) {
                number = ((BigDecimal)object).multiply(new BigDecimal(Double.toString(1.0 / d2)));
                if (this.getAxis().isStagger()) {
                    this.drawBGLabel(graphics, d, 0.0, this.value2String(((BigDecimal)number).doubleValue()), n);
                } else {
                    this.drawLabel(graphics, d, 0.0, this.value2String(((BigDecimal)number).doubleValue()));
                }
                ++n;
                object = ((BigDecimal)object).add(bigDecimal.multiply(bigDecimal2));
            }
        }
        if (this.valueAxis.hasAlertValue() && (object = this.valueAxis.getAlertValue()) != null) {
            if (object instanceof Formula) {
                this.drawAlertValueLabel(graphics, (this.maxValue - this.minValue) / 4.0, 0.0, Inter.getLocText("ChartF-Alert"));
            } else if (object instanceof FArray) {
                FArray fArray = (FArray)object;
                for (int i = 0; i < fArray.length(); ++i) {
                    double d4;
                    number = Utils.string2Number(fArray.elementAt(i).toString());
                    if (number == null || !((d4 = number.doubleValue()) >= this.getMinValue()) || !(d4 <= this.getMaxValue())) continue;
                    this.drawAlertValueLabel(graphics, d4, 0.0, fArray.elementAt(i).toString());
                }
            } else {
                double d5;
                Number number2 = Utils.string2Number(object.toString());
                if (number2 != null && (d5 = number2.doubleValue()) >= this.getMinValue() && d5 <= this.getMaxValue()) {
                    this.drawAlertValueLabel(graphics, d5, 0.0, object.toString());
                }
            }
        }
    }

    private void drawAlertValueLabel(Graphics graphics, double d, double d2, String string) {
        Color color = graphics.getColor();
        Point2D point2D = this.getPoint2DForSelf(d + d2);
        TextAttr textAttr = new TextAttr();
        textAttr.setFRFont(FRFont.getInstance("SimSun", 12, 12, Color.red));
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        Rectangle2D.Double double_ = null;
        int n = this.getAxis().getPosition();
        double_ = n == 2 ? new Rectangle2D.Double(point2D.getX() + this.getAxisGridLength(), point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight()) : (n == 1 ? new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() + this.getAxisGridLength() + dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight()) : (n == 4 ? new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() - this.getAxisGridLength(), point2D.getY() - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() - this.getAxisGridLength() - dimension2D.getHeight() - 4.0, dimension2D.getWidth(), dimension2D.getHeight())));
        TextGlyph.drawLabel(graphics, string, textAttr, double_);
        graphics.setColor(color);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueAxisGlyph)) {
            return false;
        }
        ValueAxisGlyph valueAxisGlyph = (ValueAxisGlyph)object;
        if (!super.equals(valueAxisGlyph)) {
            return false;
        }
        return Equals.equals(valueAxisGlyph.getAxis(), this.getAxis());
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.valueAxis != null) {
            this.valueAxis.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Attr")) {
                String string3 = xMLableReader.getAttr("minValue");
                if (string3 != null) {
                    this.setMinValue(Double.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("maxValue")) != null) {
                    this.setMaxValue(Double.valueOf(string3));
                }
            } else if (string2.equals("ValueAxis") && (string = xMLableReader.getAttr("class")) != null && string.endsWith(".ValueAxis")) {
                this.valueAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
            }
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.valueAxis != null) {
            jSONObject.put("valueAxis", this.valueAxis.toJSONObject());
        }
        return jSONObject;
    }

    public String getJSAxisType() {
        return XML_TAG;
    }
}

