/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.core.glyph;

import com.fr.base.background.Background;
import com.fr.base.background.IntervalColorBackground;
import com.fr.base.core.IteratorChain;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.FoldLine;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.plot.MarkerGlyph;
import com.fr.util.Utils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class XYScatterPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 64495889773358205L;
    public static final String XML_TAG = "XYScatterPlotGlyph";
    private ValueAxisGlyph xAxisGlyph;
    private ValueAxisGlyph yAxisGlyph;
    private boolean showLine = true;
    private boolean showMarker = true;

    public void layoutAxisGlyph() {
        Rectangle2D rectangle2D = this.getBounds();
        this.xAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.yAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D);
        this.xAxisGlyph.calculateAxisGlyph(rectangle2D);
        this.yAxisGlyph.calculateAxisGlyph(rectangle2D);
        this.setBounds(rectangle2D);
        Background background = this.getInfo().getBackground();
        if (background instanceof IntervalColorBackground) {
            IntervalColorBackground intervalColorBackground = (IntervalColorBackground)background;
            intervalColorBackground.setIntervalLength(this.yAxisGlyph.getUnit() * this.yAxisGlyph.getUnitLen());
        }
    }

    public void layoutDataSeriesGlyph() {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n2 = 0;
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                if (dataSeries.getDataPoint(j).isValueIsNull()) continue;
                ++n2;
            }
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            n2 = 0;
            GeneralPath generalPath = new GeneralPath();
            boolean bl = true;
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (dataPoint.isValueIsNull()) {
                    if (!this.isNullValueBreak()) continue;
                    bl = true;
                    continue;
                }
                Number number = Utils.string2Number(dataPoint.getCategoryName());
                double d = number == null ? this.xAxisGlyph.getPoint2D(0.0).getX() : this.xAxisGlyph.getPoint2D(number.doubleValue()).getX();
                double d2 = dataPoint.getValue();
                double d3 = this.yAxisGlyph.getBounds().getY() + this.yAxisGlyph.getPoint2D(d2).getY();
                if (bl) {
                    generalPath.moveTo((float)d, (float)d3);
                    bl = false;
                } else {
                    generalPath.lineTo((float)d, (float)d3);
                }
                dArray[n2] = d;
                dArray2[n2] = d3;
                ++n2;
                if (this.showMarker) {
                    MarkerGlyph markerGlyph = new MarkerGlyph();
                    markerGlyph.dealCondition4Line(this.getSeriesCollection(), i);
                    markerGlyph.setShape(new Rectangle2D.Double(d - 5.0, d3 - 5.0, 10.0, 10.0));
                    dataPoint.setDrawImpl(markerGlyph);
                } else {
                    dataPoint.setShape(new Rectangle2D.Double(d - 5.0, d3 - 5.0, 10.0, 10.0));
                }
                this.dealDataPointLabelBounds(dataPoint, i);
            }
            if (this.showLine) {
                FoldLine foldLine = new FoldLine();
                dataSeries.setDrawImpl(foldLine);
                foldLine.setGeneralPath(generalPath);
                foldLine.getLineStyleInfo().dealCondition(this.getSeriesCollection(), i);
            }
            this.trendLineFitting(dArray, dArray2, i);
        }
    }

    public Iterator selectableChildren() {
        ArrayList<ValueAxisGlyph> arrayList = new ArrayList<ValueAxisGlyph>();
        if (this.xAxisGlyph != null) {
            arrayList.add(this.xAxisGlyph);
        }
        if (this.yAxisGlyph != null) {
            arrayList.add(this.yAxisGlyph);
        }
        return new IteratorChain(new Iterator[]{super.selectableChildren(), arrayList.iterator()});
    }

    public void draw(Graphics graphics) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.xAxisGlyph != null) {
            this.xAxisGlyph.draw(graphics2D);
        }
        if (this.yAxisGlyph != null) {
            this.yAxisGlyph.draw(graphics2D);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D);
    }

    public void setXAxisGlyph(ValueAxisGlyph valueAxisGlyph) {
        this.xAxisGlyph = valueAxisGlyph;
    }

    public ValueAxisGlyph getXAxisGlyph() {
        return this.xAxisGlyph;
    }

    public void setYAxisGlyph(ValueAxisGlyph valueAxisGlyph) {
        this.yAxisGlyph = valueAxisGlyph;
    }

    public ValueAxisGlyph getYAxisGlyph() {
        return this.yAxisGlyph;
    }

    public void setShowLine(boolean bl) {
        this.showLine = bl;
    }

    public boolean isShowLine() {
        return this.showLine;
    }

    public void setShowMarker(boolean bl) {
        this.showMarker = bl;
    }

    public boolean isShowMarker() {
        return this.showMarker;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.xAxisGlyph != null) {
            xMLPrintWriter.startTAG("XAxisGlyph");
            this.xAxisGlyph.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.yAxisGlyph != null) {
            xMLPrintWriter.startTAG("YAxisGlyph");
            this.yAxisGlyph.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XAxisGlyph")) {
                this.xAxisGlyph = (ValueAxisGlyph)xMLableReader.readXMLObject(new ValueAxisGlyph());
            } else if (string.equals("YAxisGlyph")) {
                this.yAxisGlyph = (ValueAxisGlyph)xMLableReader.readXMLObject(new ValueAxisGlyph());
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof XYScatterPlotGlyph)) {
            return false;
        }
        XYScatterPlotGlyph xYScatterPlotGlyph = (XYScatterPlotGlyph)object;
        if (!super.equals(xYScatterPlotGlyph)) {
            return false;
        }
        if (!Equals.equals(xYScatterPlotGlyph.xAxisGlyph, this.xAxisGlyph)) {
            return false;
        }
        return Equals.equals(xYScatterPlotGlyph.yAxisGlyph, this.yAxisGlyph);
    }

    public Object clone() throws CloneNotSupportedException {
        XYScatterPlotGlyph xYScatterPlotGlyph = (XYScatterPlotGlyph)super.clone();
        if (this.xAxisGlyph != null) {
            xYScatterPlotGlyph.xAxisGlyph = (ValueAxisGlyph)this.xAxisGlyph.clone();
        }
        if (this.yAxisGlyph != null) {
            xYScatterPlotGlyph.yAxisGlyph = (ValueAxisGlyph)this.yAxisGlyph.clone();
        }
        return xYScatterPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.xAxisGlyph != null) {
            jSONObject.put("xAxisGlyph", this.xAxisGlyph.toJSONObject());
        }
        if (this.yAxisGlyph != null) {
            jSONObject.put("yAxisGlyph", this.yAxisGlyph.toJSONObject());
        }
        jSONObject.put("showLine", this.showLine);
        jSONObject.put("showMarker", this.showMarker);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }
}

