/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.legend;

import com.fr.base.DefaultValues;
import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ChartModule;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.LegendGlyph;
import com.fr.chart.legend.LegendItem;

public class Legend
extends ChartModule {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "Legend";
    private int position = 4;
    private FRFont frFont;
    private int maxShowLegendNumber = 10;
    private boolean legendVisible = true;
    private boolean autoAdjustSize = false;

    public Legend() {
        DefaultValues defaultValues = FRContext.getDefaultValues();
        this.frFont = defaultValues.getFRFont();
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public FRFont getFRFont() {
        return this.frFont;
    }

    public void setFRFont(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public void setMaxShowLegendNumber(int n) {
        this.maxShowLegendNumber = n;
    }

    public int getMaxShowLegendNumber() {
        return this.maxShowLegendNumber;
    }

    public void setLegendVisible(boolean bl) {
        this.legendVisible = bl;
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public LegendGlyph createLegendGlyph(LegendItem[] legendItemArray) {
        LegendGlyph legendGlyph;
        if (!this.isLegendVisible()) {
            return null;
        }
        if (this.maxShowLegendNumber < legendItemArray.length) {
            LegendItem[] legendItemArray2 = new LegendItem[this.maxShowLegendNumber];
            for (int i = 0; i < this.maxShowLegendNumber; ++i) {
                legendItemArray2[i] = legendItemArray[i];
            }
            legendGlyph = new LegendGlyph(legendItemArray2);
        } else {
            legendGlyph = new LegendGlyph(legendItemArray);
        }
        legendGlyph.setFont(this.frFont);
        legendGlyph.setInfo(this.getInfo());
        legendGlyph.setPosition(this.position);
        legendGlyph.setAutoAdjustSize(this.autoAdjustSize);
        return legendGlyph;
    }

    public Object clone() throws CloneNotSupportedException {
        Legend legend = (Legend)super.clone();
        if (this.getFRFont() != null) {
            legend.setFRFont((FRFont)this.getFRFont().clone());
        }
        return legend;
    }

    public void readXML(XMLableReader xMLableReader) {
        int n;
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            string = xMLableReader.getAttr("position");
            if (string != null) {
                this.setPosition(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("legendNum")) != null) {
                int n2 = -1;
                try {
                    n = Integer.parseInt(string);
                    n2 = n >= 0 ? n : -1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.setMaxShowLegendNumber(n2);
            }
        }
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if (BaseXMLUtils.isFRFontTagName(string2)) {
                this.setFRFont(BaseXMLUtils.readFRFont(xMLableReader));
            }
            if ("Attr".equals(string2)) {
                string = xMLableReader.getAttr("position");
                if (string != null) {
                    this.setPosition(Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("legendNum")) != null) {
                    n = -1;
                    try {
                        int n3 = Integer.parseInt(string);
                        n = n3 >= 0 ? n3 : -1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.setMaxShowLegendNumber(n);
                }
                if ((string = xMLableReader.getAttr("visible")) != null) {
                    this.setLegendVisible(Boolean.valueOf(string));
                }
                if ((string = xMLableReader.getAttr("autoAdjustSize")) != null) {
                    this.setAutoAdjustSize(Boolean.valueOf(string));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("position", this.getPosition()).attr("legendNum", this.getMaxShowLegendNumber()).attr("visible", this.legendVisible).attr("autoAdjustSize", this.autoAdjustSize).end();
        if (this.getFRFont() != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.getFRFont());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Legend)) {
            return false;
        }
        Legend legend = (Legend)object;
        if (!super.equals(legend)) {
            return false;
        }
        if (legend.legendVisible != this.legendVisible) {
            return false;
        }
        if (legend.maxShowLegendNumber != this.maxShowLegendNumber) {
            return false;
        }
        if (legend.getPosition() != this.getPosition()) {
            return false;
        }
        if (!Equals.equals(legend.frFont, this.frFont)) {
            return false;
        }
        return legend.autoAdjustSize == this.autoAdjustSize;
    }

    public void setAutoAdjustSize(boolean bl) {
        this.autoAdjustSize = bl;
    }

    public boolean isAutoAdjustSize() {
        return this.autoAdjustSize;
    }
}

