/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.legend;

import com.fr.base.FRFont;
import com.fr.base.XMLable;
import com.fr.base.core.BaseCoreConstants;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class LegendItem
implements XMLable {
    private static final long serialVersionUID = -3537790025233710932L;
    public static final int GAP = 2;
    public static final String XML_TAG = "LegendItem";
    private Rectangle2D bounds;
    private String label;
    private LineMarkerIcon lineMarkerIcon;

    public LegendItem() {
    }

    public LegendItem(String string) {
        this.setLabel(string);
    }

    public void setLineMarkerIcon(LineMarkerIcon lineMarkerIcon) {
        this.lineMarkerIcon = lineMarkerIcon;
    }

    public LineMarkerIcon getLineMarkerIcon() {
        return this.lineMarkerIcon;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void draw(Graphics graphics, FRFont fRFont) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getLineMarkerIcon() != null) {
            graphics2D.translate(this.bounds.getX(), this.bounds.getY());
            this.getLineMarkerIcon().paint(graphics2D, fRFont.getSize());
            graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
        }
        if (this.getLabel() != null) {
            Font font = graphics2D.getFont();
            Paint paint = graphics2D.getPaint();
            Composite composite = graphics2D.getComposite();
            graphics2D.setFont(fRFont);
            graphics2D.setPaint(fRFont.getForeground());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            GraphHelper.drawString(graphics2D, this.getLabel(), this.bounds.getX() + (double)fRFont.getSize() + 2.0, this.bounds.getY() + this.bounds.getHeight());
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
            graphics2D.setFont(font);
        }
    }

    public Dimension2D prefferedSize(FRFont fRFont) {
        int n = GraphHelper.getFontMetrics(fRFont).getHeight();
        int n2 = Math.max(n, fRFont.getSize());
        int n3 = (int)GraphHelper.stringWidth(this.getLabel(), fRFont, BaseCoreConstants.DEFAULT_FRC) + fRFont.getSize() + 2;
        return new Dimension(n3, n2);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.getBounds() != null) {
            ReportXMLUtils.writeBounds(xMLPrintWriter, this.getBounds());
        }
        if (this.getLabel() != null) {
            xMLPrintWriter.startTAG("Label").attr("label", this.getLabel()).end();
        }
        if (this.getLineMarkerIcon() != null) {
            this.getLineMarkerIcon().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Bounds")) {
                this.bounds = ReportXMLUtils.readBounds(xMLableReader);
            } else if (string.equals("Label")) {
                String string2 = xMLableReader.getAttr("label");
                if (string2 != null) {
                    this.setLabel(string2);
                }
            } else if (string.equals("LineMarkerIcon")) {
                this.setLineMarkerIcon((LineMarkerIcon)xMLableReader.readXMLObject(new LineMarkerIcon()));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LegendItem)) {
            return false;
        }
        LegendItem legendItem = (LegendItem)object;
        if (legendItem.getBounds() != null ? !legendItem.getBounds().equals(this.getBounds()) : this.getBounds() != null) {
            return false;
        }
        return Equals.equals(legendItem.getLineMarkerIcon(), this.getLineMarkerIcon());
    }

    public Object clone() throws CloneNotSupportedException {
        LegendItem legendItem = new LegendItem();
        return legendItem;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("label", this.label);
        if (this.lineMarkerIcon != null) {
            jSONObject.put("lineMarkerIcon", this.lineMarkerIcon.toJSONObject());
        }
        return jSONObject;
    }
}

