/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.legend;

import com.fr.base.XMLable;
import com.fr.base.background.Background;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.marker.Marker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;

public class LineMarkerIcon
implements XMLable {
    private static final long serialVersionUID = -888457366895932017L;
    public static final String XML_TAG = "LineMarkerIcon";
    private Background background;
    private Color color;
    private int lineStyle = 0;
    private Marker marker = null;
    private float alpha = 1.0f;

    public LineMarkerIcon() {
    }

    public LineMarkerIcon(Color color, int n, Marker marker) {
        this.setColor(color);
        this.setLineStyle(n);
        this.setMarker(marker);
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void paint(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        if (this.getColor() != null) {
            graphics2D.setPaint(this.getColor());
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
        boolean bl = true;
        if (this.getLineStyle() != 0) {
            GraphHelper.drawLine(graphics2D, 0.0, (double)n / 2.0, n, (double)n / 2.0, this.getLineStyle());
            bl = false;
        }
        if (this.getMarker() != null) {
            this.getMarker().paint(graphics2D, (double)n / 2.0, (double)n / 2.0);
            bl = false;
        }
        if (bl) {
            if (this.getColor() != null) {
                graphics2D.fill(new Rectangle(0, 0, n, n));
            }
            if (this.background != null) {
                this.background.paint(graphics2D, new Rectangle(0, 0, n, n));
            }
        }
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("alpha");
                if (string2 != null) {
                    this.setAlpha(Float.valueOf(string2).floatValue());
                }
                if ((string2 = xMLableReader.getAttr("color")) != null) {
                    this.setColor(new Color(Integer.parseInt(string2), true));
                }
                if ((string2 = xMLableReader.getAttr("lineStyle")) != null) {
                    this.setLineStyle(Integer.parseInt(string2));
                }
            } else if (string.equals("Background")) {
                this.background = BaseXMLUtils.readBackground(xMLableReader);
            } else if (string.equals("Marker")) {
                this.setMarker(BaseXMLUtils.readMarker(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("alpha", this.getAlpha());
        if (this.getColor() != null) {
            xMLPrintWriter.attr("color", this.getColor().getRGB());
        }
        xMLPrintWriter.attr("lineStyle", this.getLineStyle());
        xMLPrintWriter.end();
        if (this.getBackground() != null) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, this.getBackground());
        }
        if (this.getMarker() != null) {
            BaseXMLUtils.writeMarker(xMLPrintWriter, this.getMarker());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineMarkerIcon)) {
            return false;
        }
        LineMarkerIcon lineMarkerIcon = (LineMarkerIcon)object;
        if (lineMarkerIcon.getAlpha() != this.getAlpha()) {
            return false;
        }
        if (lineMarkerIcon.getLineStyle() != this.getLineStyle()) {
            return false;
        }
        if (!Equals.equals(lineMarkerIcon.color, this.color)) {
            return false;
        }
        if (!Equals.equals(lineMarkerIcon.marker, this.marker)) {
            return false;
        }
        return Equals.equals(lineMarkerIcon.background, this.background);
    }

    public Object clone() throws CloneNotSupportedException {
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        return lineMarkerIcon;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("color", ChartUtils.color2JS(this.color));
        jSONObject.put("lineStyle", this.lineStyle);
        jSONObject.put("alpha", this.alpha);
        if (this.marker != null) {
            jSONObject.put("markerType", this.marker.getMarkerType());
            jSONObject.put("marker", this.marker.toJSONObject());
        }
        if (this.background != null) {
            jSONObject.put("backgroundType", this.background.getBackgroundType());
            jSONObject.put("background", this.background.toJSONObject());
        }
        return jSONObject;
    }
}

